/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalTranscriptionJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartMedicalTranscriptionJobRequest.Builder, StartMedicalTranscriptionJobRequest> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MedicalTranscriptionJobName")
            .getter(getter(StartMedicalTranscriptionJobRequest::medicalTranscriptionJobName))
            .setter(setter(Builder::medicalTranscriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartMedicalTranscriptionJobRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz").getter(getter(StartMedicalTranscriptionJobRequest::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build())
            .build();

    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaFormat").getter(getter(StartMedicalTranscriptionJobRequest::mediaFormatAsString))
            .setter(setter(Builder::mediaFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()).build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartMedicalTranscriptionJobRequest::media)).setter(setter(Builder::media))
            .constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputBucketName").getter(getter(StartMedicalTranscriptionJobRequest::outputBucketName))
            .setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKey").getter(getter(StartMedicalTranscriptionJobRequest::outputKey))
            .setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartMedicalTranscriptionJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<MedicalTranscriptionSetting> SETTINGS_FIELD = SdkField
            .<MedicalTranscriptionSetting> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartMedicalTranscriptionJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(MedicalTranscriptionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(StartMedicalTranscriptionJobRequest::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> SPECIALTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specialty").getter(getter(StartMedicalTranscriptionJobRequest::specialtyAsString))
            .setter(setter(Builder::specialty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(StartMedicalTranscriptionJobRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD,
            MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_KEY_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, SETTINGS_FIELD,
            CONTENT_IDENTIFICATION_TYPE_FIELD, SPECIALTY_FIELD, TYPE_FIELD));

    private final String medicalTranscriptionJobName;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaFormat;

    private final Media media;

    private final String outputBucketName;

    private final String outputKey;

    private final String outputEncryptionKMSKeyId;

    private final MedicalTranscriptionSetting settings;

    private final String contentIdentificationType;

    private final String specialty;

    private final String type;

    private StartMedicalTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputKey = builder.outputKey;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.settings = builder.settings;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.specialty = builder.specialty;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the medical transcription job. You can't use the strings "<code>.</code>" or "<code>..</code>" by
     * themselves as the job name. The name must also be unique within an AWS account. If you try to create a medical
     * transcription job with the same name as a previous medical transcription job, you get a
     * <code>ConflictException</code> error.
     * </p>
     * 
     * @return The name of the medical transcription job. You can't use the strings "<code>.</code>" or "<code>..</code>
     *         " by themselves as the job name. The name must also be unique within an AWS account. If you try to create
     *         a medical transcription job with the same name as a previous medical transcription job, you get a
     *         <code>ConflictException</code> error.
     */
    public final String medicalTranscriptionJobName() {
        return medicalTranscriptionJobName;
    }

    /**
     * <p>
     * The language code for the language spoken in the input media file. US English (en-US) is the valid value for
     * medical transcription jobs. Any other value you enter for language code results in a
     * <code>BadRequestException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language spoken in the input media file. US English (en-US) is the valid value
     *         for medical transcription jobs. Any other value you enter for language code results in a
     *         <code>BadRequestException</code> error.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the language spoken in the input media file. US English (en-US) is the valid value for
     * medical transcription jobs. Any other value you enter for language code results in a
     * <code>BadRequestException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language spoken in the input media file. US English (en-US) is the valid value
     *         for medical transcription jobs. Any other value you enter for language code results in a
     *         <code>BadRequestException</code> error.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate, in Hertz, of the audio track in the input media file.
     * </p>
     * <p>
     * If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you specify
     * the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave
     * the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe Medical determine the sample rate.
     * </p>
     * 
     * @return The sample rate, in Hertz, of the audio track in the input media file.</p>
     *         <p>
     *         If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you
     *         specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you
     *         should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe Medical
     *         determine the sample rate.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * The audio format of the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return The audio format of the input media file.
     * @see MediaFormat
     */
    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(mediaFormat);
    }

    /**
     * <p>
     * The audio format of the input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return The audio format of the input media file.
     * @see MediaFormat
     */
    public final String mediaFormatAsString() {
        return mediaFormat;
    }

    /**
     * Returns the value of the Media property for this object.
     * 
     * @return The value of the Media property for this object.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The Amazon S3 location where the transcription is stored.
     * </p>
     * <p>
     * You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription results. Your
     * transcript appears in the S3 location you specify. When you call the <a>GetMedicalTranscriptionJob</a>, the
     * operation returns this location in the <code>TranscriptFileUri</code> field. The S3 bucket must have permissions
     * that allow Amazon Transcribe Medical to put files in the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles</a>.
     * </p>
     * <p>
     * You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the
     * <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key, Amazon Transcribe Medical uses
     * the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 location where the transcription is stored.</p>
     *         <p>
     *         You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription
     *         results. Your transcript appears in the S3 location you specify. When you call the
     *         <a>GetMedicalTranscriptionJob</a>, the operation returns this location in the
     *         <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe
     *         Medical to put files in the bucket. For more information, see <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles</a>.
     *         </p>
     *         <p>
     *         You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using
     *         the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key, Amazon Transcribe
     *         Medical uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your
     *         S3 bucket.
     */
    public final String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * You can specify a location in an Amazon S3 bucket to store the output of your medical transcription job.
     * </p>
     * <p>
     * If you don't specify an output key, Amazon Transcribe Medical stores the output of your transcription job in the
     * Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json".
     * </p>
     * <p>
     * You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For example,
     * specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being stored as
     * "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the output key,
     * the object key is changed to "my-other-job-name.json". You can use an output key to change both the prefix and
     * the file name, for example "folder/my-other-job-name.json".
     * </p>
     * <p>
     * If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code> parameter.
     * </p>
     * 
     * @return You can specify a location in an Amazon S3 bucket to store the output of your medical transcription
     *         job.</p>
     *         <p>
     *         If you don't specify an output key, Amazon Transcribe Medical stores the output of your transcription job
     *         in the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json".
     *         </p>
     *         <p>
     *         You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For
     *         example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output
     *         being stored as "folder1/folder2/your-transcription-job-name.json". If you specify
     *         "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You
     *         can use an output key to change both the prefix and the file name, for example
     *         "folder/my-other-job-name.json".
     *         </p>
     *         <p>
     *         If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code>
     *         parameter.
     */
    public final String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the
     * transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have permission to use
     * the specified KMS key.
     * </p>
     * <p>
     * You use either of the following to identify a KMS key in the current account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS Key Alias: "alias/ExampleAlias"
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use either of the following to identify a KMS key in the current account or another account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS key in the current account or another account:
     * "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify an encryption key, the output of the medical transcription job is encrypted with the default
     * Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * If you specify a KMS key to encrypt your output, you must also specify an output location in the
     * <code>OutputBucketName</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of
     *         the transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have
     *         permission to use the specified KMS key.</p>
     *         <p>
     *         You use either of the following to identify a KMS key in the current account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS Key Alias: "alias/ExampleAlias"
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can use either of the following to identify a KMS key in the current account or another account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS key in the current account or another account:
     *         "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify an encryption key, the output of the medical transcription job is encrypted with the
     *         default Amazon S3 key (SSE-S3).
     *         </p>
     *         <p>
     *         If you specify a KMS key to encrypt your output, you must also specify an output location in the
     *         <code>OutputBucketName</code> parameter.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * <p>
     * Optional settings for the medical transcription job.
     * </p>
     * 
     * @return Optional settings for the medical transcription job.
     */
    public final MedicalTranscriptionSetting settings() {
        return settings;
    }

    /**
     * <p>
     * You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
     * <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies in
     * the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
     *         <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it
     *         identifies in the transcription output.
     * @see MedicalContentIdentificationType
     */
    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
     * <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies in
     * the transcription output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
     *         <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it
     *         identifies in the transcription output.
     * @see MedicalContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * The medical specialty of any clinician speaking in the input media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return The medical specialty of any clinician speaking in the input media.
     * @see Specialty
     */
    public final Specialty specialty() {
        return Specialty.fromValue(specialty);
    }

    /**
     * <p>
     * The medical specialty of any clinician speaking in the input media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return The medical specialty of any clinician speaking in the input media.
     * @see Specialty
     */
    public final String specialtyAsString() {
        return specialty;
    }

    /**
     * <p>
     * The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more
     * speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker
     * dictated speech, e.g., for clinical notes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or
     *         more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to
     *         single-speaker dictated speech, e.g., for clinical notes.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more
     * speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker
     * dictated speech, e.g., for clinical notes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or
     *         more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to
     *         single-speaker dictated speech, e.g., for clinical notes.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalTranscriptionJobRequest)) {
            return false;
        }
        StartMedicalTranscriptionJobRequest other = (StartMedicalTranscriptionJobRequest) obj;
        return Objects.equals(medicalTranscriptionJobName(), other.medicalTranscriptionJobName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(media(), other.media())
                && Objects.equals(outputBucketName(), other.outputBucketName()) && Objects.equals(outputKey(), other.outputKey())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(specialtyAsString(), other.specialtyAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalTranscriptionJobRequest")
                .add("MedicalTranscriptionJobName", medicalTranscriptionJobName()).add("LanguageCode", languageCodeAsString())
                .add("MediaSampleRateHertz", mediaSampleRateHertz()).add("MediaFormat", mediaFormatAsString())
                .add("Media", media()).add("OutputBucketName", outputBucketName()).add("OutputKey", outputKey())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId()).add("Settings", settings())
                .add("ContentIdentificationType", contentIdentificationTypeAsString()).add("Specialty", specialtyAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalTranscriptionJobName":
            return Optional.ofNullable(clazz.cast(medicalTranscriptionJobName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaFormat":
            return Optional.ofNullable(clazz.cast(mediaFormatAsString()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "Specialty":
            return Optional.ofNullable(clazz.cast(specialtyAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartMedicalTranscriptionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMedicalTranscriptionJobRequest> {
        /**
         * <p>
         * The name of the medical transcription job. You can't use the strings "<code>.</code>" or "<code>..</code>" by
         * themselves as the job name. The name must also be unique within an AWS account. If you try to create a
         * medical transcription job with the same name as a previous medical transcription job, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param medicalTranscriptionJobName
         *        The name of the medical transcription job. You can't use the strings "<code>.</code>" or "
         *        <code>..</code>" by themselves as the job name. The name must also be unique within an AWS account. If
         *        you try to create a medical transcription job with the same name as a previous medical transcription
         *        job, you get a <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJobName(String medicalTranscriptionJobName);

        /**
         * <p>
         * The language code for the language spoken in the input media file. US English (en-US) is the valid value for
         * medical transcription jobs. Any other value you enter for language code results in a
         * <code>BadRequestException</code> error.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language spoken in the input media file. US English (en-US) is the valid
         *        value for medical transcription jobs. Any other value you enter for language code results in a
         *        <code>BadRequestException</code> error.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the language spoken in the input media file. US English (en-US) is the valid value for
         * medical transcription jobs. Any other value you enter for language code results in a
         * <code>BadRequestException</code> error.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language spoken in the input media file. US English (en-US) is the valid
         *        value for medical transcription jobs. Any other value you enter for language code results in a
         *        <code>BadRequestException</code> error.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate, in Hertz, of the audio track in the input media file.
         * </p>
         * <p>
         * If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you
         * specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you
         * should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe Medical determine
         * the sample rate.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate, in Hertz, of the audio track in the input media file.</p>
         *        <p>
         *        If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If
         *        you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most
         *        cases, you should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe
         *        Medical determine the sample rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * The audio format of the input media file.
         * </p>
         * 
         * @param mediaFormat
         *        The audio format of the input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(String mediaFormat);

        /**
         * <p>
         * The audio format of the input media file.
         * </p>
         * 
         * @param mediaFormat
         *        The audio format of the input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(MediaFormat mediaFormat);

        /**
         * Sets the value of the Media property for this object.
         *
         * @param media
         *        The new value for the Media property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * Sets the value of the Media property for this object.
         *
         * This is a convenience that creates an instance of the {@link Media.Builder} avoiding the need to create one
         * manually via {@link Media#builder()}.
         *
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The Amazon S3 location where the transcription is stored.
         * </p>
         * <p>
         * You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription results.
         * Your transcript appears in the S3 location you specify. When you call the <a>GetMedicalTranscriptionJob</a>,
         * the operation returns this location in the <code>TranscriptFileUri</code> field. The S3 bucket must have
         * permissions that allow Amazon Transcribe Medical to put files in the bucket. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles</a>.
         * </p>
         * <p>
         * You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the
         * <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key, Amazon Transcribe Medical
         * uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.
         * </p>
         * 
         * @param outputBucketName
         *        The Amazon S3 location where the transcription is stored.</p>
         *        <p>
         *        You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription
         *        results. Your transcript appears in the S3 location you specify. When you call the
         *        <a>GetMedicalTranscriptionJob</a>, the operation returns this location in the
         *        <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe
         *        Medical to put files in the bucket. For more information, see <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles</a>.
         *        </p>
         *        <p>
         *        You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription
         *        using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key, Amazon
         *        Transcribe Medical uses the default Amazon S3 key for server-side encryption of transcripts that are
         *        placed in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * You can specify a location in an Amazon S3 bucket to store the output of your medical transcription job.
         * </p>
         * <p>
         * If you don't specify an output key, Amazon Transcribe Medical stores the output of your transcription job in
         * the Amazon S3 bucket you specified. By default, the object key is "your-transcription-job-name.json".
         * </p>
         * <p>
         * You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For
         * example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the output being
         * stored as "folder1/folder2/your-transcription-job-name.json". If you specify "my-other-job-name.json" as the
         * output key, the object key is changed to "my-other-job-name.json". You can use an output key to change both
         * the prefix and the file name, for example "folder/my-other-job-name.json".
         * </p>
         * <p>
         * If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code>
         * parameter.
         * </p>
         * 
         * @param outputKey
         *        You can specify a location in an Amazon S3 bucket to store the output of your medical transcription
         *        job.</p>
         *        <p>
         *        If you don't specify an output key, Amazon Transcribe Medical stores the output of your transcription
         *        job in the Amazon S3 bucket you specified. By default, the object key is
         *        "your-transcription-job-name.json".
         *        </p>
         *        <p>
         *        You can use output keys to specify the Amazon S3 prefix and file name of the transcription output. For
         *        example, specifying the Amazon S3 prefix, "folder1/folder2/", as an output key would lead to the
         *        output being stored as "folder1/folder2/your-transcription-job-name.json". If you specify
         *        "my-other-job-name.json" as the output key, the object key is changed to "my-other-job-name.json". You
         *        can use an output key to change both the prefix and the file name, for example
         *        "folder/my-other-job-name.json".
         *        </p>
         *        <p>
         *        If you specify an output key, you must also specify an S3 bucket in the <code>OutputBucketName</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the
         * transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have permission to
         * use the specified KMS key.
         * </p>
         * <p>
         * You use either of the following to identify a KMS key in the current account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS Key Alias: "alias/ExampleAlias"
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can use either of the following to identify a KMS key in the current account or another account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS key in the current account or another account:
         * "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify an encryption key, the output of the medical transcription job is encrypted with the
         * default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * If you specify a KMS key to encrypt your output, you must also specify an output location in the
         * <code>OutputBucketName</code> parameter.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output
         *        of the transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have
         *        permission to use the specified KMS key.</p>
         *        <p>
         *        You use either of the following to identify a KMS key in the current account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS Key Alias: "alias/ExampleAlias"
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can use either of the following to identify a KMS key in the current account or another account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS key in the current account or another account:
         *        "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify an encryption key, the output of the medical transcription job is encrypted with
         *        the default Amazon S3 key (SSE-S3).
         *        </p>
         *        <p>
         *        If you specify a KMS key to encrypt your output, you must also specify an output location in the
         *        <code>OutputBucketName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * Optional settings for the medical transcription job.
         * </p>
         * 
         * @param settings
         *        Optional settings for the medical transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(MedicalTranscriptionSetting settings);

        /**
         * <p>
         * Optional settings for the medical transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link MedicalTranscriptionSetting.Builder} avoiding
         * the need to create one manually via {@link MedicalTranscriptionSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link MedicalTranscriptionSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #settings(MedicalTranscriptionSetting)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link MedicalTranscriptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(MedicalTranscriptionSetting)
         */
        default Builder settings(Consumer<MedicalTranscriptionSetting.Builder> settings) {
            return settings(MedicalTranscriptionSetting.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
         * <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies
         * in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        You can configure Amazon Transcribe Medical to label content in the transcription output. If you
         *        specify <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that
         *        it identifies in the transcription output.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * You can configure Amazon Transcribe Medical to label content in the transcription output. If you specify
         * <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that it identifies
         * in the transcription output.
         * </p>
         * 
         * @param contentIdentificationType
         *        You can configure Amazon Transcribe Medical to label content in the transcription output. If you
         *        specify <code>PHI</code>, Amazon Transcribe Medical labels the personal health information (PHI) that
         *        it identifies in the transcription output.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * The medical specialty of any clinician speaking in the input media.
         * </p>
         * 
         * @param specialty
         *        The medical specialty of any clinician speaking in the input media.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(String specialty);

        /**
         * <p>
         * The medical specialty of any clinician speaking in the input media.
         * </p>
         * 
         * @param specialty
         *        The medical specialty of any clinician speaking in the input media.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(Specialty specialty);

        /**
         * <p>
         * The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more
         * speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker
         * dictated speech, e.g., for clinical notes.
         * </p>
         * 
         * @param type
         *        The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two
         *        or more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to
         *        single-speaker dictated speech, e.g., for clinical notes.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more
         * speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker
         * dictated speech, e.g., for clinical notes.
         * </p>
         * 
         * @param type
         *        The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two
         *        or more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to
         *        single-speaker dictated speech, e.g., for clinical notes.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String medicalTranscriptionJobName;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaFormat;

        private Media media;

        private String outputBucketName;

        private String outputKey;

        private String outputEncryptionKMSKeyId;

        private MedicalTranscriptionSetting settings;

        private String contentIdentificationType;

        private String specialty;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalTranscriptionJobRequest model) {
            super(model);
            medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaFormat(model.mediaFormat);
            media(model.media);
            outputBucketName(model.outputBucketName);
            outputKey(model.outputKey);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            settings(model.settings);
            contentIdentificationType(model.contentIdentificationType);
            specialty(model.specialty);
            type(model.type);
        }

        public final String getMedicalTranscriptionJobName() {
            return medicalTranscriptionJobName;
        }

        @Override
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaFormat() {
            return mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        public final String getOutputKey() {
            return outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        public final MedicalTranscriptionSetting.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(MedicalTranscriptionSetting settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(MedicalTranscriptionSetting.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        public final String getSpecialty() {
            return specialty;
        }

        @Override
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalTranscriptionJobRequest build() {
            return new StartMedicalTranscriptionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
