/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCallAnalyticsJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<GetCallAnalyticsJobRequest.Builder, GetCallAnalyticsJobRequest> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallAnalyticsJobName").getter(getter(GetCallAnalyticsJobRequest::callAnalyticsJobName))
            .setter(setter(Builder::callAnalyticsJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD));

    private final String callAnalyticsJobName;

    private GetCallAnalyticsJobRequest(BuilderImpl builder) {
        super(builder);
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
    }

    /**
     * <p>
     * The name of the analytics job you want information about. This value is case sensitive.
     * </p>
     * 
     * @return The name of the analytics job you want information about. This value is case sensitive.
     */
    public final String callAnalyticsJobName() {
        return callAnalyticsJobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJobName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCallAnalyticsJobRequest)) {
            return false;
        }
        GetCallAnalyticsJobRequest other = (GetCallAnalyticsJobRequest) obj;
        return Objects.equals(callAnalyticsJobName(), other.callAnalyticsJobName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCallAnalyticsJobRequest").add("CallAnalyticsJobName", callAnalyticsJobName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallAnalyticsJobName":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCallAnalyticsJobRequest, T> g) {
        return obj -> g.apply((GetCallAnalyticsJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCallAnalyticsJobRequest> {
        /**
         * <p>
         * The name of the analytics job you want information about. This value is case sensitive.
         * </p>
         * 
         * @param callAnalyticsJobName
         *        The name of the analytics job you want information about. This value is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobName(String callAnalyticsJobName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String callAnalyticsJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCallAnalyticsJobRequest model) {
            super(model);
            callAnalyticsJobName(model.callAnalyticsJobName);
        }

        public final String getCallAnalyticsJobName() {
            return callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        @Transient
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCallAnalyticsJobRequest build() {
            return new GetCallAnalyticsJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
