/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Matches the output of the transcription to either the specific phrases that you specify, or the intent of the phrases
 * that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptFilter.Builder, TranscriptFilter> {
    private static final SdkField<String> TRANSCRIPT_FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptFilterType").getter(getter(TranscriptFilter::transcriptFilterTypeAsString))
            .setter(setter(Builder::transcriptFilterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFilterType").build())
            .build();

    private static final SdkField<AbsoluteTimeRange> ABSOLUTE_TIME_RANGE_FIELD = SdkField
            .<AbsoluteTimeRange> builder(MarshallingType.SDK_POJO).memberName("AbsoluteTimeRange")
            .getter(getter(TranscriptFilter::absoluteTimeRange)).setter(setter(Builder::absoluteTimeRange))
            .constructor(AbsoluteTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTimeRange").build()).build();

    private static final SdkField<RelativeTimeRange> RELATIVE_TIME_RANGE_FIELD = SdkField
            .<RelativeTimeRange> builder(MarshallingType.SDK_POJO).memberName("RelativeTimeRange")
            .getter(getter(TranscriptFilter::relativeTimeRange)).setter(setter(Builder::relativeTimeRange))
            .constructor(RelativeTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeTimeRange").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(TranscriptFilter::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negate").getter(getter(TranscriptFilter::negate)).setter(setter(Builder::negate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(TranscriptFilter::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILTER_TYPE_FIELD,
            ABSOLUTE_TIME_RANGE_FIELD, RELATIVE_TIME_RANGE_FIELD, PARTICIPANT_ROLE_FIELD, NEGATE_FIELD, TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptFilterType;

    private final AbsoluteTimeRange absoluteTimeRange;

    private final RelativeTimeRange relativeTimeRange;

    private final String participantRole;

    private final Boolean negate;

    private final List<String> targets;

    private TranscriptFilter(BuilderImpl builder) {
        this.transcriptFilterType = builder.transcriptFilterType;
        this.absoluteTimeRange = builder.absoluteTimeRange;
        this.relativeTimeRange = builder.relativeTimeRange;
        this.participantRole = builder.participantRole;
        this.negate = builder.negate;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * Matches the phrase to the transcription output in a word for word fashion. For example, if you specify the phrase
     * "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptFilterType} will return {@link TranscriptFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptFilterTypeAsString}.
     * </p>
     * 
     * @return Matches the phrase to the transcription output in a word for word fashion. For example, if you specify
     *         the phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to
     *         the transcription.
     * @see TranscriptFilterType
     */
    public final TranscriptFilterType transcriptFilterType() {
        return TranscriptFilterType.fromValue(transcriptFilterType);
    }

    /**
     * <p>
     * Matches the phrase to the transcription output in a word for word fashion. For example, if you specify the phrase
     * "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptFilterType} will return {@link TranscriptFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptFilterTypeAsString}.
     * </p>
     * 
     * @return Matches the phrase to the transcription output in a word for word fashion. For example, if you specify
     *         the phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to
     *         the transcription.
     * @see TranscriptFilterType
     */
    public final String transcriptFilterTypeAsString() {
        return transcriptFilterType;
    }

    /**
     * <p>
     * A time range, set in seconds, between two points in the call.
     * </p>
     * 
     * @return A time range, set in seconds, between two points in the call.
     */
    public final AbsoluteTimeRange absoluteTimeRange() {
        return absoluteTimeRange;
    }

    /**
     * <p>
     * An object that allows percentages to specify the proportion of the call where you would like to apply a filter.
     * For example, you can specify the first half of the call. You can also specify the period of time between halfway
     * through to three-quarters of the way through the call. Because the length of conversation can vary between calls,
     * you can apply relative time ranges across all calls.
     * </p>
     * 
     * @return An object that allows percentages to specify the proportion of the call where you would like to apply a
     *         filter. For example, you can specify the first half of the call. You can also specify the period of time
     *         between halfway through to three-quarters of the way through the call. Because the length of conversation
     *         can vary between calls, you can apply relative time ranges across all calls.
     */
    public final RelativeTimeRange relativeTimeRange() {
        return relativeTimeRange;
    }

    /**
     * <p>
     * Determines whether the customer or the agent is speaking the phrases that you've specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Determines whether the customer or the agent is speaking the phrases that you've specified.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * Determines whether the customer or the agent is speaking the phrases that you've specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Determines whether the customer or the agent is speaking the phrases that you've specified.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * If <code>TRUE</code>, the rule that you specify is applied to everything except for the phrases that you specify.
     * </p>
     * 
     * @return If <code>TRUE</code>, the rule that you specify is applied to everything except for the phrases that you
     *         specify.
     */
    public final Boolean negate() {
        return negate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The phrases that you're specifying for the transcript filter to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The phrases that you're specifying for the transcript filter to match.
     */
    public final List<String> targets() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFilterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(relativeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(negate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptFilter)) {
            return false;
        }
        TranscriptFilter other = (TranscriptFilter) obj;
        return Objects.equals(transcriptFilterTypeAsString(), other.transcriptFilterTypeAsString())
                && Objects.equals(absoluteTimeRange(), other.absoluteTimeRange())
                && Objects.equals(relativeTimeRange(), other.relativeTimeRange())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(negate(), other.negate()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptFilter").add("TranscriptFilterType", transcriptFilterTypeAsString())
                .add("AbsoluteTimeRange", absoluteTimeRange()).add("RelativeTimeRange", relativeTimeRange())
                .add("ParticipantRole", participantRoleAsString()).add("Negate", negate())
                .add("Targets", hasTargets() ? targets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptFilterType":
            return Optional.ofNullable(clazz.cast(transcriptFilterTypeAsString()));
        case "AbsoluteTimeRange":
            return Optional.ofNullable(clazz.cast(absoluteTimeRange()));
        case "RelativeTimeRange":
            return Optional.ofNullable(clazz.cast(relativeTimeRange()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "Negate":
            return Optional.ofNullable(clazz.cast(negate()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptFilter, T> g) {
        return obj -> g.apply((TranscriptFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptFilter> {
        /**
         * <p>
         * Matches the phrase to the transcription output in a word for word fashion. For example, if you specify the
         * phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to the
         * transcription.
         * </p>
         * 
         * @param transcriptFilterType
         *        Matches the phrase to the transcription output in a word for word fashion. For example, if you specify
         *        the phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase
         *        to the transcription.
         * @see TranscriptFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptFilterType
         */
        Builder transcriptFilterType(String transcriptFilterType);

        /**
         * <p>
         * Matches the phrase to the transcription output in a word for word fashion. For example, if you specify the
         * phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase to the
         * transcription.
         * </p>
         * 
         * @param transcriptFilterType
         *        Matches the phrase to the transcription output in a word for word fashion. For example, if you specify
         *        the phrase "I want to speak to the manager." Amazon Transcribe attempts to match that specific phrase
         *        to the transcription.
         * @see TranscriptFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptFilterType
         */
        Builder transcriptFilterType(TranscriptFilterType transcriptFilterType);

        /**
         * <p>
         * A time range, set in seconds, between two points in the call.
         * </p>
         * 
         * @param absoluteTimeRange
         *        A time range, set in seconds, between two points in the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange);

        /**
         * <p>
         * A time range, set in seconds, between two points in the call.
         * </p>
         * This is a convenience that creates an instance of the {@link AbsoluteTimeRange.Builder} avoiding the need to
         * create one manually via {@link AbsoluteTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbsoluteTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #absoluteTimeRange(AbsoluteTimeRange)}.
         * 
         * @param absoluteTimeRange
         *        a consumer that will call methods on {@link AbsoluteTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #absoluteTimeRange(AbsoluteTimeRange)
         */
        default Builder absoluteTimeRange(Consumer<AbsoluteTimeRange.Builder> absoluteTimeRange) {
            return absoluteTimeRange(AbsoluteTimeRange.builder().applyMutation(absoluteTimeRange).build());
        }

        /**
         * <p>
         * An object that allows percentages to specify the proportion of the call where you would like to apply a
         * filter. For example, you can specify the first half of the call. You can also specify the period of time
         * between halfway through to three-quarters of the way through the call. Because the length of conversation can
         * vary between calls, you can apply relative time ranges across all calls.
         * </p>
         * 
         * @param relativeTimeRange
         *        An object that allows percentages to specify the proportion of the call where you would like to apply
         *        a filter. For example, you can specify the first half of the call. You can also specify the period of
         *        time between halfway through to three-quarters of the way through the call. Because the length of
         *        conversation can vary between calls, you can apply relative time ranges across all calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeTimeRange(RelativeTimeRange relativeTimeRange);

        /**
         * <p>
         * An object that allows percentages to specify the proportion of the call where you would like to apply a
         * filter. For example, you can specify the first half of the call. You can also specify the period of time
         * between halfway through to three-quarters of the way through the call. Because the length of conversation can
         * vary between calls, you can apply relative time ranges across all calls.
         * </p>
         * This is a convenience that creates an instance of the {@link RelativeTimeRange.Builder} avoiding the need to
         * create one manually via {@link RelativeTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link RelativeTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #relativeTimeRange(RelativeTimeRange)}.
         * 
         * @param relativeTimeRange
         *        a consumer that will call methods on {@link RelativeTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeTimeRange(RelativeTimeRange)
         */
        default Builder relativeTimeRange(Consumer<RelativeTimeRange.Builder> relativeTimeRange) {
            return relativeTimeRange(RelativeTimeRange.builder().applyMutation(relativeTimeRange).build());
        }

        /**
         * <p>
         * Determines whether the customer or the agent is speaking the phrases that you've specified.
         * </p>
         * 
         * @param participantRole
         *        Determines whether the customer or the agent is speaking the phrases that you've specified.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * Determines whether the customer or the agent is speaking the phrases that you've specified.
         * </p>
         * 
         * @param participantRole
         *        Determines whether the customer or the agent is speaking the phrases that you've specified.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * If <code>TRUE</code>, the rule that you specify is applied to everything except for the phrases that you
         * specify.
         * </p>
         * 
         * @param negate
         *        If <code>TRUE</code>, the rule that you specify is applied to everything except for the phrases that
         *        you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negate(Boolean negate);

        /**
         * <p>
         * The phrases that you're specifying for the transcript filter to match.
         * </p>
         * 
         * @param targets
         *        The phrases that you're specifying for the transcript filter to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The phrases that you're specifying for the transcript filter to match.
         * </p>
         * 
         * @param targets
         *        The phrases that you're specifying for the transcript filter to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptFilterType;

        private AbsoluteTimeRange absoluteTimeRange;

        private RelativeTimeRange relativeTimeRange;

        private String participantRole;

        private Boolean negate;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptFilter model) {
            transcriptFilterType(model.transcriptFilterType);
            absoluteTimeRange(model.absoluteTimeRange);
            relativeTimeRange(model.relativeTimeRange);
            participantRole(model.participantRole);
            negate(model.negate);
            targets(model.targets);
        }

        public final String getTranscriptFilterType() {
            return transcriptFilterType;
        }

        public final void setTranscriptFilterType(String transcriptFilterType) {
            this.transcriptFilterType = transcriptFilterType;
        }

        @Override
        @Transient
        public final Builder transcriptFilterType(String transcriptFilterType) {
            this.transcriptFilterType = transcriptFilterType;
            return this;
        }

        @Override
        @Transient
        public final Builder transcriptFilterType(TranscriptFilterType transcriptFilterType) {
            this.transcriptFilterType(transcriptFilterType == null ? null : transcriptFilterType.toString());
            return this;
        }

        public final AbsoluteTimeRange.Builder getAbsoluteTimeRange() {
            return absoluteTimeRange != null ? absoluteTimeRange.toBuilder() : null;
        }

        public final void setAbsoluteTimeRange(AbsoluteTimeRange.BuilderImpl absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange != null ? absoluteTimeRange.build() : null;
        }

        @Override
        @Transient
        public final Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange;
            return this;
        }

        public final RelativeTimeRange.Builder getRelativeTimeRange() {
            return relativeTimeRange != null ? relativeTimeRange.toBuilder() : null;
        }

        public final void setRelativeTimeRange(RelativeTimeRange.BuilderImpl relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange != null ? relativeTimeRange.build() : null;
        }

        @Override
        @Transient
        public final Builder relativeTimeRange(RelativeTimeRange relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        @Transient
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        @Transient
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Boolean getNegate() {
            return negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        @Transient
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = StringTargetListCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<String> targets) {
            this.targets = StringTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        public TranscriptFilter build() {
            return new TranscriptFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
