/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A condition in the call between the customer and the agent that you want to filter for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<NonTalkTimeFilter> NON_TALK_TIME_FILTER_FIELD = SdkField
            .<NonTalkTimeFilter> builder(MarshallingType.SDK_POJO).memberName("NonTalkTimeFilter")
            .getter(getter(Rule::nonTalkTimeFilter)).setter(setter(Builder::nonTalkTimeFilter))
            .constructor(NonTalkTimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonTalkTimeFilter").build()).build();

    private static final SdkField<InterruptionFilter> INTERRUPTION_FILTER_FIELD = SdkField
            .<InterruptionFilter> builder(MarshallingType.SDK_POJO).memberName("InterruptionFilter")
            .getter(getter(Rule::interruptionFilter)).setter(setter(Builder::interruptionFilter))
            .constructor(InterruptionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionFilter").build())
            .build();

    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField
            .<TranscriptFilter> builder(MarshallingType.SDK_POJO).memberName("TranscriptFilter")
            .getter(getter(Rule::transcriptFilter)).setter(setter(Builder::transcriptFilter))
            .constructor(TranscriptFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFilter").build()).build();

    private static final SdkField<SentimentFilter> SENTIMENT_FILTER_FIELD = SdkField
            .<SentimentFilter> builder(MarshallingType.SDK_POJO).memberName("SentimentFilter")
            .getter(getter(Rule::sentimentFilter)).setter(setter(Builder::sentimentFilter)).constructor(SentimentFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_TALK_TIME_FILTER_FIELD,
            INTERRUPTION_FILTER_FIELD, TRANSCRIPT_FILTER_FIELD, SENTIMENT_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final NonTalkTimeFilter nonTalkTimeFilter;

    private final InterruptionFilter interruptionFilter;

    private final TranscriptFilter transcriptFilter;

    private final SentimentFilter sentimentFilter;

    private Rule(BuilderImpl builder) {
        this.nonTalkTimeFilter = builder.nonTalkTimeFilter;
        this.interruptionFilter = builder.interruptionFilter;
        this.transcriptFilter = builder.transcriptFilter;
        this.sentimentFilter = builder.sentimentFilter;
    }

    /**
     * <p>
     * A condition for a time period when neither the customer nor the agent was talking.
     * </p>
     * 
     * @return A condition for a time period when neither the customer nor the agent was talking.
     */
    public final NonTalkTimeFilter nonTalkTimeFilter() {
        return nonTalkTimeFilter;
    }

    /**
     * <p>
     * A condition for a time period when either the customer or agent was interrupting the other person.
     * </p>
     * 
     * @return A condition for a time period when either the customer or agent was interrupting the other person.
     */
    public final InterruptionFilter interruptionFilter() {
        return interruptionFilter;
    }

    /**
     * <p>
     * A condition that catches particular words or phrases based on a exact match. For example, if you set the phrase
     * "I want to speak to the manager", only that exact phrase will be returned.
     * </p>
     * 
     * @return A condition that catches particular words or phrases based on a exact match. For example, if you set the
     *         phrase "I want to speak to the manager", only that exact phrase will be returned.
     */
    public final TranscriptFilter transcriptFilter() {
        return transcriptFilter;
    }

    /**
     * <p>
     * A condition that is applied to a particular customer sentiment.
     * </p>
     * 
     * @return A condition that is applied to a particular customer sentiment.
     */
    public final SentimentFilter sentimentFilter() {
        return sentimentFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonTalkTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(interruptionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(nonTalkTimeFilter(), other.nonTalkTimeFilter())
                && Objects.equals(interruptionFilter(), other.interruptionFilter())
                && Objects.equals(transcriptFilter(), other.transcriptFilter())
                && Objects.equals(sentimentFilter(), other.sentimentFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("NonTalkTimeFilter", nonTalkTimeFilter())
                .add("InterruptionFilter", interruptionFilter()).add("TranscriptFilter", transcriptFilter())
                .add("SentimentFilter", sentimentFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonTalkTimeFilter":
            return Optional.ofNullable(clazz.cast(nonTalkTimeFilter()));
        case "InterruptionFilter":
            return Optional.ofNullable(clazz.cast(interruptionFilter()));
        case "TranscriptFilter":
            return Optional.ofNullable(clazz.cast(transcriptFilter()));
        case "SentimentFilter":
            return Optional.ofNullable(clazz.cast(sentimentFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * A condition for a time period when neither the customer nor the agent was talking.
         * </p>
         * 
         * @param nonTalkTimeFilter
         *        A condition for a time period when neither the customer nor the agent was talking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter);

        /**
         * <p>
         * A condition for a time period when neither the customer nor the agent was talking.
         * </p>
         * This is a convenience that creates an instance of the {@link NonTalkTimeFilter.Builder} avoiding the need to
         * create one manually via {@link NonTalkTimeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link NonTalkTimeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #nonTalkTimeFilter(NonTalkTimeFilter)}.
         * 
         * @param nonTalkTimeFilter
         *        a consumer that will call methods on {@link NonTalkTimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonTalkTimeFilter(NonTalkTimeFilter)
         */
        default Builder nonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
            return nonTalkTimeFilter(NonTalkTimeFilter.builder().applyMutation(nonTalkTimeFilter).build());
        }

        /**
         * <p>
         * A condition for a time period when either the customer or agent was interrupting the other person.
         * </p>
         * 
         * @param interruptionFilter
         *        A condition for a time period when either the customer or agent was interrupting the other person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interruptionFilter(InterruptionFilter interruptionFilter);

        /**
         * <p>
         * A condition for a time period when either the customer or agent was interrupting the other person.
         * </p>
         * This is a convenience that creates an instance of the {@link InterruptionFilter.Builder} avoiding the need to
         * create one manually via {@link InterruptionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link InterruptionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #interruptionFilter(InterruptionFilter)}.
         * 
         * @param interruptionFilter
         *        a consumer that will call methods on {@link InterruptionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interruptionFilter(InterruptionFilter)
         */
        default Builder interruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
            return interruptionFilter(InterruptionFilter.builder().applyMutation(interruptionFilter).build());
        }

        /**
         * <p>
         * A condition that catches particular words or phrases based on a exact match. For example, if you set the
         * phrase "I want to speak to the manager", only that exact phrase will be returned.
         * </p>
         * 
         * @param transcriptFilter
         *        A condition that catches particular words or phrases based on a exact match. For example, if you set
         *        the phrase "I want to speak to the manager", only that exact phrase will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFilter(TranscriptFilter transcriptFilter);

        /**
         * <p>
         * A condition that catches particular words or phrases based on a exact match. For example, if you set the
         * phrase "I want to speak to the manager", only that exact phrase will be returned.
         * </p>
         * This is a convenience that creates an instance of the {@link TranscriptFilter.Builder} avoiding the need to
         * create one manually via {@link TranscriptFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link TranscriptFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #transcriptFilter(TranscriptFilter)}.
         * 
         * @param transcriptFilter
         *        a consumer that will call methods on {@link TranscriptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptFilter(TranscriptFilter)
         */
        default Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return transcriptFilter(TranscriptFilter.builder().applyMutation(transcriptFilter).build());
        }

        /**
         * <p>
         * A condition that is applied to a particular customer sentiment.
         * </p>
         * 
         * @param sentimentFilter
         *        A condition that is applied to a particular customer sentiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentFilter(SentimentFilter sentimentFilter);

        /**
         * <p>
         * A condition that is applied to a particular customer sentiment.
         * </p>
         * This is a convenience that creates an instance of the {@link SentimentFilter.Builder} avoiding the need to
         * create one manually via {@link SentimentFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link SentimentFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentFilter(SentimentFilter)}.
         * 
         * @param sentimentFilter
         *        a consumer that will call methods on {@link SentimentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentFilter(SentimentFilter)
         */
        default Builder sentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
            return sentimentFilter(SentimentFilter.builder().applyMutation(sentimentFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NonTalkTimeFilter nonTalkTimeFilter;

        private InterruptionFilter interruptionFilter;

        private TranscriptFilter transcriptFilter;

        private SentimentFilter sentimentFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            nonTalkTimeFilter(model.nonTalkTimeFilter);
            interruptionFilter(model.interruptionFilter);
            transcriptFilter(model.transcriptFilter);
            sentimentFilter(model.sentimentFilter);
        }

        public final NonTalkTimeFilter.Builder getNonTalkTimeFilter() {
            return nonTalkTimeFilter != null ? nonTalkTimeFilter.toBuilder() : null;
        }

        public final void setNonTalkTimeFilter(NonTalkTimeFilter.BuilderImpl nonTalkTimeFilter) {
            this.nonTalkTimeFilter = nonTalkTimeFilter != null ? nonTalkTimeFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
            this.nonTalkTimeFilter = nonTalkTimeFilter;
            return this;
        }

        public final InterruptionFilter.Builder getInterruptionFilter() {
            return interruptionFilter != null ? interruptionFilter.toBuilder() : null;
        }

        public final void setInterruptionFilter(InterruptionFilter.BuilderImpl interruptionFilter) {
            this.interruptionFilter = interruptionFilter != null ? interruptionFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder interruptionFilter(InterruptionFilter interruptionFilter) {
            this.interruptionFilter = interruptionFilter;
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return transcriptFilter != null ? transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            this.transcriptFilter = transcriptFilter;
            return this;
        }

        public final SentimentFilter.Builder getSentimentFilter() {
            return sentimentFilter != null ? sentimentFilter.toBuilder() : null;
        }

        public final void setSentimentFilter(SentimentFilter.BuilderImpl sentimentFilter) {
            this.sentimentFilter = sentimentFilter != null ? sentimentFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder sentimentFilter(SentimentFilter sentimentFilter) {
            this.sentimentFilter = sentimentFilter;
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
