/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.PhrasesCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVocabularyRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, UpdateVocabularyRequest> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(UpdateVocabularyRequest.getter(UpdateVocabularyRequest::vocabularyName)).setter(UpdateVocabularyRequest.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(UpdateVocabularyRequest.getter(UpdateVocabularyRequest::languageCodeAsString)).setter(UpdateVocabularyRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<List<String>> PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phrases").getter(UpdateVocabularyRequest.getter(UpdateVocabularyRequest::phrases)).setter(UpdateVocabularyRequest.setter(Builder::phrases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phrases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOCABULARY_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFileUri").getter(UpdateVocabularyRequest.getter(UpdateVocabularyRequest::vocabularyFileUri)).setter(UpdateVocabularyRequest.setter(Builder::vocabularyFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFileUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, LANGUAGE_CODE_FIELD, PHRASES_FIELD, VOCABULARY_FILE_URI_FIELD));
    private final String vocabularyName;
    private final String languageCode;
    private final List<String> phrases;
    private final String vocabularyFileUri;

    private UpdateVocabularyRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.phrases = builder.phrases;
        this.vocabularyFileUri = builder.vocabularyFileUri;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final boolean hasPhrases() {
        return this.phrases != null && !(this.phrases instanceof SdkAutoConstructList);
    }

    public final List<String> phrases() {
        return this.phrases;
    }

    public final String vocabularyFileUri() {
        return this.vocabularyFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhrases() ? this.phrases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFileUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyRequest)) {
            return false;
        }
        UpdateVocabularyRequest other = (UpdateVocabularyRequest)((Object)obj);
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && this.hasPhrases() == other.hasPhrases() && Objects.equals(this.phrases(), other.phrases()) && Objects.equals(this.vocabularyFileUri(), other.vocabularyFileUri());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVocabularyRequest").add("VocabularyName", (Object)this.vocabularyName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Phrases", this.hasPhrases() ? this.phrases() : null).add("VocabularyFileUri", (Object)this.vocabularyFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Phrases": {
                return Optional.ofNullable(clazz.cast(this.phrases()));
            }
            case "VocabularyFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFileUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVocabularyRequest, T> g) {
        return obj -> g.apply((UpdateVocabularyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String languageCode;
        private List<String> phrases = DefaultSdkAutoConstructList.getInstance();
        private String vocabularyFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVocabularyRequest model) {
            super(model);
            this.vocabularyName(model.vocabularyName);
            this.languageCode(model.languageCode);
            this.phrases(model.phrases);
            this.vocabularyFileUri(model.vocabularyFileUri);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Collection<String> getPhrases() {
            if (this.phrases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phrases;
        }

        public final void setPhrases(Collection<String> phrases) {
            this.phrases = PhrasesCopier.copy(phrases);
        }

        @Override
        @Transient
        public final Builder phrases(Collection<String> phrases) {
            this.phrases = PhrasesCopier.copy(phrases);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phrases(String ... phrases) {
            this.phrases(Arrays.asList(phrases));
            return this;
        }

        public final String getVocabularyFileUri() {
            return this.vocabularyFileUri;
        }

        public final void setVocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
        }

        @Override
        @Transient
        public final Builder vocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVocabularyRequest build() {
            return new UpdateVocabularyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVocabularyRequest> {
        public Builder vocabularyName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder phrases(Collection<String> var1);

        public Builder phrases(String ... var1);

        public Builder vocabularyFileUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

