/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time range, set in seconds, between two points in the call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbsoluteTimeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AbsoluteTimeRange.Builder, AbsoluteTimeRange> {
    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("StartTime")
            .getter(getter(AbsoluteTimeRange::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("EndTime")
            .getter(getter(AbsoluteTimeRange::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Long> FIRST_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("First")
            .getter(getter(AbsoluteTimeRange::first)).setter(setter(Builder::first))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("First").build()).build();

    private static final SdkField<Long> LAST_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Last")
            .getter(getter(AbsoluteTimeRange::last)).setter(setter(Builder::last))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Last").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, FIRST_FIELD, LAST_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long startTime;

    private final Long endTime;

    private final Long first;

    private final Long last;

    private AbsoluteTimeRange(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.first = builder.first;
        this.last = builder.last;
    }

    /**
     * <p>
     * A value that indicates the beginning of the time range in seconds. To set absolute time range, you must specify a
     * start time and an end time. For example, if you specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * StartTime - 10000
     * </p>
     * </li>
     * <li>
     * <p>
     * Endtime - 50000
     * </p>
     * </li>
     * </ul>
     * <p>
     * The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
     * </p>
     * 
     * @return A value that indicates the beginning of the time range in seconds. To set absolute time range, you must
     *         specify a start time and an end time. For example, if you specify the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         StartTime - 10000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Endtime - 50000
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * A value that indicates the end of the time range in milliseconds. To set absolute time range, you must specify a
     * start time and an end time. For example, if you specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * StartTime - 10000
     * </p>
     * </li>
     * <li>
     * <p>
     * Endtime - 50000
     * </p>
     * </li>
     * </ul>
     * <p>
     * The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
     * </p>
     * 
     * @return A value that indicates the end of the time range in milliseconds. To set absolute time range, you must
     *         specify a start time and an end time. For example, if you specify the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         StartTime - 10000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Endtime - 50000
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
     */
    public final Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * A time range from the beginning of the call to the value that you've specified. For example, if you specify
     * <code>100000</code>, the time range is set to the first 100,000 milliseconds of the call.
     * </p>
     * 
     * @return A time range from the beginning of the call to the value that you've specified. For example, if you
     *         specify <code>100000</code>, the time range is set to the first 100,000 milliseconds of the call.
     */
    public final Long first() {
        return first;
    }

    /**
     * <p>
     * A time range from the value that you've specified to the end of the call. For example, if you specify
     * <code>100000</code>, the time range is set to the last 100,000 milliseconds of the call.
     * </p>
     * 
     * @return A time range from the value that you've specified to the end of the call. For example, if you specify
     *         <code>100000</code>, the time range is set to the last 100,000 milliseconds of the call.
     */
    public final Long last() {
        return last;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(first());
        hashCode = 31 * hashCode + Objects.hashCode(last());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbsoluteTimeRange)) {
            return false;
        }
        AbsoluteTimeRange other = (AbsoluteTimeRange) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(first(), other.first()) && Objects.equals(last(), other.last());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbsoluteTimeRange").add("StartTime", startTime()).add("EndTime", endTime())
                .add("First", first()).add("Last", last()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "First":
            return Optional.ofNullable(clazz.cast(first()));
        case "Last":
            return Optional.ofNullable(clazz.cast(last()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbsoluteTimeRange, T> g) {
        return obj -> g.apply((AbsoluteTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbsoluteTimeRange> {
        /**
         * <p>
         * A value that indicates the beginning of the time range in seconds. To set absolute time range, you must
         * specify a start time and an end time. For example, if you specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * StartTime - 10000
         * </p>
         * </li>
         * <li>
         * <p>
         * Endtime - 50000
         * </p>
         * </li>
         * </ul>
         * <p>
         * The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
         * </p>
         * 
         * @param startTime
         *        A value that indicates the beginning of the time range in seconds. To set absolute time range, you
         *        must specify a start time and an end time. For example, if you specify the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        StartTime - 10000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Endtime - 50000
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * A value that indicates the end of the time range in milliseconds. To set absolute time range, you must
         * specify a start time and an end time. For example, if you specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * StartTime - 10000
         * </p>
         * </li>
         * <li>
         * <p>
         * Endtime - 50000
         * </p>
         * </li>
         * </ul>
         * <p>
         * The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
         * </p>
         * 
         * @param endTime
         *        A value that indicates the end of the time range in milliseconds. To set absolute time range, you must
         *        specify a start time and an end time. For example, if you specify the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        StartTime - 10000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Endtime - 50000
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The time range is set between 10,000 milliseconds and 50,000 milliseconds into the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * A time range from the beginning of the call to the value that you've specified. For example, if you specify
         * <code>100000</code>, the time range is set to the first 100,000 milliseconds of the call.
         * </p>
         * 
         * @param first
         *        A time range from the beginning of the call to the value that you've specified. For example, if you
         *        specify <code>100000</code>, the time range is set to the first 100,000 milliseconds of the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder first(Long first);

        /**
         * <p>
         * A time range from the value that you've specified to the end of the call. For example, if you specify
         * <code>100000</code>, the time range is set to the last 100,000 milliseconds of the call.
         * </p>
         * 
         * @param last
         *        A time range from the value that you've specified to the end of the call. For example, if you specify
         *        <code>100000</code>, the time range is set to the last 100,000 milliseconds of the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder last(Long last);
    }

    static final class BuilderImpl implements Builder {
        private Long startTime;

        private Long endTime;

        private Long first;

        private Long last;

        private BuilderImpl() {
        }

        private BuilderImpl(AbsoluteTimeRange model) {
            startTime(model.startTime);
            endTime(model.endTime);
            first(model.first);
            last(model.last);
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getFirst() {
            return first;
        }

        public final void setFirst(Long first) {
            this.first = first;
        }

        @Override
        @Transient
        public final Builder first(Long first) {
            this.first = first;
            return this;
        }

        public final Long getLast() {
            return last;
        }

        public final void setLast(Long last) {
            this.last = last;
        }

        @Override
        @Transient
        public final Builder last(Long last) {
            this.last = last;
            return this;
        }

        @Override
        public AbsoluteTimeRange build() {
            return new AbsoluteTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
