/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the input media file in a transcription request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Media implements SdkPojo, Serializable, ToCopyableBuilder<Media.Builder, Media> {
    private static final SdkField<String> MEDIA_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaFileUri").getter(getter(Media::mediaFileUri)).setter(setter(Builder::mediaFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFileUri").build()).build();

    private static final SdkField<String> REDACTED_MEDIA_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedactedMediaFileUri").getter(getter(Media::redactedMediaFileUri))
            .setter(setter(Builder::redactedMediaFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedMediaFileUri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_FILE_URI_FIELD,
            REDACTED_MEDIA_FILE_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaFileUri;

    private final String redactedMediaFileUri;

    private Media(BuilderImpl builder) {
        this.mediaFileUri = builder.mediaFileUri;
        this.redactedMediaFileUri = builder.redactedMediaFileUri;
    }

    /**
     * <p>
     * The S3 object location of the input media file. The URI must be in the same region as the API endpoint that you
     * are calling. The general form is:
     * </p>
     * <p>
     * <code>s3://DOC-EXAMPLE-BUCKET/keyprefix/objectkey</code>
     * </p>
     * <p>
     * For example:
     * </p>
     * <p>
     * <code>s3://DOC-EXAMPLE-BUCKET/example.flac</code>
     * </p>
     * <p>
     * <code>s3://DOC-EXAMPLE-BUCKET/mediafiles/example.flac</code>
     * </p>
     * <p>
     * For more information about S3 object names, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
     * <i>Amazon S3 Developer Guide</i>.
     * </p>
     * 
     * @return The S3 object location of the input media file. The URI must be in the same region as the API endpoint
     *         that you are calling. The general form is:</p>
     *         <p>
     *         <code>s3://DOC-EXAMPLE-BUCKET/keyprefix/objectkey</code>
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <p>
     *         <code>s3://DOC-EXAMPLE-BUCKET/example.flac</code>
     *         </p>
     *         <p>
     *         <code>s3://DOC-EXAMPLE-BUCKET/mediafiles/example.flac</code>
     *         </p>
     *         <p>
     *         For more information about S3 object names, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in
     *         the <i>Amazon S3 Developer Guide</i>.
     */
    public final String mediaFileUri() {
        return mediaFileUri;
    }

    /**
     * <p>
     * The S3 object location for your redacted output media file. This is only supported for call analytics jobs.
     * </p>
     * 
     * @return The S3 object location for your redacted output media file. This is only supported for call analytics
     *         jobs.
     */
    public final String redactedMediaFileUri() {
        return redactedMediaFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(redactedMediaFileUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Media)) {
            return false;
        }
        Media other = (Media) obj;
        return Objects.equals(mediaFileUri(), other.mediaFileUri())
                && Objects.equals(redactedMediaFileUri(), other.redactedMediaFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Media").add("MediaFileUri", mediaFileUri()).add("RedactedMediaFileUri", redactedMediaFileUri())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaFileUri":
            return Optional.ofNullable(clazz.cast(mediaFileUri()));
        case "RedactedMediaFileUri":
            return Optional.ofNullable(clazz.cast(redactedMediaFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Media, T> g) {
        return obj -> g.apply((Media) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Media> {
        /**
         * <p>
         * The S3 object location of the input media file. The URI must be in the same region as the API endpoint that
         * you are calling. The general form is:
         * </p>
         * <p>
         * <code>s3://DOC-EXAMPLE-BUCKET/keyprefix/objectkey</code>
         * </p>
         * <p>
         * For example:
         * </p>
         * <p>
         * <code>s3://DOC-EXAMPLE-BUCKET/example.flac</code>
         * </p>
         * <p>
         * <code>s3://DOC-EXAMPLE-BUCKET/mediafiles/example.flac</code>
         * </p>
         * <p>
         * For more information about S3 object names, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the
         * <i>Amazon S3 Developer Guide</i>.
         * </p>
         * 
         * @param mediaFileUri
         *        The S3 object location of the input media file. The URI must be in the same region as the API endpoint
         *        that you are calling. The general form is:</p>
         *        <p>
         *        <code>s3://DOC-EXAMPLE-BUCKET/keyprefix/objectkey</code>
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <p>
         *        <code>s3://DOC-EXAMPLE-BUCKET/example.flac</code>
         *        </p>
         *        <p>
         *        <code>s3://DOC-EXAMPLE-BUCKET/mediafiles/example.flac</code>
         *        </p>
         *        <p>
         *        For more information about S3 object names, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a>
         *        in the <i>Amazon S3 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaFileUri(String mediaFileUri);

        /**
         * <p>
         * The S3 object location for your redacted output media file. This is only supported for call analytics jobs.
         * </p>
         * 
         * @param redactedMediaFileUri
         *        The S3 object location for your redacted output media file. This is only supported for call analytics
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedMediaFileUri(String redactedMediaFileUri);
    }

    static final class BuilderImpl implements Builder {
        private String mediaFileUri;

        private String redactedMediaFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Media model) {
            mediaFileUri(model.mediaFileUri);
            redactedMediaFileUri(model.redactedMediaFileUri);
        }

        public final String getMediaFileUri() {
            return mediaFileUri;
        }

        public final void setMediaFileUri(String mediaFileUri) {
            this.mediaFileUri = mediaFileUri;
        }

        @Override
        @Transient
        public final Builder mediaFileUri(String mediaFileUri) {
            this.mediaFileUri = mediaFileUri;
            return this;
        }

        public final String getRedactedMediaFileUri() {
            return redactedMediaFileUri;
        }

        public final void setRedactedMediaFileUri(String redactedMediaFileUri) {
            this.redactedMediaFileUri = redactedMediaFileUri;
        }

        @Override
        @Transient
        public final Builder redactedMediaFileUri(String redactedMediaFileUri) {
            this.redactedMediaFileUri = redactedMediaFileUri;
            return this;
        }

        @Override
        public Media build() {
            return new Media(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
