/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional settings for the <a>StartMedicalTranscriptionJob</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalTranscriptionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalTranscriptionSetting.Builder, MedicalTranscriptionSetting> {
    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabels").getter(getter(MedicalTranscriptionSetting::showSpeakerLabels))
            .setter(setter(Builder::showSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()).build();

    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSpeakerLabels").getter(getter(MedicalTranscriptionSetting::maxSpeakerLabels))
            .setter(setter(Builder::maxSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()).build();

    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChannelIdentification").getter(getter(MedicalTranscriptionSetting::channelIdentification))
            .setter(setter(Builder::channelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build())
            .build();

    private static final SdkField<Boolean> SHOW_ALTERNATIVES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowAlternatives").getter(getter(MedicalTranscriptionSetting::showAlternatives))
            .setter(setter(Builder::showAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAlternatives").build()).build();

    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAlternatives").getter(getter(MedicalTranscriptionSetting::maxAlternatives))
            .setter(setter(Builder::maxAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(MedicalTranscriptionSetting::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHOW_SPEAKER_LABELS_FIELD,
            MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, SHOW_ALTERNATIVES_FIELD, MAX_ALTERNATIVES_FIELD,
            VOCABULARY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean showSpeakerLabels;

    private final Integer maxSpeakerLabels;

    private final Boolean channelIdentification;

    private final Boolean showAlternatives;

    private final Integer maxAlternatives;

    private final String vocabularyName;

    private MedicalTranscriptionSetting(BuilderImpl builder) {
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.showAlternatives = builder.showAlternatives;
        this.maxAlternatives = builder.maxAlternatives;
        this.vocabularyName = builder.vocabularyName;
    }

    /**
     * <p>
     * Determines whether the transcription job uses speaker recognition to identify different speakers in the input
     * audio. Speaker recognition labels individual speakers in the audio file. If you set the
     * <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels in the
     * <code>MaxSpeakerLabels</code> field.
     * </p>
     * <p>
     * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If
     * you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * 
     * @return Determines whether the transcription job uses speaker recognition to identify different speakers in the
     *         input audio. Speaker recognition labels individual speakers in the audio file. If you set the
     *         <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels in
     *         the <code>MaxSpeakerLabels</code> field.</p>
     *         <p>
     *         You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     */
    public final Boolean showSpeakerLabels() {
        return showSpeakerLabels;
    }

    /**
     * <p>
     * The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this
     * number, multiple speakers are identified as a single speaker. If you specify the <code>MaxSpeakerLabels</code>
     * field, you must set the <code>ShowSpeakerLabels</code> field to true.
     * </p>
     * 
     * @return The maximum number of speakers to identify in the input audio. If there are more speakers in the audio
     *         than this number, multiple speakers are identified as a single speaker. If you specify the
     *         <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
     */
    public final Integer maxSpeakerLabels() {
        return maxSpeakerLabels;
    }

    /**
     * <p>
     * Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription
     * output of each channel into a single transcription.
     * </p>
     * <p>
     * Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel, including the
     * start time and end time of the item and alternative transcriptions of item. The alternative transcriptions also
     * come with confidence scores provided by Amazon Transcribe Medical.
     * </p>
     * <p>
     * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If
     * you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * 
     * @return Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the
     *         transcription output of each channel into a single transcription.</p>
     *         <p>
     *         Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel,
     *         including the start time and end time of the item and alternative transcriptions of item. The alternative
     *         transcriptions also come with confidence scores provided by Amazon Transcribe Medical.
     *         </p>
     *         <p>
     *         You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     */
    public final Boolean channelIdentification() {
        return channelIdentification;
    }

    /**
     * <p>
     * Determines whether alternative transcripts are generated along with the transcript that has the highest
     * confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the maximum number of
     * alternatives to return in the <code>MaxAlternatives</code> field.
     * </p>
     * 
     * @return Determines whether alternative transcripts are generated along with the transcript that has the highest
     *         confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the maximum number
     *         of alternatives to return in the <code>MaxAlternatives</code> field.
     */
    public final Boolean showAlternatives() {
        return showAlternatives;
    }

    /**
     * <p>
     * The maximum number of alternatives that you tell the service to return. If you specify the
     * <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
     * </p>
     * 
     * @return The maximum number of alternatives that you tell the service to return. If you specify the
     *         <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
     */
    public final Integer maxAlternatives() {
        return maxAlternatives;
    }

    /**
     * <p>
     * The name of the vocabulary to use when processing a medical transcription job.
     * </p>
     * 
     * @return The name of the vocabulary to use when processing a medical transcription job.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(showAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscriptionSetting)) {
            return false;
        }
        MedicalTranscriptionSetting other = (MedicalTranscriptionSetting) obj;
        return Objects.equals(showSpeakerLabels(), other.showSpeakerLabels())
                && Objects.equals(maxSpeakerLabels(), other.maxSpeakerLabels())
                && Objects.equals(channelIdentification(), other.channelIdentification())
                && Objects.equals(showAlternatives(), other.showAlternatives())
                && Objects.equals(maxAlternatives(), other.maxAlternatives())
                && Objects.equals(vocabularyName(), other.vocabularyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalTranscriptionSetting").add("ShowSpeakerLabels", showSpeakerLabels())
                .add("MaxSpeakerLabels", maxSpeakerLabels()).add("ChannelIdentification", channelIdentification())
                .add("ShowAlternatives", showAlternatives()).add("MaxAlternatives", maxAlternatives())
                .add("VocabularyName", vocabularyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShowSpeakerLabels":
            return Optional.ofNullable(clazz.cast(showSpeakerLabels()));
        case "MaxSpeakerLabels":
            return Optional.ofNullable(clazz.cast(maxSpeakerLabels()));
        case "ChannelIdentification":
            return Optional.ofNullable(clazz.cast(channelIdentification()));
        case "ShowAlternatives":
            return Optional.ofNullable(clazz.cast(showAlternatives()));
        case "MaxAlternatives":
            return Optional.ofNullable(clazz.cast(maxAlternatives()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscriptionSetting, T> g) {
        return obj -> g.apply((MedicalTranscriptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalTranscriptionSetting> {
        /**
         * <p>
         * Determines whether the transcription job uses speaker recognition to identify different speakers in the input
         * audio. Speaker recognition labels individual speakers in the audio file. If you set the
         * <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels in the
         * <code>MaxSpeakerLabels</code> field.
         * </p>
         * <p>
         * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request.
         * If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * 
         * @param showSpeakerLabels
         *        Determines whether the transcription job uses speaker recognition to identify different speakers in
         *        the input audio. Speaker recognition labels individual speakers in the audio file. If you set the
         *        <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels
         *        in the <code>MaxSpeakerLabels</code> field.</p>
         *        <p>
         *        You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabels(Boolean showSpeakerLabels);

        /**
         * <p>
         * The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than
         * this number, multiple speakers are identified as a single speaker. If you specify the
         * <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
         * </p>
         * 
         * @param maxSpeakerLabels
         *        The maximum number of speakers to identify in the input audio. If there are more speakers in the audio
         *        than this number, multiple speakers are identified as a single speaker. If you specify the
         *        <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeakerLabels(Integer maxSpeakerLabels);

        /**
         * <p>
         * Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription
         * output of each channel into a single transcription.
         * </p>
         * <p>
         * Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel, including
         * the start time and end time of the item and alternative transcriptions of item. The alternative
         * transcriptions also come with confidence scores provided by Amazon Transcribe Medical.
         * </p>
         * <p>
         * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request.
         * If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * 
         * @param channelIdentification
         *        Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the
         *        transcription output of each channel into a single transcription.</p>
         *        <p>
         *        Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel,
         *        including the start time and end time of the item and alternative transcriptions of item. The
         *        alternative transcriptions also come with confidence scores provided by Amazon Transcribe Medical.
         *        </p>
         *        <p>
         *        You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentification(Boolean channelIdentification);

        /**
         * <p>
         * Determines whether alternative transcripts are generated along with the transcript that has the highest
         * confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the maximum number of
         * alternatives to return in the <code>MaxAlternatives</code> field.
         * </p>
         * 
         * @param showAlternatives
         *        Determines whether alternative transcripts are generated along with the transcript that has the
         *        highest confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the
         *        maximum number of alternatives to return in the <code>MaxAlternatives</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showAlternatives(Boolean showAlternatives);

        /**
         * <p>
         * The maximum number of alternatives that you tell the service to return. If you specify the
         * <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
         * </p>
         * 
         * @param maxAlternatives
         *        The maximum number of alternatives that you tell the service to return. If you specify the
         *        <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAlternatives(Integer maxAlternatives);

        /**
         * <p>
         * The name of the vocabulary to use when processing a medical transcription job.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the vocabulary to use when processing a medical transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean showSpeakerLabels;

        private Integer maxSpeakerLabels;

        private Boolean channelIdentification;

        private Boolean showAlternatives;

        private Integer maxAlternatives;

        private String vocabularyName;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscriptionSetting model) {
            showSpeakerLabels(model.showSpeakerLabels);
            maxSpeakerLabels(model.maxSpeakerLabels);
            channelIdentification(model.channelIdentification);
            showAlternatives(model.showAlternatives);
            maxAlternatives(model.maxAlternatives);
            vocabularyName(model.vocabularyName);
        }

        public final Boolean getShowSpeakerLabels() {
            return showSpeakerLabels;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        @Override
        @Transient
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final Integer getMaxSpeakerLabels() {
            return maxSpeakerLabels;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        @Override
        @Transient
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final Boolean getChannelIdentification() {
            return channelIdentification;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        @Override
        @Transient
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final Boolean getShowAlternatives() {
            return showAlternatives;
        }

        public final void setShowAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
        }

        @Override
        @Transient
        public final Builder showAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
            return this;
        }

        public final Integer getMaxAlternatives() {
            return maxAlternatives;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        @Override
        @Transient
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        @Override
        public MedicalTranscriptionSetting build() {
            return new MedicalTranscriptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
