/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalTranscriptionJobResponse extends TranscribeResponse implements
        ToCopyableBuilder<StartMedicalTranscriptionJobResponse.Builder, StartMedicalTranscriptionJobResponse> {
    private static final SdkField<MedicalTranscriptionJob> MEDICAL_TRANSCRIPTION_JOB_FIELD = SdkField
            .<MedicalTranscriptionJob> builder(MarshallingType.SDK_POJO).memberName("MedicalTranscriptionJob")
            .getter(getter(StartMedicalTranscriptionJobResponse::medicalTranscriptionJob))
            .setter(setter(Builder::medicalTranscriptionJob)).constructor(MedicalTranscriptionJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJob").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDICAL_TRANSCRIPTION_JOB_FIELD));

    private final MedicalTranscriptionJob medicalTranscriptionJob;

    private StartMedicalTranscriptionJobResponse(BuilderImpl builder) {
        super(builder);
        this.medicalTranscriptionJob = builder.medicalTranscriptionJob;
    }

    /**
     * <p>
     * A batch job submitted to transcribe medical speech to text.
     * </p>
     * 
     * @return A batch job submitted to transcribe medical speech to text.
     */
    public final MedicalTranscriptionJob medicalTranscriptionJob() {
        return medicalTranscriptionJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(medicalTranscriptionJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalTranscriptionJobResponse)) {
            return false;
        }
        StartMedicalTranscriptionJobResponse other = (StartMedicalTranscriptionJobResponse) obj;
        return Objects.equals(medicalTranscriptionJob(), other.medicalTranscriptionJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalTranscriptionJobResponse").add("MedicalTranscriptionJob", medicalTranscriptionJob())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalTranscriptionJob":
            return Optional.ofNullable(clazz.cast(medicalTranscriptionJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalTranscriptionJobResponse, T> g) {
        return obj -> g.apply((StartMedicalTranscriptionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMedicalTranscriptionJobResponse> {
        /**
         * <p>
         * A batch job submitted to transcribe medical speech to text.
         * </p>
         * 
         * @param medicalTranscriptionJob
         *        A batch job submitted to transcribe medical speech to text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJob(MedicalTranscriptionJob medicalTranscriptionJob);

        /**
         * <p>
         * A batch job submitted to transcribe medical speech to text.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalTranscriptionJob.Builder} avoiding
         * the need to create one manually via {@link MedicalTranscriptionJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link MedicalTranscriptionJob.Builder#build()} is called immediately
         * and its result is passed to {@link #medicalTranscriptionJob(MedicalTranscriptionJob)}.
         * 
         * @param medicalTranscriptionJob
         *        a consumer that will call methods on {@link MedicalTranscriptionJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #medicalTranscriptionJob(MedicalTranscriptionJob)
         */
        default Builder medicalTranscriptionJob(Consumer<MedicalTranscriptionJob.Builder> medicalTranscriptionJob) {
            return medicalTranscriptionJob(MedicalTranscriptionJob.builder().applyMutation(medicalTranscriptionJob).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private MedicalTranscriptionJob medicalTranscriptionJob;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalTranscriptionJobResponse model) {
            super(model);
            medicalTranscriptionJob(model.medicalTranscriptionJob);
        }

        public final MedicalTranscriptionJob.Builder getMedicalTranscriptionJob() {
            return medicalTranscriptionJob != null ? medicalTranscriptionJob.toBuilder() : null;
        }

        public final void setMedicalTranscriptionJob(MedicalTranscriptionJob.BuilderImpl medicalTranscriptionJob) {
            this.medicalTranscriptionJob = medicalTranscriptionJob != null ? medicalTranscriptionJob.build() : null;
        }

        @Override
        public final Builder medicalTranscriptionJob(MedicalTranscriptionJob medicalTranscriptionJob) {
            this.medicalTranscriptionJob = medicalTranscriptionJob;
            return this;
        }

        @Override
        public StartMedicalTranscriptionJobResponse build() {
            return new StartMedicalTranscriptionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
