/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCallAnalyticsCategoryResponse extends TranscribeResponse implements
        ToCopyableBuilder<UpdateCallAnalyticsCategoryResponse.Builder, UpdateCallAnalyticsCategoryResponse> {
    private static final SdkField<CategoryProperties> CATEGORY_PROPERTIES_FIELD = SdkField
            .<CategoryProperties> builder(MarshallingType.SDK_POJO).memberName("CategoryProperties")
            .getter(getter(UpdateCallAnalyticsCategoryResponse::categoryProperties)).setter(setter(Builder::categoryProperties))
            .constructor(CategoryProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_PROPERTIES_FIELD));

    private final CategoryProperties categoryProperties;

    private UpdateCallAnalyticsCategoryResponse(BuilderImpl builder) {
        super(builder);
        this.categoryProperties = builder.categoryProperties;
    }

    /**
     * <p>
     * The attributes describing the analytics category. You can see information such as the rules that you've used to
     * update the category and when the category was originally created.
     * </p>
     * 
     * @return The attributes describing the analytics category. You can see information such as the rules that you've
     *         used to update the category and when the category was originally created.
     */
    public final CategoryProperties categoryProperties() {
        return categoryProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCallAnalyticsCategoryResponse)) {
            return false;
        }
        UpdateCallAnalyticsCategoryResponse other = (UpdateCallAnalyticsCategoryResponse) obj;
        return Objects.equals(categoryProperties(), other.categoryProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCallAnalyticsCategoryResponse").add("CategoryProperties", categoryProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryProperties":
            return Optional.ofNullable(clazz.cast(categoryProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCallAnalyticsCategoryResponse, T> g) {
        return obj -> g.apply((UpdateCallAnalyticsCategoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCallAnalyticsCategoryResponse> {
        /**
         * <p>
         * The attributes describing the analytics category. You can see information such as the rules that you've used
         * to update the category and when the category was originally created.
         * </p>
         * 
         * @param categoryProperties
         *        The attributes describing the analytics category. You can see information such as the rules that
         *        you've used to update the category and when the category was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryProperties(CategoryProperties categoryProperties);

        /**
         * <p>
         * The attributes describing the analytics category. You can see information such as the rules that you've used
         * to update the category and when the category was originally created.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoryProperties.Builder} avoiding the
         * need to create one manually via {@link CategoryProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link CategoryProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryProperties(CategoryProperties)}.
         * 
         * @param categoryProperties
         *        a consumer that will call methods on {@link CategoryProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryProperties(CategoryProperties)
         */
        default Builder categoryProperties(Consumer<CategoryProperties.Builder> categoryProperties) {
            return categoryProperties(CategoryProperties.builder().applyMutation(categoryProperties).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private CategoryProperties categoryProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCallAnalyticsCategoryResponse model) {
            super(model);
            categoryProperties(model.categoryProperties);
        }

        public final CategoryProperties.Builder getCategoryProperties() {
            return categoryProperties != null ? categoryProperties.toBuilder() : null;
        }

        public final void setCategoryProperties(CategoryProperties.BuilderImpl categoryProperties) {
            this.categoryProperties = categoryProperties != null ? categoryProperties.build() : null;
        }

        @Override
        public final Builder categoryProperties(CategoryProperties categoryProperties) {
            this.categoryProperties = categoryProperties;
            return this;
        }

        @Override
        public UpdateCallAnalyticsCategoryResponse build() {
            return new UpdateCallAnalyticsCategoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
