/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVocabularyFilterRequest extends TranscribeRequest implements
        ToCopyableBuilder<CreateVocabularyFilterRequest.Builder, CreateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(CreateVocabularyFilterRequest::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateVocabularyFilterRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<List<String>> WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Words")
            .getter(getter(CreateVocabularyFilterRequest::words))
            .setter(setter(Builder::words))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterFileUri").getter(getter(CreateVocabularyFilterRequest::vocabularyFilterFileUri))
            .setter(setter(Builder::vocabularyFilterFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateVocabularyFilterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD,
            LANGUAGE_CODE_FIELD, WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD, TAGS_FIELD));

    private final String vocabularyFilterName;

    private final String languageCode;

    private final List<String> words;

    private final String vocabularyFilterFileUri;

    private final List<Tag> tags;

    private CreateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.languageCode = builder.languageCode;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of your new vocabulary filter.
     * </p>
     * <p>
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If
     * you try to create a vocabulary filter with the same name as a previous vocabulary filter, you get a
     * <code>ConflictException</code> error.
     * </p>
     * 
     * @return The name of your new vocabulary filter.</p>
     *         <p>
     *         This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
     *         account. If you try to create a vocabulary filter with the same name as a previous vocabulary filter, you
     *         get a <code>ConflictException</code> error.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter. All words in the filter must be in the same language.
     * The vocabulary filter can only be used with transcription jobs in the specified language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter. All words in the filter must be in the same
     *         language. The vocabulary filter can only be used with transcription jobs in the specified language.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code of the words in the vocabulary filter. All words in the filter must be in the same language.
     * The vocabulary filter can only be used with transcription jobs in the specified language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code of the words in the vocabulary filter. All words in the filter must be in the same
     *         language. The vocabulary filter can only be used with transcription jobs in the specified language.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Words property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasWords() {
        return words != null && !(words instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The words you want in your vocabulary filter. Only use characters specified in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the language you're
     * transcribing.
     * </p>
     * <p>
     * Note that if you include <code>Words</code> in your request, you cannot use <code>VocabularyFilterFileUri</code>;
     * you must choose one or the other.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWords} method.
     * </p>
     * 
     * @return The words you want in your vocabulary filter. Only use characters specified in the <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the language
     *         you're transcribing.</p>
     *         <p>
     *         Note that if you include <code>Words</code> in your request, you cannot use
     *         <code>VocabularyFilterFileUri</code>; you must choose one or the other.
     */
    public final List<String> words() {
        return words;
    }

    /**
     * <p>
     * The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the
     * character set defined for custom vocabularies. For a list of character sets, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>.
     * </p>
     * <p>
     * Your vocabulary filter file must be less than 50 KB in size.
     * </p>
     * <p>
     * Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use <code>Words</code>;
     * you must choose one or the other.
     * </p>
     * 
     * @return The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters
     *         from the character set defined for custom vocabularies. For a list of character sets, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
     *         Vocabularies</a>.</p>
     *         <p>
     *         Your vocabulary filter file must be less than 50 KB in size.
     *         </p>
     *         <p>
     *         Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
     *         <code>Words</code>; you must choose one or the other.
     */
    public final String vocabularyFilterFileUri() {
        return vocabularyFilterFileUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time you create
     * this new vocabulary filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time you
     *         create this new vocabulary filter.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWords() ? words() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyFilterRequest)) {
            return false;
        }
        CreateVocabularyFilterRequest other = (CreateVocabularyFilterRequest) obj;
        return Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString()) && hasWords() == other.hasWords()
                && Objects.equals(words(), other.words())
                && Objects.equals(vocabularyFilterFileUri(), other.vocabularyFilterFileUri()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVocabularyFilterRequest").add("VocabularyFilterName", vocabularyFilterName())
                .add("LanguageCode", languageCodeAsString()).add("Words", hasWords() ? words() : null)
                .add("VocabularyFilterFileUri", vocabularyFilterFileUri()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "Words":
            return Optional.ofNullable(clazz.cast(words()));
        case "VocabularyFilterFileUri":
            return Optional.ofNullable(clazz.cast(vocabularyFilterFileUri()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((CreateVocabularyFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVocabularyFilterRequest> {
        /**
         * <p>
         * The name of your new vocabulary filter.
         * </p>
         * <p>
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * If you try to create a vocabulary filter with the same name as a previous vocabulary filter, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of your new vocabulary filter.</p>
         *        <p>
         *        This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account. If you try to create a vocabulary filter with the same name as a previous vocabulary filter,
         *        you get a <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * The language code of the words in the vocabulary filter. All words in the filter must be in the same
         * language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter. All words in the filter must be in the same
         *        language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code of the words in the vocabulary filter. All words in the filter must be in the same
         * language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * </p>
         * 
         * @param languageCode
         *        The language code of the words in the vocabulary filter. All words in the filter must be in the same
         *        language. The vocabulary filter can only be used with transcription jobs in the specified language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The words you want in your vocabulary filter. Only use characters specified in the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the language
         * you're transcribing.
         * </p>
         * <p>
         * Note that if you include <code>Words</code> in your request, you cannot use
         * <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * </p>
         * 
         * @param words
         *        The words you want in your vocabulary filter. Only use characters specified in the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the
         *        language you're transcribing.</p>
         *        <p>
         *        Note that if you include <code>Words</code> in your request, you cannot use
         *        <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(Collection<String> words);

        /**
         * <p>
         * The words you want in your vocabulary filter. Only use characters specified in the <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the language
         * you're transcribing.
         * </p>
         * <p>
         * Note that if you include <code>Words</code> in your request, you cannot use
         * <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * </p>
         * 
         * @param words
         *        The words you want in your vocabulary filter. Only use characters specified in the <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character sets</a> for the
         *        language you're transcribing.</p>
         *        <p>
         *        Note that if you include <code>Words</code> in your request, you cannot use
         *        <code>VocabularyFilterFileUri</code>; you must choose one or the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder words(String... words);

        /**
         * <p>
         * The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from
         * the character set defined for custom vocabularies. For a list of character sets, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         * Vocabularies</a>.
         * </p>
         * <p>
         * Your vocabulary filter file must be less than 50 KB in size.
         * </p>
         * <p>
         * Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
         * <code>Words</code>; you must choose one or the other.
         * </p>
         * 
         * @param vocabularyFilterFileUri
         *        The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use
         *        characters from the character set defined for custom vocabularies. For a list of character sets, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom
         *        Vocabularies</a>.</p>
         *        <p>
         *        Your vocabulary filter file must be less than 50 KB in size.
         *        </p>
         *        <p>
         *        Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use
         *        <code>Words</code>; you must choose one or the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterFileUri(String vocabularyFilterFileUri);

        /**
         * <p>
         * Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time you
         * create this new vocabulary filter.
         * </p>
         * 
         * @param tags
         *        Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time
         *        you create this new vocabulary filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time you
         * create this new vocabulary filter.
         * </p>
         * 
         * @param tags
         *        Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time
         *        you create this new vocabulary filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds one or more tags, each in the form of a key:value pair, to a new vocabulary filter at the time you
         * create this new vocabulary filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String vocabularyFilterName;

        private String languageCode;

        private List<String> words = DefaultSdkAutoConstructList.getInstance();

        private String vocabularyFilterFileUri;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVocabularyFilterRequest model) {
            super(model);
            vocabularyFilterName(model.vocabularyFilterName);
            languageCode(model.languageCode);
            words(model.words);
            vocabularyFilterFileUri(model.vocabularyFilterFileUri);
            tags(model.tags);
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Collection<String> getWords() {
            if (words instanceof SdkAutoConstructList) {
                return null;
            }
            return words;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String... words) {
            words(Arrays.asList(words));
            return this;
        }

        public final String getVocabularyFilterFileUri() {
            return vocabularyFilterFileUri;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVocabularyFilterRequest build() {
            return new CreateVocabularyFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
