/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVocabulariesResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListVocabulariesResponse.Builder, ListVocabulariesResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListVocabulariesResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVocabulariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<VocabularyInfo>> VOCABULARIES_FIELD = SdkField
            .<List<VocabularyInfo>> builder(MarshallingType.LIST)
            .memberName("Vocabularies")
            .getter(getter(ListVocabulariesResponse::vocabularies))
            .setter(setter(Builder::vocabularies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vocabularies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VocabularyInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VocabularyInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NEXT_TOKEN_FIELD, VOCABULARIES_FIELD));

    private final String status;

    private final String nextToken;

    private final List<VocabularyInfo> vocabularies;

    private ListVocabulariesResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.vocabularies = builder.vocabularies;
    }

    /**
     * <p>
     * The requested vocabulary state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The requested vocabulary state.
     * @see VocabularyState
     */
    public final VocabularyState status() {
        return VocabularyState.fromValue(status);
    }

    /**
     * <p>
     * The requested vocabulary state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The requested vocabulary state.
     * @see VocabularyState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size of the
     * page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than will fit on the
     * page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next page of jobs, include the
     * token in the next request to the <code>ListVocabularies</code> operation.
     * </p>
     * 
     * @return The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size of
     *         the page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than will
     *         fit on the page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next page of
     *         jobs, include the token in the next request to the <code>ListVocabularies</code> operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vocabularies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVocabularies() {
        return vocabularies != null && !(vocabularies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that describe the vocabularies that match the search criteria in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVocabularies} method.
     * </p>
     * 
     * @return A list of objects that describe the vocabularies that match the search criteria in the request.
     */
    public final List<VocabularyInfo> vocabularies() {
        return vocabularies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVocabularies() ? vocabularies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabulariesResponse)) {
            return false;
        }
        ListVocabulariesResponse other = (ListVocabulariesResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && hasVocabularies() == other.hasVocabularies() && Objects.equals(vocabularies(), other.vocabularies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVocabulariesResponse").add("Status", statusAsString()).add("NextToken", nextToken())
                .add("Vocabularies", hasVocabularies() ? vocabularies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Vocabularies":
            return Optional.ofNullable(clazz.cast(vocabularies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabulariesResponse, T> g) {
        return obj -> g.apply((ListVocabulariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVocabulariesResponse> {
        /**
         * <p>
         * The requested vocabulary state.
         * </p>
         * 
         * @param status
         *        The requested vocabulary state.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder status(String status);

        /**
         * <p>
         * The requested vocabulary state.
         * </p>
         * 
         * @param status
         *        The requested vocabulary state.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder status(VocabularyState status);

        /**
         * <p>
         * The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size of the
         * page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than will fit on the
         * page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next page of jobs, include
         * the token in the next request to the <code>ListVocabularies</code> operation.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size
         *        of the page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than
         *        will fit on the page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next
         *        page of jobs, include the token in the next request to the <code>ListVocabularies</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects that describe the vocabularies that match the search criteria in the request.
         * </p>
         * 
         * @param vocabularies
         *        A list of objects that describe the vocabularies that match the search criteria in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularies(Collection<VocabularyInfo> vocabularies);

        /**
         * <p>
         * A list of objects that describe the vocabularies that match the search criteria in the request.
         * </p>
         * 
         * @param vocabularies
         *        A list of objects that describe the vocabularies that match the search criteria in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularies(VocabularyInfo... vocabularies);

        /**
         * <p>
         * A list of objects that describe the vocabularies that match the search criteria in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VocabularyInfo>.Builder} avoiding
         * the need to create one manually via {@link List<VocabularyInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VocabularyInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #vocabularies(List<VocabularyInfo>)}.
         * 
         * @param vocabularies
         *        a consumer that will call methods on {@link List<VocabularyInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vocabularies(List<VocabularyInfo>)
         */
        Builder vocabularies(Consumer<VocabularyInfo.Builder>... vocabularies);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String status;

        private String nextToken;

        private List<VocabularyInfo> vocabularies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabulariesResponse model) {
            super(model);
            status(model.status);
            nextToken(model.nextToken);
            vocabularies(model.vocabularies);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VocabularyState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VocabularyInfo.Builder> getVocabularies() {
            List<VocabularyInfo.Builder> result = VocabulariesCopier.copyToBuilder(this.vocabularies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVocabularies(Collection<VocabularyInfo.BuilderImpl> vocabularies) {
            this.vocabularies = VocabulariesCopier.copyFromBuilder(vocabularies);
        }

        @Override
        public final Builder vocabularies(Collection<VocabularyInfo> vocabularies) {
            this.vocabularies = VocabulariesCopier.copy(vocabularies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularies(VocabularyInfo... vocabularies) {
            vocabularies(Arrays.asList(vocabularies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularies(Consumer<VocabularyInfo.Builder>... vocabularies) {
            vocabularies(Stream.of(vocabularies).map(c -> VocabularyInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVocabulariesResponse build() {
            return new ListVocabulariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
