/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVocabularyFiltersResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListVocabularyFiltersResponse.Builder, ListVocabularyFiltersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVocabularyFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<VocabularyFilterInfo>> VOCABULARY_FILTERS_FIELD = SdkField
            .<List<VocabularyFilterInfo>> builder(MarshallingType.LIST)
            .memberName("VocabularyFilters")
            .getter(getter(ListVocabularyFiltersResponse::vocabularyFilters))
            .setter(setter(Builder::vocabularyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VocabularyFilterInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(VocabularyFilterInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VOCABULARY_FILTERS_FIELD));

    private final String nextToken;

    private final List<VocabularyFilterInfo> vocabularyFilters;

    private ListVocabularyFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vocabularyFilters = builder.vocabularyFilters;
    }

    /**
     * <p>
     * The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of the
     * page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size,
     * Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
     * <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
     * </p>
     * 
     * @return The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum
     *         size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than
     *         the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next
     *         request to the <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VocabularyFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVocabularyFilters() {
        return vocabularyFilters != null && !(vocabularyFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are more
     * filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code> parameter in
     * the request set to the value of the <code>NextToken</code> field in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVocabularyFilters} method.
     * </p>
     * 
     * @return The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there
     *         are more filters, call the <code>ListVocabularyFilters</code> operation again with the
     *         <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field in
     *         the response.
     */
    public final List<VocabularyFilterInfo> vocabularyFilters() {
        return vocabularyFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVocabularyFilters() ? vocabularyFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabularyFiltersResponse)) {
            return false;
        }
        ListVocabularyFiltersResponse other = (ListVocabularyFiltersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVocabularyFilters() == other.hasVocabularyFilters()
                && Objects.equals(vocabularyFilters(), other.vocabularyFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVocabularyFiltersResponse").add("NextToken", nextToken())
                .add("VocabularyFilters", hasVocabularyFilters() ? vocabularyFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VocabularyFilters":
            return Optional.ofNullable(clazz.cast(vocabularyFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabularyFiltersResponse, T> g) {
        return obj -> g.apply((ListVocabularyFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVocabularyFiltersResponse> {
        /**
         * <p>
         * The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of
         * the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page
         * size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the
         * <code>ListVocabularyFilters</code> operation to return in the next page of jobs.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum
         *        size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list
         *        than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in
         *        the next request to the <code>ListVocabularyFilters</code> operation to return in the next page of
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are
         * more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * 
         * @param vocabularyFilters
         *        The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If
         *        there are more filters, call the <code>ListVocabularyFilters</code> operation again with the
         *        <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilters(Collection<VocabularyFilterInfo> vocabularyFilters);

        /**
         * <p>
         * The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are
         * more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * 
         * @param vocabularyFilters
         *        The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If
         *        there are more filters, call the <code>ListVocabularyFilters</code> operation again with the
         *        <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilters(VocabularyFilterInfo... vocabularyFilters);

        /**
         * <p>
         * The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are
         * more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code>
         * parameter in the request set to the value of the <code>NextToken</code> field in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<VocabularyFilterInfo>.Builder}
         * avoiding the need to create one manually via {@link List<VocabularyFilterInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VocabularyFilterInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #vocabularyFilters(List<VocabularyFilterInfo>)}.
         * 
         * @param vocabularyFilters
         *        a consumer that will call methods on {@link List<VocabularyFilterInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vocabularyFilters(List<VocabularyFilterInfo>)
         */
        Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder>... vocabularyFilters);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VocabularyFilterInfo> vocabularyFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabularyFiltersResponse model) {
            super(model);
            nextToken(model.nextToken);
            vocabularyFilters(model.vocabularyFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VocabularyFilterInfo.Builder> getVocabularyFilters() {
            List<VocabularyFilterInfo.Builder> result = VocabularyFiltersCopier.copyToBuilder(this.vocabularyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVocabularyFilters(Collection<VocabularyFilterInfo.BuilderImpl> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copyFromBuilder(vocabularyFilters);
        }

        @Override
        public final Builder vocabularyFilters(Collection<VocabularyFilterInfo> vocabularyFilters) {
            this.vocabularyFilters = VocabularyFiltersCopier.copy(vocabularyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularyFilters(VocabularyFilterInfo... vocabularyFilters) {
            vocabularyFilters(Arrays.asList(vocabularyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularyFilters(Consumer<VocabularyFilterInfo.Builder>... vocabularyFilters) {
            vocabularyFilters(Stream.of(vocabularyFilters).map(c -> VocabularyFilterInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVocabularyFiltersResponse build() {
            return new ListVocabularyFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
