/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCallAnalyticsJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartCallAnalyticsJobRequest.Builder, StartCallAnalyticsJobRequest> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallAnalyticsJobName").getter(getter(StartCallAnalyticsJobRequest::callAnalyticsJobName))
            .setter(setter(Builder::callAnalyticsJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build())
            .build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartCallAnalyticsJobRequest::media)).setter(setter(Builder::media)).constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocation").getter(getter(StartCallAnalyticsJobRequest::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartCallAnalyticsJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartCallAnalyticsJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<CallAnalyticsJobSettings> SETTINGS_FIELD = SdkField
            .<CallAnalyticsJobSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartCallAnalyticsJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(CallAnalyticsJobSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<ChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(StartCallAnalyticsJobRequest::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD,
            MEDIA_FIELD, OUTPUT_LOCATION_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SETTINGS_FIELD,
            CHANNEL_DEFINITIONS_FIELD));

    private final String callAnalyticsJobName;

    private final Media media;

    private final String outputLocation;

    private final String outputEncryptionKMSKeyId;

    private final String dataAccessRoleArn;

    private final CallAnalyticsJobSettings settings;

    private final List<ChannelDefinition> channelDefinitions;

    private StartCallAnalyticsJobRequest(BuilderImpl builder) {
        super(builder);
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.media = builder.media;
        this.outputLocation = builder.outputLocation;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
    }

    /**
     * <p>
     * The name of the call analytics job. You can't use the string "." or ".." by themselves as the job name. The name
     * must also be unique within an Amazon Web Services account. If you try to create a call analytics job with the
     * same name as a previous call analytics job, you get a <code>ConflictException</code> error.
     * </p>
     * 
     * @return The name of the call analytics job. You can't use the string "." or ".." by themselves as the job name.
     *         The name must also be unique within an Amazon Web Services account. If you try to create a call analytics
     *         job with the same name as a previous call analytics job, you get a <code>ConflictException</code> error.
     */
    public final String callAnalyticsJobName() {
        return callAnalyticsJobName;
    }

    /**
     * Returns the value of the Media property for this object.
     * 
     * @return The value of the Media property for this object.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The Amazon S3 location where the output of the call analytics job is stored. You can provide the following
     * location types to store the output of call analytics job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET1
     * </p>
     * <p>
     * If you specify a bucket, Amazon Transcribe saves the output of the analytics job as a JSON file at the root level
     * of the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET1/folder/
     * </p>
     * <p>
     * f you specify a path, Amazon Transcribe saves the output of the analytics job as
     * s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json.
     * </p>
     * <p>
     * If you specify a folder, you must provide a trailing slash.
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET1/folder/filename.json.
     * </p>
     * <p>
     * If you provide a path that has the filename specified, Amazon Transcribe saves the output of the analytics job as
     * s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of our analytics
     * job using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key, Amazon Transcribe
     * uses the default Amazon S3 key for server-side encryption of the analytics job output that is placed in your S3
     * bucket.
     * </p>
     * 
     * @return The Amazon S3 location where the output of the call analytics job is stored. You can provide the
     *         following location types to store the output of call analytics job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET1
     *         </p>
     *         <p>
     *         If you specify a bucket, Amazon Transcribe saves the output of the analytics job as a JSON file at the
     *         root level of the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET1/folder/
     *         </p>
     *         <p>
     *         f you specify a path, Amazon Transcribe saves the output of the analytics job as
     *         s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json.
     *         </p>
     *         <p>
     *         If you specify a folder, you must provide a trailing slash.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET1/folder/filename.json.
     *         </p>
     *         <p>
     *         If you provide a path that has the filename specified, Amazon Transcribe saves the output of the
     *         analytics job as s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of our
     *         analytics job using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key,
     *         Amazon Transcribe uses the default Amazon S3 key for server-side encryption of the analytics job output
     *         that is placed in your S3 bucket.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service key used to encrypt the output
     * of the call analytics job. The user calling the operation must have permission to use the specified KMS key.
     * </p>
     * <p>
     * You use either of the following to identify an Amazon Web Services KMS key in the current account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS Key Alias: "alias/ExampleAlias"
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use either of the following to identify a KMS key in the current account or another account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS key in the current account or another account:
     * "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN of a KMS Key Alias: "arn:aws:kms:region:accountID:alias/ExampleAlias"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify an encryption key, the output of the call analytics job is encrypted with the default Amazon
     * S3 key (SSE-S3).
     * </p>
     * <p>
     * If you specify a KMS key to encrypt your output, you must also specify an output location in the
     * <code>OutputLocation</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service key used to encrypt the
     *         output of the call analytics job. The user calling the operation must have permission to use the
     *         specified KMS key.</p>
     *         <p>
     *         You use either of the following to identify an Amazon Web Services KMS key in the current account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS Key Alias: "alias/ExampleAlias"
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can use either of the following to identify a KMS key in the current account or another account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS key in the current account or another account:
     *         "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN of a KMS Key Alias: "arn:aws:kms:region:accountID:alias/ExampleAlias"
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify an encryption key, the output of the call analytics job is encrypted with the
     *         default Amazon S3 key (SSE-S3).
     *         </p>
     *         <p>
     *         If you specify a KMS key to encrypt your output, you must also specify an output location in the
     *         <code>OutputLocation</code> parameter.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains your input files. Amazon
     * Transcribe assumes this role to read queued audio files. If you have specified an output S3 bucket for your
     * transcription results, this role should have access to the output bucket as well.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains your input files.
     *         Amazon Transcribe assumes this role to read queued audio files. If you have specified an output S3 bucket
     *         for your transcription results, this role should have access to the output bucket as well.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * A <code>Settings</code> object that provides optional settings for a call analytics job.
     * </p>
     * 
     * @return A <code>Settings</code> object that provides optional settings for a call analytics job.
     */
    public final CallAnalyticsJobSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When you start a call analytics job, you must pass an array that maps the agent and the customer to specific
     * audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer must each have
     * their own channel. You can't assign more than one channel to an agent or customer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return When you start a call analytics job, you must pass an array that maps the agent and the customer to
     *         specific audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer
     *         must each have their own channel. You can't assign more than one channel to an agent or customer.
     */
    public final List<ChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCallAnalyticsJobRequest)) {
            return false;
        }
        StartCallAnalyticsJobRequest other = (StartCallAnalyticsJobRequest) obj;
        return Objects.equals(callAnalyticsJobName(), other.callAnalyticsJobName()) && Objects.equals(media(), other.media())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(settings(), other.settings())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCallAnalyticsJobRequest").add("CallAnalyticsJobName", callAnalyticsJobName())
                .add("Media", media()).add("OutputLocation", outputLocation())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId()).add("DataAccessRoleArn", dataAccessRoleArn())
                .add("Settings", settings()).add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallAnalyticsJobName":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobName()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCallAnalyticsJobRequest, T> g) {
        return obj -> g.apply((StartCallAnalyticsJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCallAnalyticsJobRequest> {
        /**
         * <p>
         * The name of the call analytics job. You can't use the string "." or ".." by themselves as the job name. The
         * name must also be unique within an Amazon Web Services account. If you try to create a call analytics job
         * with the same name as a previous call analytics job, you get a <code>ConflictException</code> error.
         * </p>
         * 
         * @param callAnalyticsJobName
         *        The name of the call analytics job. You can't use the string "." or ".." by themselves as the job
         *        name. The name must also be unique within an Amazon Web Services account. If you try to create a call
         *        analytics job with the same name as a previous call analytics job, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobName(String callAnalyticsJobName);

        /**
         * Sets the value of the Media property for this object.
         *
         * @param media
         *        The new value for the Media property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * Sets the value of the Media property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Media.Builder} avoiding the need to
         * create one manually via {@link Media#builder()}.
         *
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The Amazon S3 location where the output of the call analytics job is stored. You can provide the following
         * location types to store the output of call analytics job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET1
         * </p>
         * <p>
         * If you specify a bucket, Amazon Transcribe saves the output of the analytics job as a JSON file at the root
         * level of the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET1/folder/
         * </p>
         * <p>
         * f you specify a path, Amazon Transcribe saves the output of the analytics job as
         * s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json.
         * </p>
         * <p>
         * If you specify a folder, you must provide a trailing slash.
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET1/folder/filename.json.
         * </p>
         * <p>
         * If you provide a path that has the filename specified, Amazon Transcribe saves the output of the analytics
         * job as s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of our
         * analytics job using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS key,
         * Amazon Transcribe uses the default Amazon S3 key for server-side encryption of the analytics job output that
         * is placed in your S3 bucket.
         * </p>
         * 
         * @param outputLocation
         *        The Amazon S3 location where the output of the call analytics job is stored. You can provide the
         *        following location types to store the output of call analytics job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET1
         *        </p>
         *        <p>
         *        If you specify a bucket, Amazon Transcribe saves the output of the analytics job as a JSON file at the
         *        root level of the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET1/folder/
         *        </p>
         *        <p>
         *        f you specify a path, Amazon Transcribe saves the output of the analytics job as
         *        s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json.
         *        </p>
         *        <p>
         *        If you specify a folder, you must provide a trailing slash.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET1/folder/filename.json.
         *        </p>
         *        <p>
         *        If you provide a path that has the filename specified, Amazon Transcribe saves the output of the
         *        analytics job as s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify an Amazon Web Services Key Management Service (KMS) key to encrypt the output of our
         *        analytics job using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don't specify a KMS
         *        key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption of the analytics job
         *        output that is placed in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service key used to encrypt the
         * output of the call analytics job. The user calling the operation must have permission to use the specified
         * KMS key.
         * </p>
         * <p>
         * You use either of the following to identify an Amazon Web Services KMS key in the current account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS Key Alias: "alias/ExampleAlias"
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can use either of the following to identify a KMS key in the current account or another account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS key in the current account or another account:
         * "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN of a KMS Key Alias: "arn:aws:kms:region:accountID:alias/ExampleAlias"
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify an encryption key, the output of the call analytics job is encrypted with the default
         * Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * If you specify a KMS key to encrypt your output, you must also specify an output location in the
         * <code>OutputLocation</code> parameter.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service key used to encrypt
         *        the output of the call analytics job. The user calling the operation must have permission to use the
         *        specified KMS key.</p>
         *        <p>
         *        You use either of the following to identify an Amazon Web Services KMS key in the current account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS Key Alias: "alias/ExampleAlias"
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can use either of the following to identify a KMS key in the current account or another account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS key in the current account or another account:
         *        "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN of a KMS Key Alias: "arn:aws:kms:region:accountID:alias/ExampleAlias"
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify an encryption key, the output of the call analytics job is encrypted with the
         *        default Amazon S3 key (SSE-S3).
         *        </p>
         *        <p>
         *        If you specify a KMS key to encrypt your output, you must also specify an output location in the
         *        <code>OutputLocation</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains your input files.
         * Amazon Transcribe assumes this role to read queued audio files. If you have specified an output S3 bucket for
         * your transcription results, this role should have access to the output bucket as well.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains your input
         *        files. Amazon Transcribe assumes this role to read queued audio files. If you have specified an output
         *        S3 bucket for your transcription results, this role should have access to the output bucket as well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * A <code>Settings</code> object that provides optional settings for a call analytics job.
         * </p>
         * 
         * @param settings
         *        A <code>Settings</code> object that provides optional settings for a call analytics job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(CallAnalyticsJobSettings settings);

        /**
         * <p>
         * A <code>Settings</code> object that provides optional settings for a call analytics job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CallAnalyticsJobSettings.Builder}
         * avoiding the need to create one manually via {@link CallAnalyticsJobSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CallAnalyticsJobSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(CallAnalyticsJobSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link CallAnalyticsJobSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(CallAnalyticsJobSettings)
         */
        default Builder settings(Consumer<CallAnalyticsJobSettings.Builder> settings) {
            return settings(CallAnalyticsJobSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * When you start a call analytics job, you must pass an array that maps the agent and the customer to specific
         * audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer must each have
         * their own channel. You can't assign more than one channel to an agent or customer.
         * </p>
         * 
         * @param channelDefinitions
         *        When you start a call analytics job, you must pass an array that maps the agent and the customer to
         *        specific audio channels. The values you can assign to a channel are 0 and 1. The agent and the
         *        customer must each have their own channel. You can't assign more than one channel to an agent or
         *        customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions);

        /**
         * <p>
         * When you start a call analytics job, you must pass an array that maps the agent and the customer to specific
         * audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer must each have
         * their own channel. You can't assign more than one channel to an agent or customer.
         * </p>
         * 
         * @param channelDefinitions
         *        When you start a call analytics job, you must pass an array that maps the agent and the customer to
         *        specific audio channels. The values you can assign to a channel are 0 and 1. The agent and the
         *        customer must each have their own channel. You can't assign more than one channel to an agent or
         *        customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(ChannelDefinition... channelDefinitions);

        /**
         * <p>
         * When you start a call analytics job, you must pass an array that maps the agent and the customer to specific
         * audio channels. The values you can assign to a channel are 0 and 1. The agent and the customer must each have
         * their own channel. You can't assign more than one channel to an agent or customer.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ChannelDefinition>.Builder} avoiding
         * the need to create one manually via {@link List<ChannelDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #channelDefinitions(List<ChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on {@link List<ChannelDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(List<ChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String callAnalyticsJobName;

        private Media media;

        private String outputLocation;

        private String outputEncryptionKMSKeyId;

        private String dataAccessRoleArn;

        private CallAnalyticsJobSettings settings;

        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCallAnalyticsJobRequest model) {
            super(model);
            callAnalyticsJobName(model.callAnalyticsJobName);
            media(model.media);
            outputLocation(model.outputLocation);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            dataAccessRoleArn(model.dataAccessRoleArn);
            settings(model.settings);
            channelDefinitions(model.channelDefinitions);
        }

        public final String getCallAnalyticsJobName() {
            return callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final CallAnalyticsJobSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(CallAnalyticsJobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(CallAnalyticsJobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions).map(c -> ChannelDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCallAnalyticsJobRequest build() {
            return new StartCallAnalyticsJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
