/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the location of a transcription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transcript implements SdkPojo, Serializable, ToCopyableBuilder<Transcript.Builder, Transcript> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptFileUri").getter(getter(Transcript::transcriptFileUri))
            .setter(setter(Builder::transcriptFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()).build();

    private static final SdkField<String> REDACTED_TRANSCRIPT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedactedTranscriptFileUri").getter(getter(Transcript::redactedTranscriptFileUri))
            .setter(setter(Builder::redactedTranscriptFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedTranscriptFileUri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD,
            REDACTED_TRANSCRIPT_FILE_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptFileUri;

    private final String redactedTranscriptFileUri;

    private Transcript(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
        this.redactedTranscriptFileUri = builder.redactedTranscriptFileUri;
    }

    /**
     * <p>
     * The S3 object location of the transcript.
     * </p>
     * <p>
     * Use this URI to access the transcript. If you specified an S3 bucket in the <code>OutputBucketName</code> field
     * when you created the job, this is the URI of that bucket. If you chose to store the transcript in Amazon
     * Transcribe, this is a shareable URL that provides secure access to that location.
     * </p>
     * 
     * @return The S3 object location of the transcript.</p>
     *         <p>
     *         Use this URI to access the transcript. If you specified an S3 bucket in the <code>OutputBucketName</code>
     *         field when you created the job, this is the URI of that bucket. If you chose to store the transcript in
     *         Amazon Transcribe, this is a shareable URL that provides secure access to that location.
     */
    public final String transcriptFileUri() {
        return transcriptFileUri;
    }

    /**
     * <p>
     * The S3 object location of the redacted transcript.
     * </p>
     * <p>
     * Use this URI to access the redacted transcript. If you specified an S3 bucket in the
     * <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to
     * store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that location.
     * </p>
     * 
     * @return The S3 object location of the redacted transcript.</p>
     *         <p>
     *         Use this URI to access the redacted transcript. If you specified an S3 bucket in the
     *         <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you
     *         chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access
     *         to that location.
     */
    public final String redactedTranscriptFileUri() {
        return redactedTranscriptFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(redactedTranscriptFileUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript) obj;
        return Objects.equals(transcriptFileUri(), other.transcriptFileUri())
                && Objects.equals(redactedTranscriptFileUri(), other.redactedTranscriptFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Transcript").add("TranscriptFileUri", transcriptFileUri())
                .add("RedactedTranscriptFileUri", redactedTranscriptFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptFileUri":
            return Optional.ofNullable(clazz.cast(transcriptFileUri()));
        case "RedactedTranscriptFileUri":
            return Optional.ofNullable(clazz.cast(redactedTranscriptFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transcript> {
        /**
         * <p>
         * The S3 object location of the transcript.
         * </p>
         * <p>
         * Use this URI to access the transcript. If you specified an S3 bucket in the <code>OutputBucketName</code>
         * field when you created the job, this is the URI of that bucket. If you chose to store the transcript in
         * Amazon Transcribe, this is a shareable URL that provides secure access to that location.
         * </p>
         * 
         * @param transcriptFileUri
         *        The S3 object location of the transcript.</p>
         *        <p>
         *        Use this URI to access the transcript. If you specified an S3 bucket in the
         *        <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you
         *        chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure
         *        access to that location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFileUri(String transcriptFileUri);

        /**
         * <p>
         * The S3 object location of the redacted transcript.
         * </p>
         * <p>
         * Use this URI to access the redacted transcript. If you specified an S3 bucket in the
         * <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to
         * store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that
         * location.
         * </p>
         * 
         * @param redactedTranscriptFileUri
         *        The S3 object location of the redacted transcript.</p>
         *        <p>
         *        Use this URI to access the redacted transcript. If you specified an S3 bucket in the
         *        <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you
         *        chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure
         *        access to that location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactedTranscriptFileUri(String redactedTranscriptFileUri);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptFileUri;

        private String redactedTranscriptFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            transcriptFileUri(model.transcriptFileUri);
            redactedTranscriptFileUri(model.redactedTranscriptFileUri);
        }

        public final String getTranscriptFileUri() {
            return transcriptFileUri;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        public final String getRedactedTranscriptFileUri() {
            return redactedTranscriptFileUri;
        }

        public final void setRedactedTranscriptFileUri(String redactedTranscriptFileUri) {
            this.redactedTranscriptFileUri = redactedTranscriptFileUri;
        }

        @Override
        public final Builder redactedTranscriptFileUri(String redactedTranscriptFileUri) {
            this.redactedTranscriptFileUri = redactedTranscriptFileUri;
            return this;
        }

        @Override
        public Transcript build() {
            return new Transcript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
