/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of information about a transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptionJobSummary.Builder, TranscriptionJobSummary> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptionJobName").getter(getter(TranscriptionJobSummary::transcriptionJobName))
            .setter(setter(Builder::transcriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TranscriptionJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(TranscriptionJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(TranscriptionJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(TranscriptionJobSummary::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptionJobStatus").getter(getter(TranscriptionJobSummary::transcriptionJobStatusAsString))
            .setter(setter(Builder::transcriptionJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(TranscriptionJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocationType").getter(getter(TranscriptionJobSummary::outputLocationTypeAsString))
            .setter(setter(Builder::outputLocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build())
            .build();

    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField
            .<ContentRedaction> builder(MarshallingType.SDK_POJO).memberName("ContentRedaction")
            .getter(getter(TranscriptionJobSummary::contentRedaction)).setter(setter(Builder::contentRedaction))
            .constructor(ContentRedaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()).build();

    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField
            .<ModelSettings> builder(MarshallingType.SDK_POJO).memberName("ModelSettings")
            .getter(getter(TranscriptionJobSummary::modelSettings)).setter(setter(Builder::modelSettings))
            .constructor(ModelSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()).build();

    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IdentifyLanguage").getter(getter(TranscriptionJobSummary::identifyLanguage))
            .setter(setter(Builder::identifyLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()).build();

    private static final SdkField<Float> IDENTIFIED_LANGUAGE_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("IdentifiedLanguageScore").getter(getter(TranscriptionJobSummary::identifiedLanguageScore))
            .setter(setter(Builder::identifiedLanguageScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedLanguageScore").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD,
            CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD,
            FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD, CONTENT_REDACTION_FIELD, MODEL_SETTINGS_FIELD,
            IDENTIFY_LANGUAGE_FIELD, IDENTIFIED_LANGUAGE_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptionJobName;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant completionTime;

    private final String languageCode;

    private final String transcriptionJobStatus;

    private final String failureReason;

    private final String outputLocationType;

    private final ContentRedaction contentRedaction;

    private final ModelSettings modelSettings;

    private final Boolean identifyLanguage;

    private final Float identifiedLanguageScore;

    private TranscriptionJobSummary(BuilderImpl builder) {
        this.transcriptionJobName = builder.transcriptionJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
        this.contentRedaction = builder.contentRedaction;
        this.modelSettings = builder.modelSettings;
        this.identifyLanguage = builder.identifyLanguage;
        this.identifiedLanguageScore = builder.identifiedLanguageScore;
    }

    /**
     * <p>
     * The name of the transcription job.
     * </p>
     * 
     * @return The name of the transcription job.
     */
    public final String transcriptionJobName() {
        return transcriptionJobName;
    }

    /**
     * <p>
     * A timestamp that shows when the job was created.
     * </p>
     * 
     * @return A timestamp that shows when the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job started processing.
     * </p>
     * 
     * @return A timestamp that shows when the job started processing.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job was completed.
     * </p>
     * 
     * @return A timestamp that shows when the job was completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The language code for the input speech.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input speech.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the input speech.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the input speech.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     *         <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * @see TranscriptionJobStatus
     */
    public final TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(transcriptionJobStatus);
    }

    /**
     * <p>
     * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return The status of the transcription job. When the status is <code>COMPLETED</code>, use the
     *         <code>GetTranscriptionJob</code> operation to get the results of the transcription.
     * @see TranscriptionJobStatus
     */
    public final String transcriptionJobStatusAsString() {
        return transcriptionJobStatus;
    }

    /**
     * <p>
     * If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
     * </p>
     * 
     * @return If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Indicates the location of the output of the transcription job.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     * <code>outputBucketName</code> field when the transcription job was started with the
     * <code>StartTranscriptionJob</code> operation.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved
     * using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates the location of the output of the transcription job.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     *         <code>outputBucketName</code> field when the transcription job was started with the
     *         <code>StartTranscriptionJob</code> operation.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
     *         retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
     *         field.
     * @see OutputLocationType
     */
    public final OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(outputLocationType);
    }

    /**
     * <p>
     * Indicates the location of the output of the transcription job.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     * <code>outputBucketName</code> field when the transcription job was started with the
     * <code>StartTranscriptionJob</code> operation.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved
     * using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates the location of the output of the transcription job.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
     *         <code>outputBucketName</code> field when the transcription job was started with the
     *         <code>StartTranscriptionJob</code> operation.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
     *         retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
     *         field.
     * @see OutputLocationType
     */
    public final String outputLocationTypeAsString() {
        return outputLocationType;
    }

    /**
     * <p>
     * The content redaction settings of the transcription job.
     * </p>
     * 
     * @return The content redaction settings of the transcription job.
     */
    public final ContentRedaction contentRedaction() {
        return contentRedaction;
    }

    /**
     * Returns the value of the ModelSettings property for this object.
     * 
     * @return The value of the ModelSettings property for this object.
     */
    public final ModelSettings modelSettings() {
        return modelSettings;
    }

    /**
     * <p>
     * Whether automatic language identification was enabled for a transcription job.
     * </p>
     * 
     * @return Whether automatic language identification was enabled for a transcription job.
     */
    public final Boolean identifyLanguage() {
        return identifyLanguage;
    }

    /**
     * <p>
     * A value between zero and one that Amazon Transcribe assigned to the language it identified in the source audio. A
     * higher score indicates that Amazon Transcribe is more confident in the language it identified.
     * </p>
     * 
     * @return A value between zero and one that Amazon Transcribe assigned to the language it identified in the source
     *         audio. A higher score indicates that Amazon Transcribe is more confident in the language it identified.
     */
    public final Float identifiedLanguageScore() {
        return identifiedLanguageScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(identifiedLanguageScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJobSummary)) {
            return false;
        }
        TranscriptionJobSummary other = (TranscriptionJobSummary) obj;
        return Objects.equals(transcriptionJobName(), other.transcriptionJobName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(outputLocationTypeAsString(), other.outputLocationTypeAsString())
                && Objects.equals(contentRedaction(), other.contentRedaction())
                && Objects.equals(modelSettings(), other.modelSettings())
                && Objects.equals(identifyLanguage(), other.identifyLanguage())
                && Objects.equals(identifiedLanguageScore(), other.identifiedLanguageScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptionJobSummary").add("TranscriptionJobName", transcriptionJobName())
                .add("CreationTime", creationTime()).add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("LanguageCode", languageCodeAsString()).add("TranscriptionJobStatus", transcriptionJobStatusAsString())
                .add("FailureReason", failureReason()).add("OutputLocationType", outputLocationTypeAsString())
                .add("ContentRedaction", contentRedaction()).add("ModelSettings", modelSettings())
                .add("IdentifyLanguage", identifyLanguage()).add("IdentifiedLanguageScore", identifiedLanguageScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptionJobName":
            return Optional.ofNullable(clazz.cast(transcriptionJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "TranscriptionJobStatus":
            return Optional.ofNullable(clazz.cast(transcriptionJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "OutputLocationType":
            return Optional.ofNullable(clazz.cast(outputLocationTypeAsString()));
        case "ContentRedaction":
            return Optional.ofNullable(clazz.cast(contentRedaction()));
        case "ModelSettings":
            return Optional.ofNullable(clazz.cast(modelSettings()));
        case "IdentifyLanguage":
            return Optional.ofNullable(clazz.cast(identifyLanguage()));
        case "IdentifiedLanguageScore":
            return Optional.ofNullable(clazz.cast(identifiedLanguageScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionJobSummary, T> g) {
        return obj -> g.apply((TranscriptionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptionJobSummary> {
        /**
         * <p>
         * The name of the transcription job.
         * </p>
         * 
         * @param transcriptionJobName
         *        The name of the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionJobName(String transcriptionJobName);

        /**
         * <p>
         * A timestamp that shows when the job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the job started processing.
         * </p>
         * 
         * @param startTime
         *        A timestamp that shows when the job started processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A timestamp that shows when the job was completed.
         * </p>
         * 
         * @param completionTime
         *        A timestamp that shows when the job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The language code for the input speech.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input speech.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the input speech.
         * </p>
         * 
         * @param languageCode
         *        The language code for the input speech.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         *        <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(String transcriptionJobStatus);

        /**
         * <p>
         * The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         * <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        The status of the transcription job. When the status is <code>COMPLETED</code>, use the
         *        <code>GetTranscriptionJob</code> operation to get the results of the transcription.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus);

        /**
         * <p>
         * If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
         * </p>
         * 
         * @param failureReason
         *        If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Indicates the location of the output of the transcription job.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         * <code>outputBucketName</code> field when the transcription job was started with the
         * <code>StartTranscriptionJob</code> operation.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         * retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
         * field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates the location of the output of the transcription job.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         *        <code>outputBucketName</code> field when the transcription job was started with the
         *        <code>StartTranscriptionJob</code> operation.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         *        retrieved using the URI in the <code>GetTranscriptionJob</code> response's
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(String outputLocationType);

        /**
         * <p>
         * Indicates the location of the output of the transcription job.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         * <code>outputBucketName</code> field when the transcription job was started with the
         * <code>StartTranscriptionJob</code> operation.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         * retrieved using the URI in the <code>GetTranscriptionJob</code> response's <code>TranscriptFileUri</code>
         * field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates the location of the output of the transcription job.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the
         *        <code>outputBucketName</code> field when the transcription job was started with the
         *        <code>StartTranscriptionJob</code> operation.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be
         *        retrieved using the URI in the <code>GetTranscriptionJob</code> response's
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(OutputLocationType outputLocationType);

        /**
         * <p>
         * The content redaction settings of the transcription job.
         * </p>
         * 
         * @param contentRedaction
         *        The content redaction settings of the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRedaction(ContentRedaction contentRedaction);

        /**
         * <p>
         * The content redaction settings of the transcription job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentRedaction.Builder} avoiding the
         * need to create one manually via {@link ContentRedaction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContentRedaction.Builder#build()} is called immediately and its
         * result is passed to {@link #contentRedaction(ContentRedaction)}.
         * 
         * @param contentRedaction
         *        a consumer that will call methods on {@link ContentRedaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentRedaction(ContentRedaction)
         */
        default Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return contentRedaction(ContentRedaction.builder().applyMutation(contentRedaction).build());
        }

        /**
         * Sets the value of the ModelSettings property for this object.
         *
         * @param modelSettings
         *        The new value for the ModelSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSettings(ModelSettings modelSettings);

        /**
         * Sets the value of the ModelSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ModelSettings.Builder} avoiding the need
         * to create one manually via {@link ModelSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #modelSettings(ModelSettings)}.
         * 
         * @param modelSettings
         *        a consumer that will call methods on {@link ModelSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelSettings(ModelSettings)
         */
        default Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return modelSettings(ModelSettings.builder().applyMutation(modelSettings).build());
        }

        /**
         * <p>
         * Whether automatic language identification was enabled for a transcription job.
         * </p>
         * 
         * @param identifyLanguage
         *        Whether automatic language identification was enabled for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifyLanguage(Boolean identifyLanguage);

        /**
         * <p>
         * A value between zero and one that Amazon Transcribe assigned to the language it identified in the source
         * audio. A higher score indicates that Amazon Transcribe is more confident in the language it identified.
         * </p>
         * 
         * @param identifiedLanguageScore
         *        A value between zero and one that Amazon Transcribe assigned to the language it identified in the
         *        source audio. A higher score indicates that Amazon Transcribe is more confident in the language it
         *        identified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiedLanguageScore(Float identifiedLanguageScore);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptionJobName;

        private Instant creationTime;

        private Instant startTime;

        private Instant completionTime;

        private String languageCode;

        private String transcriptionJobStatus;

        private String failureReason;

        private String outputLocationType;

        private ContentRedaction contentRedaction;

        private ModelSettings modelSettings;

        private Boolean identifyLanguage;

        private Float identifiedLanguageScore;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionJobSummary model) {
            transcriptionJobName(model.transcriptionJobName);
            creationTime(model.creationTime);
            startTime(model.startTime);
            completionTime(model.completionTime);
            languageCode(model.languageCode);
            transcriptionJobStatus(model.transcriptionJobStatus);
            failureReason(model.failureReason);
            outputLocationType(model.outputLocationType);
            contentRedaction(model.contentRedaction);
            modelSettings(model.modelSettings);
            identifyLanguage(model.identifyLanguage);
            identifiedLanguageScore(model.identifiedLanguageScore);
        }

        public final String getTranscriptionJobName() {
            return transcriptionJobName;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getTranscriptionJobStatus() {
            return transcriptionJobStatus;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOutputLocationType() {
            return outputLocationType;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType == null ? null : outputLocationType.toString());
            return this;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return contentRedaction != null ? contentRedaction.toBuilder() : null;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final ModelSettings.Builder getModelSettings() {
            return modelSettings != null ? modelSettings.toBuilder() : null;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final Float getIdentifiedLanguageScore() {
            return identifiedLanguageScore;
        }

        public final void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
        }

        @Override
        public final Builder identifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
            return this;
        }

        @Override
        public TranscriptionJobSummary build() {
            return new TranscriptionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
