/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 location where your subtitle files are located. Note that your subtitle files are placed in the same location
 * as your transcription output. Refer to <code>TranscriptFileUri</code> to download your files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubtitlesOutput implements SdkPojo, Serializable, ToCopyableBuilder<SubtitlesOutput.Builder, SubtitlesOutput> {
    private static final SdkField<List<String>> FORMATS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Formats")
            .getter(getter(SubtitlesOutput::formatsAsStrings))
            .setter(setter(Builder::formatsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBTITLE_FILE_URIS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubtitleFileUris")
            .getter(getter(SubtitlesOutput::subtitleFileUris))
            .setter(setter(Builder::subtitleFileUris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubtitleFileUris").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> OUTPUT_START_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OutputStartIndex").getter(getter(SubtitlesOutput::outputStartIndex))
            .setter(setter(Builder::outputStartIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputStartIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMATS_FIELD,
            SUBTITLE_FILE_URIS_FIELD, OUTPUT_START_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> formats;

    private final List<String> subtitleFileUris;

    private final Integer outputStartIndex;

    private SubtitlesOutput(BuilderImpl builder) {
        this.formats = builder.formats;
        this.subtitleFileUris = builder.subtitleFileUris;
        this.outputStartIndex = builder.outputStartIndex;
    }

    /**
     * <p>
     * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code> formats,
     * both formats are shown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormats} method.
     * </p>
     * 
     * @return The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
     *         formats, both formats are shown.
     */
    public final List<SubtitleFormat> formats() {
        return SubtitleFormatsCopier.copyStringToEnum(formats);
    }

    /**
     * For responses, this returns true if the service returned a value for the Formats property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFormats() {
        return formats != null && !(formats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code> formats,
     * both formats are shown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormats} method.
     * </p>
     * 
     * @return The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
     *         formats, both formats are shown.
     */
    public final List<String> formatsAsStrings() {
        return formats;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubtitleFileUris property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubtitleFileUris() {
        return subtitleFileUris != null && !(subtitleFileUris instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the output location for your subtitle file. This location must be an S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubtitleFileUris} method.
     * </p>
     * 
     * @return Contains the output location for your subtitle file. This location must be an S3 bucket.
     */
    public final List<String> subtitleFileUris() {
        return subtitleFileUris;
    }

    /**
     * <p>
     * Shows the output start index value for your subtitle files. If you did not specify a value in your request, the
     * default value of <code>0</code> is used.
     * </p>
     * 
     * @return Shows the output start index value for your subtitle files. If you did not specify a value in your
     *         request, the default value of <code>0</code> is used.
     */
    public final Integer outputStartIndex() {
        return outputStartIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFormats() ? formatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubtitleFileUris() ? subtitleFileUris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputStartIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtitlesOutput)) {
            return false;
        }
        SubtitlesOutput other = (SubtitlesOutput) obj;
        return hasFormats() == other.hasFormats() && Objects.equals(formatsAsStrings(), other.formatsAsStrings())
                && hasSubtitleFileUris() == other.hasSubtitleFileUris()
                && Objects.equals(subtitleFileUris(), other.subtitleFileUris())
                && Objects.equals(outputStartIndex(), other.outputStartIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubtitlesOutput").add("Formats", hasFormats() ? formatsAsStrings() : null)
                .add("SubtitleFileUris", hasSubtitleFileUris() ? subtitleFileUris() : null)
                .add("OutputStartIndex", outputStartIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Formats":
            return Optional.ofNullable(clazz.cast(formatsAsStrings()));
        case "SubtitleFileUris":
            return Optional.ofNullable(clazz.cast(subtitleFileUris()));
        case "OutputStartIndex":
            return Optional.ofNullable(clazz.cast(outputStartIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubtitlesOutput, T> g) {
        return obj -> g.apply((SubtitlesOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubtitlesOutput> {
        /**
         * <p>
         * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
         * formats, both formats are shown.
         * </p>
         * 
         * @param formats
         *        The format of your subtitle files. If your request specified both <code>srt</code> and
         *        <code>vtt</code> formats, both formats are shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatsWithStrings(Collection<String> formats);

        /**
         * <p>
         * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
         * formats, both formats are shown.
         * </p>
         * 
         * @param formats
         *        The format of your subtitle files. If your request specified both <code>srt</code> and
         *        <code>vtt</code> formats, both formats are shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatsWithStrings(String... formats);

        /**
         * <p>
         * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
         * formats, both formats are shown.
         * </p>
         * 
         * @param formats
         *        The format of your subtitle files. If your request specified both <code>srt</code> and
         *        <code>vtt</code> formats, both formats are shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formats(Collection<SubtitleFormat> formats);

        /**
         * <p>
         * The format of your subtitle files. If your request specified both <code>srt</code> and <code>vtt</code>
         * formats, both formats are shown.
         * </p>
         * 
         * @param formats
         *        The format of your subtitle files. If your request specified both <code>srt</code> and
         *        <code>vtt</code> formats, both formats are shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formats(SubtitleFormat... formats);

        /**
         * <p>
         * Contains the output location for your subtitle file. This location must be an S3 bucket.
         * </p>
         * 
         * @param subtitleFileUris
         *        Contains the output location for your subtitle file. This location must be an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitleFileUris(Collection<String> subtitleFileUris);

        /**
         * <p>
         * Contains the output location for your subtitle file. This location must be an S3 bucket.
         * </p>
         * 
         * @param subtitleFileUris
         *        Contains the output location for your subtitle file. This location must be an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitleFileUris(String... subtitleFileUris);

        /**
         * <p>
         * Shows the output start index value for your subtitle files. If you did not specify a value in your request,
         * the default value of <code>0</code> is used.
         * </p>
         * 
         * @param outputStartIndex
         *        Shows the output start index value for your subtitle files. If you did not specify a value in your
         *        request, the default value of <code>0</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputStartIndex(Integer outputStartIndex);
    }

    static final class BuilderImpl implements Builder {
        private List<String> formats = DefaultSdkAutoConstructList.getInstance();

        private List<String> subtitleFileUris = DefaultSdkAutoConstructList.getInstance();

        private Integer outputStartIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(SubtitlesOutput model) {
            formatsWithStrings(model.formats);
            subtitleFileUris(model.subtitleFileUris);
            outputStartIndex(model.outputStartIndex);
        }

        public final Collection<String> getFormats() {
            if (formats instanceof SdkAutoConstructList) {
                return null;
            }
            return formats;
        }

        public final void setFormats(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
        }

        @Override
        public final Builder formatsWithStrings(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formatsWithStrings(String... formats) {
            formatsWithStrings(Arrays.asList(formats));
            return this;
        }

        @Override
        public final Builder formats(Collection<SubtitleFormat> formats) {
            this.formats = SubtitleFormatsCopier.copyEnumToString(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formats(SubtitleFormat... formats) {
            formats(Arrays.asList(formats));
            return this;
        }

        public final Collection<String> getSubtitleFileUris() {
            if (subtitleFileUris instanceof SdkAutoConstructList) {
                return null;
            }
            return subtitleFileUris;
        }

        public final void setSubtitleFileUris(Collection<String> subtitleFileUris) {
            this.subtitleFileUris = SubtitleFileUrisCopier.copy(subtitleFileUris);
        }

        @Override
        public final Builder subtitleFileUris(Collection<String> subtitleFileUris) {
            this.subtitleFileUris = SubtitleFileUrisCopier.copy(subtitleFileUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subtitleFileUris(String... subtitleFileUris) {
            subtitleFileUris(Arrays.asList(subtitleFileUris));
            return this;
        }

        public final Integer getOutputStartIndex() {
            return outputStartIndex;
        }

        public final void setOutputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
        }

        @Override
        public final Builder outputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
            return this;
        }

        @Override
        public SubtitlesOutput build() {
            return new SubtitlesOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
