/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MediaFormat;
import software.amazon.awssdk.services.transcribe.model.MedicalContentIdentificationType;
import software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting;
import software.amazon.awssdk.services.transcribe.model.Specialty;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMedicalTranscriptionJobRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, StartMedicalTranscriptionJobRequest> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalTranscriptionJobName").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::medicalTranscriptionJobName)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::medicalTranscriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::languageCodeAsString)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::mediaSampleRateHertz)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFormat").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::mediaFormatAsString)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::mediaFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::media)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputBucketName").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::outputBucketName)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::outputBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()}).build();
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputKey").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::outputKey)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::outputKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()}).build();
    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputEncryptionKMSKeyId").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::outputEncryptionKMSKeyId)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::outputEncryptionKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build()}).build();
    private static final SdkField<MedicalTranscriptionSetting> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::settings)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::settings)).constructor(MedicalTranscriptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::contentIdentificationTypeAsString)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build()}).build();
    private static final SdkField<String> SPECIALTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Specialty").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::specialtyAsString)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::specialty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(StartMedicalTranscriptionJobRequest.getter(StartMedicalTranscriptionJobRequest::typeAsString)).setter(StartMedicalTranscriptionJobRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_KEY_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, SETTINGS_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, SPECIALTY_FIELD, TYPE_FIELD));
    private final String medicalTranscriptionJobName;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaFormat;
    private final Media media;
    private final String outputBucketName;
    private final String outputKey;
    private final String outputEncryptionKMSKeyId;
    private final MedicalTranscriptionSetting settings;
    private final String contentIdentificationType;
    private final String specialty;
    private final String type;

    private StartMedicalTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputKey = builder.outputKey;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.settings = builder.settings;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.specialty = builder.specialty;
        this.type = builder.type;
    }

    public final String medicalTranscriptionJobName() {
        return this.medicalTranscriptionJobName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(this.mediaFormat);
    }

    public final String mediaFormatAsString() {
        return this.mediaFormat;
    }

    public final Media media() {
        return this.media;
    }

    public final String outputBucketName() {
        return this.outputBucketName;
    }

    public final String outputKey() {
        return this.outputKey;
    }

    public final String outputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public final MedicalTranscriptionSetting settings() {
        return this.settings;
    }

    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    public final Specialty specialty() {
        return Specialty.fromValue(this.specialty);
    }

    public final String specialtyAsString() {
        return this.specialty;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalTranscriptionJobRequest)) {
            return false;
        }
        StartMedicalTranscriptionJobRequest other = (StartMedicalTranscriptionJobRequest)((Object)obj);
        return Objects.equals(this.medicalTranscriptionJobName(), other.medicalTranscriptionJobName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.outputBucketName(), other.outputBucketName()) && Objects.equals(this.outputKey(), other.outputKey()) && Objects.equals(this.outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString()) && Objects.equals(this.specialtyAsString(), other.specialtyAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartMedicalTranscriptionJobRequest").add("MedicalTranscriptionJobName", (Object)this.medicalTranscriptionJobName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaFormat", (Object)this.mediaFormatAsString()).add("Media", (Object)this.media()).add("OutputBucketName", (Object)this.outputBucketName()).add("OutputKey", (Object)this.outputKey()).add("OutputEncryptionKMSKeyId", (Object)this.outputEncryptionKMSKeyId()).add("Settings", (Object)this.settings()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).add("Specialty", (Object)this.specialtyAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalTranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalTranscriptionJobName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaFormat": {
                return Optional.ofNullable(clazz.cast(this.mediaFormatAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "OutputBucketName": {
                return Optional.ofNullable(clazz.cast(this.outputBucketName()));
            }
            case "OutputKey": {
                return Optional.ofNullable(clazz.cast(this.outputKey()));
            }
            case "OutputEncryptionKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.outputEncryptionKMSKeyId()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
            case "Specialty": {
                return Optional.ofNullable(clazz.cast(this.specialtyAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartMedicalTranscriptionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String medicalTranscriptionJobName;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaFormat;
        private Media media;
        private String outputBucketName;
        private String outputKey;
        private String outputEncryptionKMSKeyId;
        private MedicalTranscriptionSetting settings;
        private String contentIdentificationType;
        private String specialty;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalTranscriptionJobRequest model) {
            super(model);
            this.medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaFormat(model.mediaFormat);
            this.media(model.media);
            this.outputBucketName(model.outputBucketName);
            this.outputKey(model.outputKey);
            this.outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            this.settings(model.settings);
            this.contentIdentificationType(model.contentIdentificationType);
            this.specialty(model.specialty);
            this.type(model.type);
        }

        public final String getMedicalTranscriptionJobName() {
            return this.medicalTranscriptionJobName;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        @Override
        @Transient
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        @Transient
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaFormat() {
            return this.mediaFormat;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        @Override
        @Transient
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        @Transient
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputBucketName() {
            return this.outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        @Transient
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        @Override
        @Transient
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return this.outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        @Transient
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final MedicalTranscriptionSetting.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(MedicalTranscriptionSetting.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(MedicalTranscriptionSetting settings) {
            this.settings = settings;
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getSpecialty() {
            return this.specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        @Transient
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        @Transient
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalTranscriptionJobRequest build() {
            return new StartMedicalTranscriptionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMedicalTranscriptionJobRequest> {
        public Builder medicalTranscriptionJobName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaFormat(String var1);

        public Builder mediaFormat(MediaFormat var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder outputBucketName(String var1);

        public Builder outputKey(String var1);

        public Builder outputEncryptionKMSKeyId(String var1);

        public Builder settings(MedicalTranscriptionSetting var1);

        default public Builder settings(Consumer<MedicalTranscriptionSetting.Builder> settings) {
            return this.settings((MedicalTranscriptionSetting)((MedicalTranscriptionSetting.Builder)MedicalTranscriptionSetting.builder().applyMutation(settings)).build());
        }

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(MedicalContentIdentificationType var1);

        public Builder specialty(String var1);

        public Builder specialty(Specialty var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

