/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLanguageModelResponse extends TranscribeResponse implements
        ToCopyableBuilder<DescribeLanguageModelResponse.Builder, DescribeLanguageModelResponse> {
    private static final SdkField<LanguageModel> LANGUAGE_MODEL_FIELD = SdkField
            .<LanguageModel> builder(MarshallingType.SDK_POJO).memberName("LanguageModel")
            .getter(getter(DescribeLanguageModelResponse::languageModel)).setter(setter(Builder::languageModel))
            .constructor(LanguageModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_MODEL_FIELD));

    private final LanguageModel languageModel;

    private DescribeLanguageModelResponse(BuilderImpl builder) {
        super(builder);
        this.languageModel = builder.languageModel;
    }

    /**
     * <p>
     * Provides information about the specified custom language model.
     * </p>
     * <p>
     * This parameter also shows if the base language model you used to create your custom language model has been
     * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the
     * updated base model.
     * </p>
     * <p>
     * If you tried to create a new custom language model and the request wasn't successful, you can use this
     * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     * </p>
     * 
     * @return Provides information about the specified custom language model.</p>
     *         <p>
     *         This parameter also shows if the base language model you used to create your custom language model has
     *         been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model
     *         using the updated base model.
     *         </p>
     *         <p>
     *         If you tried to create a new custom language model and the request wasn't successful, you can use this
     *         <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     */
    public final LanguageModel languageModel() {
        return languageModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLanguageModelResponse)) {
            return false;
        }
        DescribeLanguageModelResponse other = (DescribeLanguageModelResponse) obj;
        return Objects.equals(languageModel(), other.languageModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLanguageModelResponse").add("LanguageModel", languageModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageModel":
            return Optional.ofNullable(clazz.cast(languageModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLanguageModelResponse, T> g) {
        return obj -> g.apply((DescribeLanguageModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLanguageModelResponse> {
        /**
         * <p>
         * Provides information about the specified custom language model.
         * </p>
         * <p>
         * This parameter also shows if the base language model you used to create your custom language model has been
         * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using
         * the updated base model.
         * </p>
         * <p>
         * If you tried to create a new custom language model and the request wasn't successful, you can use this
         * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
         * </p>
         * 
         * @param languageModel
         *        Provides information about the specified custom language model.</p>
         *        <p>
         *        This parameter also shows if the base language model you used to create your custom language model has
         *        been updated. If Amazon Transcribe has updated the base model, you can create a new custom language
         *        model using the updated base model.
         *        </p>
         *        <p>
         *        If you tried to create a new custom language model and the request wasn't successful, you can use this
         *        <code>DescribeLanguageModel</code> to help identify the reason for this failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageModel(LanguageModel languageModel);

        /**
         * <p>
         * Provides information about the specified custom language model.
         * </p>
         * <p>
         * This parameter also shows if the base language model you used to create your custom language model has been
         * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using
         * the updated base model.
         * </p>
         * <p>
         * If you tried to create a new custom language model and the request wasn't successful, you can use this
         * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link LanguageModel.Builder} avoiding the need
         * to create one manually via {@link LanguageModel#builder()}.
         *
         * When the {@link Consumer} completes, {@link LanguageModel.Builder#build()} is called immediately and its
         * result is passed to {@link #languageModel(LanguageModel)}.
         * 
         * @param languageModel
         *        a consumer that will call methods on {@link LanguageModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languageModel(LanguageModel)
         */
        default Builder languageModel(Consumer<LanguageModel.Builder> languageModel) {
            return languageModel(LanguageModel.builder().applyMutation(languageModel).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private LanguageModel languageModel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLanguageModelResponse model) {
            super(model);
            languageModel(model.languageModel);
        }

        public final LanguageModel.Builder getLanguageModel() {
            return languageModel != null ? languageModel.toBuilder() : null;
        }

        public final void setLanguageModel(LanguageModel.BuilderImpl languageModel) {
            this.languageModel = languageModel != null ? languageModel.build() : null;
        }

        @Override
        public final Builder languageModel(LanguageModel languageModel) {
            this.languageModel = languageModel;
            return this;
        }

        @Override
        public DescribeLanguageModelResponse build() {
            return new DescribeLanguageModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
