/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMedicalVocabularyResponse extends TranscribeResponse implements
        ToCopyableBuilder<UpdateMedicalVocabularyResponse.Builder, UpdateMedicalVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(UpdateMedicalVocabularyResponse::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(UpdateMedicalVocabularyResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(UpdateMedicalVocabularyResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> VOCABULARY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyState").getter(getter(UpdateMedicalVocabularyResponse::vocabularyStateAsString))
            .setter(setter(Builder::vocabularyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            LANGUAGE_CODE_FIELD, LAST_MODIFIED_TIME_FIELD, VOCABULARY_STATE_FIELD));

    private final String vocabularyName;

    private final String languageCode;

    private final Instant lastModifiedTime;

    private final String vocabularyState;

    private UpdateMedicalVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.vocabularyState = builder.vocabularyState;
    }

    /**
     * <p>
     * The name of the updated vocabulary.
     * </p>
     * 
     * @return The name of the updated vocabulary.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * The language code for the language of the text file used to update the custom vocabulary. US English (en-US) is
     * the only language supported in Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language of the text file used to update the custom vocabulary. US English
     *         (en-US) is the only language supported in Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code for the language of the text file used to update the custom vocabulary. US English (en-US) is
     * the only language supported in Amazon Transcribe Medical.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language of the text file used to update the custom vocabulary. US English
     *         (en-US) is the only language supported in Amazon Transcribe Medical.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The date and time that the vocabulary was updated.
     * </p>
     * 
     * @return The date and time that the vocabulary was updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
     * <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
     *         <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
     *         request.
     * @see VocabularyState
     */
    public final VocabularyState vocabularyState() {
        return VocabularyState.fromValue(vocabularyState);
    }

    /**
     * <p>
     * The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
     * <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vocabularyState}
     * will return {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vocabularyStateAsString}.
     * </p>
     * 
     * @return The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
     *         <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
     *         request.
     * @see VocabularyState
     */
    public final String vocabularyStateAsString() {
        return vocabularyState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMedicalVocabularyResponse)) {
            return false;
        }
        UpdateMedicalVocabularyResponse other = (UpdateMedicalVocabularyResponse) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(vocabularyStateAsString(), other.vocabularyStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMedicalVocabularyResponse").add("VocabularyName", vocabularyName())
                .add("LanguageCode", languageCodeAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("VocabularyState", vocabularyStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "VocabularyState":
            return Optional.ofNullable(clazz.cast(vocabularyStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMedicalVocabularyResponse, T> g) {
        return obj -> g.apply((UpdateMedicalVocabularyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMedicalVocabularyResponse> {
        /**
         * <p>
         * The name of the updated vocabulary.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the updated vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * The language code for the language of the text file used to update the custom vocabulary. US English (en-US)
         * is the only language supported in Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language of the text file used to update the custom vocabulary. US English
         *        (en-US) is the only language supported in Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code for the language of the text file used to update the custom vocabulary. US English (en-US)
         * is the only language supported in Amazon Transcribe Medical.
         * </p>
         * 
         * @param languageCode
         *        The language code for the language of the text file used to update the custom vocabulary. US English
         *        (en-US) is the only language supported in Amazon Transcribe Medical.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The date and time that the vocabulary was updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the vocabulary was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
         * <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
         * request.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
         *        <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
         *        request.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(String vocabularyState);

        /**
         * <p>
         * The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
         * <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
         * request.
         * </p>
         * 
         * @param vocabularyState
         *        The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is
         *        <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code>
         *        request.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder vocabularyState(VocabularyState vocabularyState);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String vocabularyName;

        private String languageCode;

        private Instant lastModifiedTime;

        private String vocabularyState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMedicalVocabularyResponse model) {
            super(model);
            vocabularyName(model.vocabularyName);
            languageCode(model.languageCode);
            lastModifiedTime(model.lastModifiedTime);
            vocabularyState(model.vocabularyState);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getVocabularyState() {
            return vocabularyState;
        }

        public final void setVocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
        }

        @Override
        @Transient
        public final Builder vocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
            return this;
        }

        @Override
        @Transient
        public final Builder vocabularyState(VocabularyState vocabularyState) {
            this.vocabularyState(vocabularyState == null ? null : vocabularyState.toString());
            return this;
        }

        @Override
        public UpdateMedicalVocabularyResponse build() {
            return new UpdateMedicalVocabularyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
