/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.LanguageModel;
import software.amazon.awssdk.services.transcribe.model.ModelsCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLanguageModelsResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListLanguageModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLanguageModelsResponse.getter(ListLanguageModelsResponse::nextToken)).setter(ListLanguageModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<LanguageModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Models").getter(ListLanguageModelsResponse.getter(ListLanguageModelsResponse::models)).setter(ListLanguageModelsResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LanguageModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODELS_FIELD));
    private final String nextToken;
    private final List<LanguageModel> models;

    private ListLanguageModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.models = builder.models;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<LanguageModel> models() {
        return this.models;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguageModelsResponse)) {
            return false;
        }
        ListLanguageModelsResponse other = (ListLanguageModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models());
    }

    public final String toString() {
        return ToString.builder((String)"ListLanguageModelsResponse").add("NextToken", (Object)this.nextToken()).add("Models", this.hasModels() ? this.models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguageModelsResponse, T> g) {
        return obj -> g.apply((ListLanguageModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LanguageModel> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguageModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.models(model.models);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LanguageModel.Builder> getModels() {
            List<LanguageModel.Builder> result = ModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<LanguageModel.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        @Override
        @Transient
        public final Builder models(Collection<LanguageModel> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder models(LanguageModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder models(Consumer<LanguageModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (LanguageModel)((LanguageModel.Builder)LanguageModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLanguageModelsResponse build() {
            return new ListLanguageModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLanguageModelsResponse> {
        public Builder nextToken(String var1);

        public Builder models(Collection<LanguageModel> var1);

        public Builder models(LanguageModel ... var1);

        public Builder models(Consumer<LanguageModel.Builder> ... var1);
    }
}

