/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to control how your transcription job is processed. Currently, the only <code>JobExecutionSettings</code>
 * modification you can choose is enabling job queueing using the <code>AllowDeferredExecution</code> sub-parameter.
 * </p>
 * <p>
 * If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters:
 * <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSettings.Builder, JobExecutionSettings> {
    private static final SdkField<Boolean> ALLOW_DEFERRED_EXECUTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowDeferredExecution").getter(getter(JobExecutionSettings::allowDeferredExecution))
            .setter(setter(Builder::allowDeferredExecution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowDeferredExecution").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(JobExecutionSettings::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_DEFERRED_EXECUTION_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowDeferredExecution;

    private final String dataAccessRoleArn;

    private JobExecutionSettings(BuilderImpl builder) {
        this.allowDeferredExecution = builder.allowDeferredExecution;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * Allows you to enable job queuing when your concurrent request limit is exceeded. When
     * <code>AllowDeferredExecution</code> is set to <code>true</code>, transcription job requests are placed in a queue
     * until the number of jobs falls below the concurrent request limit. If <code>AllowDeferredExecution</code> is set
     * to <code>false</code> and the number of transcription job requests exceed the concurrent request limit, you get a
     * <code>LimitExceededException</code> error.
     * </p>
     * <p>
     * Note that job queuing is enabled by default for Call Analytics jobs.
     * </p>
     * <p>
     * If you include <code>AllowDeferredExecution</code> in your request, you must also include
     * <code>DataAccessRoleArn</code>.
     * </p>
     * 
     * @return Allows you to enable job queuing when your concurrent request limit is exceeded. When
     *         <code>AllowDeferredExecution</code> is set to <code>true</code>, transcription job requests are placed in
     *         a queue until the number of jobs falls below the concurrent request limit. If
     *         <code>AllowDeferredExecution</code> is set to <code>false</code> and the number of transcription job
     *         requests exceed the concurrent request limit, you get a <code>LimitExceededException</code> error.</p>
     *         <p>
     *         Note that job queuing is enabled by default for Call Analytics jobs.
     *         </p>
     *         <p>
     *         If you include <code>AllowDeferredExecution</code> in your request, you must also include
     *         <code>DataAccessRoleArn</code>.
     */
    public final Boolean allowDeferredExecution() {
        return allowDeferredExecution;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files. If the role you specify doesn’t have the appropriate permissions to access the specified Amazon
     * S3 location, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * <p>
     * Note that if you include <code>DataAccessRoleArn</code> in your request, you must also include
     * <code>AllowDeferredExecution</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files. If the role you specify doesn’t have the appropriate permissions to access the
     *         specified Amazon S3 location, your request fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     *         </p>
     *         <p>
     *         Note that if you include <code>DataAccessRoleArn</code> in your request, you must also include
     *         <code>AllowDeferredExecution</code>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowDeferredExecution());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSettings)) {
            return false;
        }
        JobExecutionSettings other = (JobExecutionSettings) obj;
        return Objects.equals(allowDeferredExecution(), other.allowDeferredExecution())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobExecutionSettings").add("AllowDeferredExecution", allowDeferredExecution())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowDeferredExecution":
            return Optional.ofNullable(clazz.cast(allowDeferredExecution()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSettings, T> g) {
        return obj -> g.apply((JobExecutionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSettings> {
        /**
         * <p>
         * Allows you to enable job queuing when your concurrent request limit is exceeded. When
         * <code>AllowDeferredExecution</code> is set to <code>true</code>, transcription job requests are placed in a
         * queue until the number of jobs falls below the concurrent request limit. If
         * <code>AllowDeferredExecution</code> is set to <code>false</code> and the number of transcription job requests
         * exceed the concurrent request limit, you get a <code>LimitExceededException</code> error.
         * </p>
         * <p>
         * Note that job queuing is enabled by default for Call Analytics jobs.
         * </p>
         * <p>
         * If you include <code>AllowDeferredExecution</code> in your request, you must also include
         * <code>DataAccessRoleArn</code>.
         * </p>
         * 
         * @param allowDeferredExecution
         *        Allows you to enable job queuing when your concurrent request limit is exceeded. When
         *        <code>AllowDeferredExecution</code> is set to <code>true</code>, transcription job requests are placed
         *        in a queue until the number of jobs falls below the concurrent request limit. If
         *        <code>AllowDeferredExecution</code> is set to <code>false</code> and the number of transcription job
         *        requests exceed the concurrent request limit, you get a <code>LimitExceededException</code> error.</p>
         *        <p>
         *        Note that job queuing is enabled by default for Call Analytics jobs.
         *        </p>
         *        <p>
         *        If you include <code>AllowDeferredExecution</code> in your request, you must also include
         *        <code>DataAccessRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowDeferredExecution(Boolean allowDeferredExecution);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files. If the role you specify doesn’t have the appropriate permissions to access the
         * specified Amazon S3 location, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * <p>
         * Note that if you include <code>DataAccessRoleArn</code> in your request, you must also include
         * <code>AllowDeferredExecution</code>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files. If the role you specify doesn’t have the appropriate permissions to access
         *        the specified Amazon S3 location, your request fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         *        </p>
         *        <p>
         *        Note that if you include <code>DataAccessRoleArn</code> in your request, you must also include
         *        <code>AllowDeferredExecution</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowDeferredExecution;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSettings model) {
            allowDeferredExecution(model.allowDeferredExecution);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final Boolean getAllowDeferredExecution() {
            return allowDeferredExecution;
        }

        public final void setAllowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
        }

        @Override
        public final Builder allowDeferredExecution(Boolean allowDeferredExecution) {
            this.allowDeferredExecution = allowDeferredExecution;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public JobExecutionSettings build() {
            return new JobExecutionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
