/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCallAnalyticsJobsResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListCallAnalyticsJobsResponse.Builder, ListCallAnalyticsJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListCallAnalyticsJobsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCallAnalyticsJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CallAnalyticsJobSummary>> CALL_ANALYTICS_JOB_SUMMARIES_FIELD = SdkField
            .<List<CallAnalyticsJobSummary>> builder(MarshallingType.LIST)
            .memberName("CallAnalyticsJobSummaries")
            .getter(getter(ListCallAnalyticsJobsResponse::callAnalyticsJobSummaries))
            .setter(setter(Builder::callAnalyticsJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CallAnalyticsJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CallAnalyticsJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NEXT_TOKEN_FIELD, CALL_ANALYTICS_JOB_SUMMARIES_FIELD));

    private final String status;

    private final String nextToken;

    private final List<CallAnalyticsJobSummary> callAnalyticsJobSummaries;

    private ListCallAnalyticsJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.callAnalyticsJobSummaries = builder.callAnalyticsJobSummaries;
    }

    /**
     * <p>
     * When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date, with the
     * most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all transcription jobs
     * ordered by creation date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CallAnalyticsJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date,
     *         with the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
     *         transcription jobs ordered by creation date.
     * @see CallAnalyticsJobStatus
     */
    public final CallAnalyticsJobStatus status() {
        return CallAnalyticsJobStatus.fromValue(status);
    }

    /**
     * <p>
     * When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date, with the
     * most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all transcription jobs
     * ordered by creation date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CallAnalyticsJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date,
     *         with the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
     *         transcription jobs ordered by creation date.
     * @see CallAnalyticsJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The operation returns a page of jobs at a time. The maximum size of the page is set by the
     * <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe
     * returns the <code>NextPage</code> token. Include the token in your next request to the operation to return next
     * page of jobs.
     * </p>
     * 
     * @return The operation returns a page of jobs at a time. The maximum size of the page is set by the
     *         <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon
     *         Transcribe returns the <code>NextPage</code> token. Include the token in your next request to the
     *         operation to return next page of jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallAnalyticsJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCallAnalyticsJobSummaries() {
        return callAnalyticsJobSummaries != null && !(callAnalyticsJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing summary information for a transcription job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallAnalyticsJobSummaries} method.
     * </p>
     * 
     * @return A list of objects containing summary information for a transcription job.
     */
    public final List<CallAnalyticsJobSummary> callAnalyticsJobSummaries() {
        return callAnalyticsJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallAnalyticsJobSummaries() ? callAnalyticsJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallAnalyticsJobsResponse)) {
            return false;
        }
        ListCallAnalyticsJobsResponse other = (ListCallAnalyticsJobsResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && hasCallAnalyticsJobSummaries() == other.hasCallAnalyticsJobSummaries()
                && Objects.equals(callAnalyticsJobSummaries(), other.callAnalyticsJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCallAnalyticsJobsResponse").add("Status", statusAsString()).add("NextToken", nextToken())
                .add("CallAnalyticsJobSummaries", hasCallAnalyticsJobSummaries() ? callAnalyticsJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CallAnalyticsJobSummaries":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCallAnalyticsJobsResponse, T> g) {
        return obj -> g.apply((ListCallAnalyticsJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCallAnalyticsJobsResponse> {
        /**
         * <p>
         * When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date, with
         * the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
         * transcription jobs ordered by creation date.
         * </p>
         * 
         * @param status
         *        When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date,
         *        with the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
         *        transcription jobs ordered by creation date.
         * @see CallAnalyticsJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date, with
         * the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
         * transcription jobs ordered by creation date.
         * </p>
         * 
         * @param status
         *        When specified, returns only call analytics jobs with that status. Jobs are ordered by creation date,
         *        with the most recent jobs returned first. If you don't specify a status, Amazon Transcribe returns all
         *        transcription jobs ordered by creation date.
         * @see CallAnalyticsJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsJobStatus
         */
        Builder status(CallAnalyticsJobStatus status);

        /**
         * <p>
         * The operation returns a page of jobs at a time. The maximum size of the page is set by the
         * <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe
         * returns the <code>NextPage</code> token. Include the token in your next request to the operation to return
         * next page of jobs.
         * </p>
         * 
         * @param nextToken
         *        The operation returns a page of jobs at a time. The maximum size of the page is set by the
         *        <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon
         *        Transcribe returns the <code>NextPage</code> token. Include the token in your next request to the
         *        operation to return next page of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * 
         * @param callAnalyticsJobSummaries
         *        A list of objects containing summary information for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary> callAnalyticsJobSummaries);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * 
         * @param callAnalyticsJobSummaries
         *        A list of objects containing summary information for a transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobSummaries(CallAnalyticsJobSummary... callAnalyticsJobSummaries);

        /**
         * <p>
         * A list of objects containing summary information for a transcription job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CallAnalyticsJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<CallAnalyticsJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CallAnalyticsJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #callAnalyticsJobSummaries(List<CallAnalyticsJobSummary>)}.
         * 
         * @param callAnalyticsJobSummaries
         *        a consumer that will call methods on {@link List<CallAnalyticsJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callAnalyticsJobSummaries(List<CallAnalyticsJobSummary>)
         */
        Builder callAnalyticsJobSummaries(Consumer<CallAnalyticsJobSummary.Builder>... callAnalyticsJobSummaries);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String status;

        private String nextToken;

        private List<CallAnalyticsJobSummary> callAnalyticsJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallAnalyticsJobsResponse model) {
            super(model);
            status(model.status);
            nextToken(model.nextToken);
            callAnalyticsJobSummaries(model.callAnalyticsJobSummaries);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CallAnalyticsJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CallAnalyticsJobSummary.Builder> getCallAnalyticsJobSummaries() {
            List<CallAnalyticsJobSummary.Builder> result = CallAnalyticsJobSummariesCopier
                    .copyToBuilder(this.callAnalyticsJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary.BuilderImpl> callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries = CallAnalyticsJobSummariesCopier.copyFromBuilder(callAnalyticsJobSummaries);
        }

        @Override
        @Transient
        public final Builder callAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary> callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries = CallAnalyticsJobSummariesCopier.copy(callAnalyticsJobSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder callAnalyticsJobSummaries(CallAnalyticsJobSummary... callAnalyticsJobSummaries) {
            callAnalyticsJobSummaries(Arrays.asList(callAnalyticsJobSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder callAnalyticsJobSummaries(Consumer<CallAnalyticsJobSummary.Builder>... callAnalyticsJobSummaries) {
            callAnalyticsJobSummaries(Stream.of(callAnalyticsJobSummaries)
                    .map(c -> CallAnalyticsJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCallAnalyticsJobsResponse build() {
            return new ListCallAnalyticsJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
