/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCallAnalyticsCategoryRequest extends TranscribeRequest implements
        ToCopyableBuilder<DeleteCallAnalyticsCategoryRequest.Builder, DeleteCallAnalyticsCategoryRequest> {
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryName").getter(getter(DeleteCallAnalyticsCategoryRequest::categoryName))
            .setter(setter(Builder::categoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_NAME_FIELD));

    private final String categoryName;

    private DeleteCallAnalyticsCategoryRequest(BuilderImpl builder) {
        super(builder);
        this.categoryName = builder.categoryName;
    }

    /**
     * <p>
     * The name of the call analytics category that you're choosing to delete. The value is case sensitive.
     * </p>
     * 
     * @return The name of the call analytics category that you're choosing to delete. The value is case sensitive.
     */
    public final String categoryName() {
        return categoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCallAnalyticsCategoryRequest)) {
            return false;
        }
        DeleteCallAnalyticsCategoryRequest other = (DeleteCallAnalyticsCategoryRequest) obj;
        return Objects.equals(categoryName(), other.categoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCallAnalyticsCategoryRequest").add("CategoryName", categoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryName":
            return Optional.ofNullable(clazz.cast(categoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCallAnalyticsCategoryRequest, T> g) {
        return obj -> g.apply((DeleteCallAnalyticsCategoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCallAnalyticsCategoryRequest> {
        /**
         * <p>
         * The name of the call analytics category that you're choosing to delete. The value is case sensitive.
         * </p>
         * 
         * @param categoryName
         *        The name of the call analytics category that you're choosing to delete. The value is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryName(String categoryName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String categoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCallAnalyticsCategoryRequest model) {
            super(model);
            categoryName(model.categoryName);
        }

        public final String getCategoryName() {
            return categoryName;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        @Transient
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCallAnalyticsCategoryRequest build() {
            return new DeleteCallAnalyticsCategoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
