/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCallAnalyticsJobResponse extends TranscribeResponse implements
        ToCopyableBuilder<GetCallAnalyticsJobResponse.Builder, GetCallAnalyticsJobResponse> {
    private static final SdkField<CallAnalyticsJob> CALL_ANALYTICS_JOB_FIELD = SdkField
            .<CallAnalyticsJob> builder(MarshallingType.SDK_POJO).memberName("CallAnalyticsJob")
            .getter(getter(GetCallAnalyticsJobResponse::callAnalyticsJob)).setter(setter(Builder::callAnalyticsJob))
            .constructor(CallAnalyticsJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_FIELD));

    private final CallAnalyticsJob callAnalyticsJob;

    private GetCallAnalyticsJobResponse(BuilderImpl builder) {
        super(builder);
        this.callAnalyticsJob = builder.callAnalyticsJob;
    }

    /**
     * <p>
     * An object that contains the results of your call analytics job.
     * </p>
     * 
     * @return An object that contains the results of your call analytics job.
     */
    public final CallAnalyticsJob callAnalyticsJob() {
        return callAnalyticsJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCallAnalyticsJobResponse)) {
            return false;
        }
        GetCallAnalyticsJobResponse other = (GetCallAnalyticsJobResponse) obj;
        return Objects.equals(callAnalyticsJob(), other.callAnalyticsJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCallAnalyticsJobResponse").add("CallAnalyticsJob", callAnalyticsJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallAnalyticsJob":
            return Optional.ofNullable(clazz.cast(callAnalyticsJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCallAnalyticsJobResponse, T> g) {
        return obj -> g.apply((GetCallAnalyticsJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCallAnalyticsJobResponse> {
        /**
         * <p>
         * An object that contains the results of your call analytics job.
         * </p>
         * 
         * @param callAnalyticsJob
         *        An object that contains the results of your call analytics job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJob(CallAnalyticsJob callAnalyticsJob);

        /**
         * <p>
         * An object that contains the results of your call analytics job.
         * </p>
         * This is a convenience that creates an instance of the {@link CallAnalyticsJob.Builder} avoiding the need to
         * create one manually via {@link CallAnalyticsJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link CallAnalyticsJob.Builder#build()} is called immediately and its
         * result is passed to {@link #callAnalyticsJob(CallAnalyticsJob)}.
         * 
         * @param callAnalyticsJob
         *        a consumer that will call methods on {@link CallAnalyticsJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callAnalyticsJob(CallAnalyticsJob)
         */
        default Builder callAnalyticsJob(Consumer<CallAnalyticsJob.Builder> callAnalyticsJob) {
            return callAnalyticsJob(CallAnalyticsJob.builder().applyMutation(callAnalyticsJob).build());
        }
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private CallAnalyticsJob callAnalyticsJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCallAnalyticsJobResponse model) {
            super(model);
            callAnalyticsJob(model.callAnalyticsJob);
        }

        public final CallAnalyticsJob.Builder getCallAnalyticsJob() {
            return callAnalyticsJob != null ? callAnalyticsJob.toBuilder() : null;
        }

        public final void setCallAnalyticsJob(CallAnalyticsJob.BuilderImpl callAnalyticsJob) {
            this.callAnalyticsJob = callAnalyticsJob != null ? callAnalyticsJob.build() : null;
        }

        @Override
        @Transient
        public final Builder callAnalyticsJob(CallAnalyticsJob callAnalyticsJob) {
            this.callAnalyticsJob = callAnalyticsJob;
            return this;
        }

        @Override
        public GetCallAnalyticsJobResponse build() {
            return new GetCallAnalyticsJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
