/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.TagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.TagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.UntagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.UntagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher;

/**
 * Service client for accessing Amazon Transcribe Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Operations and objects for transcribing speech to text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TranscribeAsyncClient extends SdkClient {
    String SERVICE_NAME = "transcribe";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "transcribe";

    /**
     * Create a {@link TranscribeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranscribeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranscribeAsyncClient}.
     */
    static TranscribeAsyncClientBuilder builder() {
        return new DefaultTranscribeAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an analytics category. Amazon Transcribe applies the conditions specified by your analytics categories to
     * your call analytics jobs. For each analytics category, you specify one or more rules. For example, you can
     * specify a rule that the customer sentiment was neutral or negative within that category. If you start a call
     * analytics job, Amazon Transcribe applies the category to the analytics job that you've specified.
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the CreateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCallAnalyticsCategoryResponse> createCallAnalyticsCategory(
            CreateCallAnalyticsCategoryRequest createCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an analytics category. Amazon Transcribe applies the conditions specified by your analytics categories to
     * your call analytics jobs. For each analytics category, you specify one or more rules. For example, you can
     * specify a rule that the customer sentiment was neutral or negative within that category. If you start a call
     * analytics job, Amazon Transcribe applies the category to the analytics job that you've specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCallAnalyticsCategoryResponse> createCallAnalyticsCategory(
            Consumer<CreateCallAnalyticsCategoryRequest.Builder> createCallAnalyticsCategoryRequest) {
        return createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest.builder()
                .applyMutation(createCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Creates a new custom language model. Use Amazon S3 prefixes to provide the location of your input files. The time
     * it takes to create your model depends on the size of your training data.
     * </p>
     *
     * @param createLanguageModelRequest
     * @return A Java Future containing the result of the CreateLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLanguageModelResponse> createLanguageModel(
            CreateLanguageModelRequest createLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom language model. Use Amazon S3 prefixes to provide the location of your input files. The time
     * it takes to create your model depends on the size of your training data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLanguageModelRequest#builder()}
     * </p>
     *
     * @param createLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLanguageModelResponse> createLanguageModel(
            Consumer<CreateLanguageModelRequest.Builder> createLanguageModelRequest) {
        return createLanguageModel(CreateLanguageModelRequest.builder().applyMutation(createLanguageModelRequest).build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary that you can use to modify how Amazon Transcribe Medical transcribes your audio
     * file.
     * </p>
     *
     * @param createMedicalVocabularyRequest
     * @return A Java Future containing the result of the CreateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMedicalVocabularyResponse> createMedicalVocabulary(
            CreateMedicalVocabularyRequest createMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary that you can use to modify how Amazon Transcribe Medical transcribes your audio
     * file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param createMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMedicalVocabularyResponse> createMedicalVocabulary(
            Consumer<CreateMedicalVocabularyRequest.Builder> createMedicalVocabularyRequest) {
        return createMedicalVocabulary(CreateMedicalVocabularyRequest.builder().applyMutation(createMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an
     * audio file.
     * </p>
     *
     * @param createVocabularyRequest
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(CreateVocabularyRequest createVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an
     * audio file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(
            Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest) {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a
     * transcription job.
     * </p>
     *
     * @param createVocabularyFilterRequest
     * @return A Java Future containing the result of the CreateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyFilterResponse> createVocabularyFilter(
            CreateVocabularyFilterRequest createVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a
     * transcription job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param createVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyFilterResponse> createVocabularyFilter(
            Consumer<CreateVocabularyFilterRequest.Builder> createVocabularyFilterRequest) {
        return createVocabularyFilter(CreateVocabularyFilterRequest.builder().applyMutation(createVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a call analytics category using its name.
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the DeleteCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsCategoryResponse> deleteCallAnalyticsCategory(
            DeleteCallAnalyticsCategoryRequest deleteCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a call analytics category using its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsCategoryResponse> deleteCallAnalyticsCategory(
            Consumer<DeleteCallAnalyticsCategoryRequest.Builder> deleteCallAnalyticsCategoryRequest) {
        return deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest.builder()
                .applyMutation(deleteCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Deletes a call analytics job using its name.
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     * @return A Java Future containing the result of the DeleteCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsJobResponse> deleteCallAnalyticsJob(
            DeleteCallAnalyticsJobRequest deleteCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a call analytics job using its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsJobResponse> deleteCallAnalyticsJob(
            Consumer<DeleteCallAnalyticsJobRequest.Builder> deleteCallAnalyticsJobRequest) {
        return deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest.builder().applyMutation(deleteCallAnalyticsJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom language model using its name.
     * </p>
     *
     * @param deleteLanguageModelRequest
     * @return A Java Future containing the result of the DeleteLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLanguageModelResponse> deleteLanguageModel(
            DeleteLanguageModelRequest deleteLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom language model using its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLanguageModelRequest#builder()}
     * </p>
     *
     * @param deleteLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLanguageModelResponse> deleteLanguageModel(
            Consumer<DeleteLanguageModelRequest.Builder> deleteLanguageModelRequest) {
        return deleteLanguageModel(DeleteLanguageModelRequest.builder().applyMutation(deleteLanguageModelRequest).build());
    }

    /**
     * <p>
     * Deletes a transcription job generated by Amazon Transcribe Medical and any related information.
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the DeleteMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalTranscriptionJobResponse> deleteMedicalTranscriptionJob(
            DeleteMedicalTranscriptionJobRequest deleteMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transcription job generated by Amazon Transcribe Medical and any related information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalTranscriptionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalTranscriptionJobResponse> deleteMedicalTranscriptionJob(
            Consumer<DeleteMedicalTranscriptionJobRequest.Builder> deleteMedicalTranscriptionJobRequest) {
        return deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest.builder()
                .applyMutation(deleteMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Deletes a vocabulary from Amazon Transcribe Medical.
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     * @return A Java Future containing the result of the DeleteMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalVocabularyResponse> deleteMedicalVocabulary(
            DeleteMedicalVocabularyRequest deleteMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vocabulary from Amazon Transcribe Medical.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalVocabularyResponse> deleteMedicalVocabulary(
            Consumer<DeleteMedicalVocabularyRequest.Builder> deleteMedicalVocabularyRequest) {
        return deleteMedicalVocabulary(DeleteMedicalVocabularyRequest.builder().applyMutation(deleteMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a previously submitted transcription job along with any other generated results such as the
     * transcription, models, and so on.
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     * @return A Java Future containing the result of the DeleteTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTranscriptionJobResponse> deleteTranscriptionJob(
            DeleteTranscriptionJobRequest deleteTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously submitted transcription job along with any other generated results such as the
     * transcription, models, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTranscriptionJobResponse> deleteTranscriptionJob(
            Consumer<DeleteTranscriptionJobRequest.Builder> deleteTranscriptionJobRequest) {
        return deleteTranscriptionJob(DeleteTranscriptionJobRequest.builder().applyMutation(deleteTranscriptionJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a vocabulary from Amazon Transcribe.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vocabulary from Amazon Transcribe.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(
            Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest) {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * Removes a vocabulary filter.
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     * @return A Java Future containing the result of the DeleteVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyFilterResponse> deleteVocabularyFilter(
            DeleteVocabularyFilterRequest deleteVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a vocabulary filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyFilterResponse> deleteVocabularyFilter(
            Consumer<DeleteVocabularyFilterRequest.Builder> deleteVocabularyFilterRequest) {
        return deleteVocabularyFilter(DeleteVocabularyFilterRequest.builder().applyMutation(deleteVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a single custom language model. Use this information to see details about the language
     * model in your Amazon Web Services account. You can also see whether the base language model used to create your
     * custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new
     * custom language model using the updated base model. If the language model wasn't created, you can use this
     * operation to understand why Amazon Transcribe couldn't create it.
     * </p>
     *
     * @param describeLanguageModelRequest
     * @return A Java Future containing the result of the DescribeLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLanguageModelResponse> describeLanguageModel(
            DescribeLanguageModelRequest describeLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a single custom language model. Use this information to see details about the language
     * model in your Amazon Web Services account. You can also see whether the base language model used to create your
     * custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new
     * custom language model using the updated base model. If the language model wasn't created, you can use this
     * operation to understand why Amazon Transcribe couldn't create it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLanguageModelRequest#builder()}
     * </p>
     *
     * @param describeLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLanguageModelResponse> describeLanguageModel(
            Consumer<DescribeLanguageModelRequest.Builder> describeLanguageModelRequest) {
        return describeLanguageModel(DescribeLanguageModelRequest.builder().applyMutation(describeLanguageModelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a call analytics category.
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the GetCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsCategoryResponse> getCallAnalyticsCategory(
            GetCallAnalyticsCategoryRequest getCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a call analytics category.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsCategoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsCategoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsCategoryResponse> getCallAnalyticsCategory(
            Consumer<GetCallAnalyticsCategoryRequest.Builder> getCallAnalyticsCategoryRequest) {
        return getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest.builder().applyMutation(getCallAnalyticsCategoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a call analytics job. To see the status of the job, check the
     * <code>CallAnalyticsJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you
     * can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable
     * personally identifiable information (PII) redaction, the redacted transcript appears in the
     * <code>RedactedTranscriptFileUri</code> field.
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     * @return A Java Future containing the result of the GetCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsJobResponse> getCallAnalyticsJob(
            GetCallAnalyticsJobRequest getCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a call analytics job. To see the status of the job, check the
     * <code>CallAnalyticsJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you
     * can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable
     * personally identifiable information (PII) redaction, the redacted transcript appears in the
     * <code>RedactedTranscriptFileUri</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsJobResponse> getCallAnalyticsJob(
            Consumer<GetCallAnalyticsJobRequest.Builder> getCallAnalyticsJobRequest) {
        return getCallAnalyticsJob(GetCallAnalyticsJobRequest.builder().applyMutation(getCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a transcription job from Amazon Transcribe Medical. To see the status of the job, check
     * the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You
     * find the results of the completed job in the <code>TranscriptFileUri</code> field.
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the GetMedicalTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalTranscriptionJobResponse> getMedicalTranscriptionJob(
            GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transcription job from Amazon Transcribe Medical. To see the status of the job, check
     * the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You
     * find the results of the completed job in the <code>TranscriptFileUri</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalTranscriptionJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMedicalTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalTranscriptionJobResponse> getMedicalTranscriptionJob(
            Consumer<GetMedicalTranscriptionJobRequest.Builder> getMedicalTranscriptionJobRequest) {
        return getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest.builder()
                .applyMutation(getMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a medical vocabulary.
     * </p>
     *
     * @param getMedicalVocabularyRequest
     * @return A Java Future containing the result of the GetMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalVocabularyResponse> getMedicalVocabulary(
            GetMedicalVocabularyRequest getMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a medical vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link GetMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param getMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalVocabularyResponse> getMedicalVocabulary(
            Consumer<GetMedicalVocabularyRequest.Builder> getMedicalVocabularyRequest) {
        return getMedicalVocabulary(GetMedicalVocabularyRequest.builder().applyMutation(getMedicalVocabularyRequest).build());
    }

    /**
     * <p>
     * Returns information about a transcription job. To see the status of the job, check the
     * <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you
     * can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable content
     * redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>.
     * </p>
     *
     * @param getTranscriptionJobRequest
     * @return A Java Future containing the result of the GetTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTranscriptionJobResponse> getTranscriptionJob(
            GetTranscriptionJobRequest getTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transcription job. To see the status of the job, check the
     * <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you
     * can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable content
     * redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTranscriptionJobResponse> getTranscriptionJob(
            Consumer<GetTranscriptionJobRequest.Builder> getTranscriptionJobRequest) {
        return getTranscriptionJob(GetTranscriptionJobRequest.builder().applyMutation(getTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a vocabulary.
     * </p>
     *
     * @param getVocabularyRequest
     * @return A Java Future containing the result of the GetVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVocabularyResponse> getVocabulary(GetVocabularyRequest getVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyRequest.Builder} avoiding the need to
     * create one manually via {@link GetVocabularyRequest#builder()}
     * </p>
     *
     * @param getVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVocabularyResponse> getVocabulary(Consumer<GetVocabularyRequest.Builder> getVocabularyRequest) {
        return getVocabulary(GetVocabularyRequest.builder().applyMutation(getVocabularyRequest).build());
    }

    /**
     * <p>
     * Returns information about a vocabulary filter.
     * </p>
     *
     * @param getVocabularyFilterRequest
     * @return A Java Future containing the result of the GetVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVocabularyFilterResponse> getVocabularyFilter(
            GetVocabularyFilterRequest getVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a vocabulary filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link GetVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param getVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVocabularyFilterResponse> getVocabularyFilter(
            Consumer<GetVocabularyFilterRequest.Builder> getVocabularyFilterRequest) {
        return getVocabularyFilter(GetVocabularyFilterRequest.builder().applyMutation(getVocabularyFilterRequest).build());
    }

    /**
     * <p>
     * Provides more information about the call analytics categories that you've created. You can use the information in
     * this list to find a specific category. You can then use the operation to get more information about it.
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return A Java Future containing the result of the ListCallAnalyticsCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsCategoriesResponse> listCallAnalyticsCategories(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information about the call analytics categories that you've created. You can use the information in
     * this list to find a specific category. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCallAnalyticsCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsCategoriesResponse> listCallAnalyticsCategories(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) {
        return listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * Provides more information about the call analytics categories that you've created. You can use the information in
     * this list to find a specific category. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesPublisher listCallAnalyticsCategoriesPaginator(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information about the call analytics categories that you've created. You can use the information in
     * this list to find a specific category. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesPublisher listCallAnalyticsCategoriesPaginator(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) {
        return listCallAnalyticsCategoriesPaginator(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * List call analytics jobs with a specified status or substring that matches their names.
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return A Java Future containing the result of the ListCallAnalyticsJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsJobsResponse> listCallAnalyticsJobs(
            ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List call analytics jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCallAnalyticsJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsJobsResponse> listCallAnalyticsJobs(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) {
        return listCallAnalyticsJobs(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest).build());
    }

    /**
     * <p>
     * List call analytics jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsPublisher listCallAnalyticsJobsPaginator(
            ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List call analytics jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsPublisher listCallAnalyticsJobsPaginator(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) {
        return listCallAnalyticsJobsPaginator(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest)
                .build());
    }

    /**
     * <p>
     * Provides more information about the custom language models you've created. You can use the information in this
     * list to find a specific custom language model. You can then use the operation to get more information about it.
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return A Java Future containing the result of the ListLanguageModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLanguageModelsResponse> listLanguageModels(ListLanguageModelsRequest listLanguageModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information about the custom language models you've created. You can use the information in this
     * list to find a specific custom language model. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLanguageModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLanguageModelsResponse> listLanguageModels(
            Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest) {
        return listLanguageModels(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Provides more information about the custom language models you've created. You can use the information in this
     * list to find a specific custom language model. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsPublisher listLanguageModelsPaginator(ListLanguageModelsRequest listLanguageModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information about the custom language models you've created. You can use the information in this
     * list to find a specific custom language model. You can then use the operation to get more information about it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsPublisher listLanguageModelsPaginator(
            Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest) {
        return listLanguageModelsPaginator(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Lists medical transcription jobs with a specified status or substring that matches their names.
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return A Java Future containing the result of the ListMedicalTranscriptionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalTranscriptionJobsResponse> listMedicalTranscriptionJobs(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists medical transcription jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMedicalTranscriptionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalTranscriptionJobsResponse> listMedicalTranscriptionJobs(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest) {
        return listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Lists medical transcription jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsPublisher listMedicalTranscriptionJobsPaginator(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists medical transcription jobs with a specified status or substring that matches their names.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsPublisher listMedicalTranscriptionJobsPaginator(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest) {
        return listMedicalTranscriptionJobsPaginator(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If you don't enter a value in any of the
     * request parameters, returns the entire list of vocabularies.
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return A Java Future containing the result of the ListMedicalVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalVocabulariesResponse> listMedicalVocabularies(
            ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If you don't enter a value in any of the
     * request parameters, returns the entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMedicalVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalVocabulariesResponse> listMedicalVocabularies(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) {
        return listMedicalVocabularies(ListMedicalVocabulariesRequest.builder().applyMutation(listMedicalVocabulariesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If you don't enter a value in any of the
     * request parameters, returns the entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesPublisher listMedicalVocabulariesPaginator(
            ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If you don't enter a value in any of the
     * request parameters, returns the entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesPublisher listMedicalVocabulariesPaginator(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) {
        return listMedicalVocabulariesPaginator(ListMedicalVocabulariesRequest.builder()
                .applyMutation(listMedicalVocabulariesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given transcription job, vocabulary, or resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given transcription job, vocabulary, or resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs(
            ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     *
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs() {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator() {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator(
            ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists transcription jobs with the specified status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     *
     * @param listVocabulariesRequest
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies(ListVocabulariesRequest listVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies(
            Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest) {
        return listVocabularies(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     *
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies() {
        return listVocabularies(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator() {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabulariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator(ListVocabulariesRequest listVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the
     * entire list of vocabularies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator(Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest) {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Gets information about vocabulary filters.
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return A Java Future containing the result of the ListVocabularyFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVocabularyFiltersResponse> listVocabularyFilters(
            ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about vocabulary filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVocabularyFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVocabularyFiltersResponse> listVocabularyFilters(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) {
        return listVocabularyFilters(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest).build());
    }

    /**
     * <p>
     * Gets information about vocabulary filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersPublisher listVocabularyFiltersPaginator(
            ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about vocabulary filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersPublisher listVocabularyFiltersPaginator(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) {
        return listVocabularyFiltersPaginator(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous analytics job that not only transcribes the audio recording of a caller and agent, but
     * also returns additional insights. These insights include how quickly or loudly the caller or agent was speaking.
     * To retrieve additional insights with your analytics jobs, create categories. A category is a way to classify
     * analytics jobs based on attributes, such as a customer's sentiment or a particular phrase being used during the
     * call. For more information, see the operation.
     * </p>
     *
     * @param startCallAnalyticsJobRequest
     * @return A Java Future containing the result of the StartCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCallAnalyticsJobResponse> startCallAnalyticsJob(
            StartCallAnalyticsJobRequest startCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous analytics job that not only transcribes the audio recording of a caller and agent, but
     * also returns additional insights. These insights include how quickly or loudly the caller or agent was speaking.
     * To retrieve additional insights with your analytics jobs, create categories. A category is a way to classify
     * analytics jobs based on attributes, such as a customer's sentiment or a particular phrase being used during the
     * call. For more information, see the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param startCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link StartCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCallAnalyticsJobResponse> startCallAnalyticsJob(
            Consumer<StartCallAnalyticsJobRequest.Builder> startCallAnalyticsJobRequest) {
        return startCallAnalyticsJob(StartCallAnalyticsJobRequest.builder().applyMutation(startCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Starts a batch job to transcribe medical speech to text.
     * </p>
     *
     * @param startMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the StartMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMedicalTranscriptionJobResponse> startMedicalTranscriptionJob(
            StartMedicalTranscriptionJobRequest startMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a batch job to transcribe medical speech to text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartMedicalTranscriptionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMedicalTranscriptionJobResponse> startMedicalTranscriptionJob(
            Consumer<StartMedicalTranscriptionJobRequest.Builder> startMedicalTranscriptionJobRequest) {
        return startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest.builder()
                .applyMutation(startMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous job to transcribe speech to text.
     * </p>
     *
     * @param startTranscriptionJobRequest
     * @return A Java Future containing the result of the StartTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTranscriptionJobResponse> startTranscriptionJob(
            StartTranscriptionJobRequest startTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to transcribe speech to text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTranscriptionJobResponse> startTranscriptionJob(
            Consumer<StartTranscriptionJobRequest.Builder> startTranscriptionJobRequest) {
        return startTranscriptionJob(StartTranscriptionJobRequest.builder().applyMutation(startTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Tags a Amazon Transcribe resource with the given list of tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a Amazon Transcribe resource with the given list of tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Transcribe resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes specified tags from a specified Amazon Transcribe resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the call analytics category with new values. The <code>UpdateCallAnalyticsCategory</code> operation
     * overwrites all of the existing information with the values that you provide in the request.
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the UpdateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCallAnalyticsCategoryResponse> updateCallAnalyticsCategory(
            UpdateCallAnalyticsCategoryRequest updateCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the call analytics category with new values. The <code>UpdateCallAnalyticsCategory</code> operation
     * overwrites all of the existing information with the values that you provide in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCallAnalyticsCategoryResponse> updateCallAnalyticsCategory(
            Consumer<UpdateCallAnalyticsCategoryRequest.Builder> updateCallAnalyticsCategoryRequest) {
        return updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest.builder()
                .applyMutation(updateCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Updates a vocabulary with new values that you provide in a different text file from the one you used to create
     * the vocabulary. The <code>UpdateMedicalVocabulary</code> operation overwrites all of the existing information
     * with the values that you provide in the request.
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     * @return A Java Future containing the result of the UpdateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMedicalVocabularyResponse> updateMedicalVocabulary(
            UpdateMedicalVocabularyRequest updateMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vocabulary with new values that you provide in a different text file from the one you used to create
     * the vocabulary. The <code>UpdateMedicalVocabulary</code> operation overwrites all of the existing information
     * with the values that you provide in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMedicalVocabularyResponse> updateMedicalVocabulary(
            Consumer<UpdateMedicalVocabularyRequest.Builder> updateMedicalVocabularyRequest) {
        return updateMedicalVocabulary(UpdateMedicalVocabularyRequest.builder().applyMutation(updateMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing vocabulary with new values. The <code>UpdateVocabulary</code> operation overwrites all of the
     * existing information with the values that you provide in the request.
     * </p>
     *
     * @param updateVocabularyRequest
     * @return A Java Future containing the result of the UpdateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyResponse> updateVocabulary(UpdateVocabularyRequest updateVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing vocabulary with new values. The <code>UpdateVocabulary</code> operation overwrites all of the
     * existing information with the values that you provide in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVocabularyRequest#builder()}
     * </p>
     *
     * @param updateVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>ConflictException There is already a resource with that name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyResponse> updateVocabulary(
            Consumer<UpdateVocabularyRequest.Builder> updateVocabularyRequest) {
        return updateVocabulary(UpdateVocabularyRequest.builder().applyMutation(updateVocabularyRequest).build());
    }

    /**
     * <p>
     * Updates a vocabulary filter with a new list of filtered words.
     * </p>
     *
     * @param updateVocabularyFilterRequest
     * @return A Java Future containing the result of the UpdateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyFilterResponse> updateVocabularyFilter(
            UpdateVocabularyFilterRequest updateVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a vocabulary filter with a new list of filtered words.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param updateVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. For example, if the entity
     *         that you're trying to delete doesn't exist or if it is in a non-terminal state (for example, it's
     *         "in progress"). See the exception <code>Message</code> field for more information.</li>
     *         <li>LimitExceededException Either you have sent too many requests or your input file is too long. Wait
     *         before you resend your request, or use a smaller file and resend the request.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message and try your request
     *         again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check the name and try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyFilterResponse> updateVocabularyFilter(
            Consumer<UpdateVocabularyFilterRequest.Builder> updateVocabularyFilterRequest) {
        return updateVocabularyFilter(UpdateVocabularyFilterRequest.builder().applyMutation(updateVocabularyFilterRequest)
                .build());
    }
}
