/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCallAnalyticsJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartCallAnalyticsJobRequest.Builder, StartCallAnalyticsJobRequest> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallAnalyticsJobName").getter(getter(StartCallAnalyticsJobRequest::callAnalyticsJobName))
            .setter(setter(Builder::callAnalyticsJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build())
            .build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartCallAnalyticsJobRequest::media)).setter(setter(Builder::media)).constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocation").getter(getter(StartCallAnalyticsJobRequest::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartCallAnalyticsJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartCallAnalyticsJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<CallAnalyticsJobSettings> SETTINGS_FIELD = SdkField
            .<CallAnalyticsJobSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartCallAnalyticsJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(CallAnalyticsJobSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<ChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(StartCallAnalyticsJobRequest::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD,
            MEDIA_FIELD, OUTPUT_LOCATION_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SETTINGS_FIELD,
            CHANNEL_DEFINITIONS_FIELD));

    private final String callAnalyticsJobName;

    private final Media media;

    private final String outputLocation;

    private final String outputEncryptionKMSKeyId;

    private final String dataAccessRoleArn;

    private final CallAnalyticsJobSettings settings;

    private final List<ChannelDefinition> channelDefinitions;

    private StartCallAnalyticsJobRequest(BuilderImpl builder) {
        super(builder);
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.media = builder.media;
        this.outputLocation = builder.outputLocation;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
    }

    /**
     * <p>
     * A unique name, chosen by you, for your Call Analytics job.
     * </p>
     * <p>
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If
     * you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code>
     * error.
     * </p>
     * 
     * @return A unique name, chosen by you, for your Call Analytics job.</p>
     *         <p>
     *         This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
     *         account. If you try to create a new job with the same name as an existing job, you get a
     *         <code>ConflictException</code> error.
     */
    public final String callAnalyticsJobName() {
        return callAnalyticsJobName;
    }

    /**
     * <p>
     * Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
     * </p>
     * 
     * @return Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of the
     * following formats to specify the output location:
     * </p>
     * <ol>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET/my-output-folder/
     * </p>
     * </li>
     * <li>
     * <p>
     * s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
     * </p>
     * </li>
     * </ol>
     * <p>
     * Unless you specify a file name (option 3), the name of your output file has a default value that matches the name
     * you specified for your transcription job using the <code>CallAnalyticsJobName</code> parameter.
     * </p>
     * <p>
     * You can specify a KMS key to encrypt your output using the <code>OutputEncryptionKMSKeyId</code> parameter. If
     * you don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption.
     * </p>
     * <p>
     * If you don't specify <code>OutputLocation</code>, your transcript is placed in a service-managed Amazon S3 bucket
     * and you are provided with a URI to access your transcript.
     * </p>
     * 
     * @return The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of
     *         the following formats to specify the output location:</p>
     *         <ol>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET/my-output-folder/
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         Unless you specify a file name (option 3), the name of your output file has a default value that matches
     *         the name you specified for your transcription job using the <code>CallAnalyticsJobName</code> parameter.
     *         </p>
     *         <p>
     *         You can specify a KMS key to encrypt your output using the <code>OutputEncryptionKMSKeyId</code>
     *         parameter. If you don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for
     *         server-side encryption.
     *         </p>
     *         <p>
     *         If you don't specify <code>OutputLocation</code>, your transcript is placed in a service-managed Amazon
     *         S3 bucket and you are provided with a URI to access your transcript.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The KMS key you want to use to encrypt your Call Analytics output.
     * </p>
     * <p>
     * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of
     * four ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
     * account, you can specify your KMS key in one of two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the ARN for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * If you specify a KMS key to encrypt your output, you must also specify an output location using the
     * <code>OutputLocation</code> parameter.
     * </p>
     * <p>
     * Note that the user making the request must have permission to use the specified KMS key.
     * </p>
     * 
     * @return The KMS key you want to use to encrypt your Call Analytics output.</p>
     *         <p>
     *         If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in
     *         one of four ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
     *         Services account, you can specify your KMS key in one of two ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     *         </p>
     *         <p>
     *         If you specify a KMS key to encrypt your output, you must also specify an output location using the
     *         <code>OutputLocation</code> parameter.
     *         </p>
     *         <p>
     *         Note that the user making the request must have permission to use the specified KMS key.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified
     * Amazon S3 location, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files. If the role that you specify doesn’t have the appropriate permissions to
     *         access the specified Amazon S3 location, your request fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Specify additional optional settings in your request, including content redaction; allows you to apply custom
     * language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
     * </p>
     * 
     * @return Specify additional optional settings in your request, including content redaction; allows you to apply
     *         custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
     */
    public final CallAnalyticsJobSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first
     * participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel) and
     * <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent speaking).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return Makes it possible to specify which speaker is on which channel. For example, if your agent is the first
     *         participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first
     *         channel) and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent
     *         speaking).
     */
    public final List<ChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCallAnalyticsJobRequest)) {
            return false;
        }
        StartCallAnalyticsJobRequest other = (StartCallAnalyticsJobRequest) obj;
        return Objects.equals(callAnalyticsJobName(), other.callAnalyticsJobName()) && Objects.equals(media(), other.media())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(settings(), other.settings())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCallAnalyticsJobRequest").add("CallAnalyticsJobName", callAnalyticsJobName())
                .add("Media", media()).add("OutputLocation", outputLocation())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId()).add("DataAccessRoleArn", dataAccessRoleArn())
                .add("Settings", settings()).add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallAnalyticsJobName":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobName()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCallAnalyticsJobRequest, T> g) {
        return obj -> g.apply((StartCallAnalyticsJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCallAnalyticsJobRequest> {
        /**
         * <p>
         * A unique name, chosen by you, for your Call Analytics job.
         * </p>
         * <p>
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * If you try to create a new job with the same name as an existing job, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param callAnalyticsJobName
         *        A unique name, chosen by you, for your Call Analytics job.</p>
         *        <p>
         *        This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account. If you try to create a new job with the same name as an existing job, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobName(String callAnalyticsJobName);

        /**
         * <p>
         * Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
         * </p>
         * 
         * @param media
         *        Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * <p>
         * Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Media.Builder} avoiding the need to
         * create one manually via {@link Media#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of the
         * following formats to specify the output location:
         * </p>
         * <ol>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET/my-output-folder/
         * </p>
         * </li>
         * <li>
         * <p>
         * s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
         * </p>
         * </li>
         * </ol>
         * <p>
         * Unless you specify a file name (option 3), the name of your output file has a default value that matches the
         * name you specified for your transcription job using the <code>CallAnalyticsJobName</code> parameter.
         * </p>
         * <p>
         * You can specify a KMS key to encrypt your output using the <code>OutputEncryptionKMSKeyId</code> parameter.
         * If you don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption.
         * </p>
         * <p>
         * If you don't specify <code>OutputLocation</code>, your transcript is placed in a service-managed Amazon S3
         * bucket and you are provided with a URI to access your transcript.
         * </p>
         * 
         * @param outputLocation
         *        The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any
         *        of the following formats to specify the output location:</p>
         *        <ol>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET/my-output-folder/
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        Unless you specify a file name (option 3), the name of your output file has a default value that
         *        matches the name you specified for your transcription job using the <code>CallAnalyticsJobName</code>
         *        parameter.
         *        </p>
         *        <p>
         *        You can specify a KMS key to encrypt your output using the <code>OutputEncryptionKMSKeyId</code>
         *        parameter. If you don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for
         *        server-side encryption.
         *        </p>
         *        <p>
         *        If you don't specify <code>OutputLocation</code>, your transcript is placed in a service-managed
         *        Amazon S3 bucket and you are provided with a URI to access your transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The KMS key you want to use to encrypt your Call Analytics output.
         * </p>
         * <p>
         * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one
         * of four ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
         * account, you can specify your KMS key in one of two ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the ARN for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * If you specify a KMS key to encrypt your output, you must also specify an output location using the
         * <code>OutputLocation</code> parameter.
         * </p>
         * <p>
         * Note that the user making the request must have permission to use the specified KMS key.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The KMS key you want to use to encrypt your Call Analytics output.</p>
         *        <p>
         *        If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key
         *        in one of four ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
         *        Services account, you can specify your KMS key in one of two ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key
         *        (SSE-S3).
         *        </p>
         *        <p>
         *        If you specify a KMS key to encrypt your output, you must also specify an output location using the
         *        <code>OutputLocation</code> parameter.
         *        </p>
         *        <p>
         *        Note that the user making the request must have permission to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files. If the role that you specify doesn’t have the appropriate permissions to access
         * the specified Amazon S3 location, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files. If the role that you specify doesn’t have the appropriate permissions to
         *        access the specified Amazon S3 location, your request fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Specify additional optional settings in your request, including content redaction; allows you to apply custom
         * language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
         * </p>
         * 
         * @param settings
         *        Specify additional optional settings in your request, including content redaction; allows you to apply
         *        custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(CallAnalyticsJobSettings settings);

        /**
         * <p>
         * Specify additional optional settings in your request, including content redaction; allows you to apply custom
         * language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CallAnalyticsJobSettings.Builder}
         * avoiding the need to create one manually via {@link CallAnalyticsJobSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CallAnalyticsJobSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(CallAnalyticsJobSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link CallAnalyticsJobSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(CallAnalyticsJobSettings)
         */
        default Builder settings(Consumer<CallAnalyticsJobSettings.Builder> settings) {
            return settings(CallAnalyticsJobSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first
         * participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel)
         * and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent speaking).
         * </p>
         * 
         * @param channelDefinitions
         *        Makes it possible to specify which speaker is on which channel. For example, if your agent is the
         *        first participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the
         *        first channel) and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent
         *        speaking).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions);

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first
         * participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel)
         * and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent speaking).
         * </p>
         * 
         * @param channelDefinitions
         *        Makes it possible to specify which speaker is on which channel. For example, if your agent is the
         *        first participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the
         *        first channel) and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent
         *        speaking).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(ChannelDefinition... channelDefinitions);

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first
         * participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel)
         * and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent speaking).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.ChannelDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.transcribe.model.ChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.ChannelDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #channelDefinitions(List<ChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.ChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<ChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String callAnalyticsJobName;

        private Media media;

        private String outputLocation;

        private String outputEncryptionKMSKeyId;

        private String dataAccessRoleArn;

        private CallAnalyticsJobSettings settings;

        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCallAnalyticsJobRequest model) {
            super(model);
            callAnalyticsJobName(model.callAnalyticsJobName);
            media(model.media);
            outputLocation(model.outputLocation);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            dataAccessRoleArn(model.dataAccessRoleArn);
            settings(model.settings);
            channelDefinitions(model.channelDefinitions);
        }

        public final String getCallAnalyticsJobName() {
            return callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final CallAnalyticsJobSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(CallAnalyticsJobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(CallAnalyticsJobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions).map(c -> ChannelDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCallAnalyticsJobRequest build() {
            return new StartCallAnalyticsJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
