/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.TagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.TagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.UntagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.UntagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher;

/**
 * Service client for accessing Amazon Transcribe Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Transcribe offers three main types of batch transcription: <b>Standard</b>, <b>Medical</b>, and <b>Call
 * Analytics</b>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Standard transcriptions</b> are the most common option. Refer to for details.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Medical transcriptions</b> are tailored to medical professionals and incorporate medical terms. A common use case
 * for this service is transcribing doctor-patient dialogue into after-visit notes. Refer to for details.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Call Analytics transcriptions</b> are designed for use with call center audio on two different channels; if you're
 * looking for insight into customer service calls, use this option. Refer to for details.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TranscribeAsyncClient extends SdkClient {
    String SERVICE_NAME = "transcribe";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "transcribe";

    /**
     * <p>
     * Creates a new Call Analytics category.
     * </p>
     * <p>
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply
     * categories to your transcriptions, you must create them before submitting your transcription request, as
     * categories cannot be applied retroactively.
     * </p>
     * <p>
     * When creating a new category, you can use the <code>InputType</code> parameter to label the category as a
     * <code>POST_CALL</code> or a <code>REAL_TIME</code> category. <code>POST_CALL</code> categories can only be
     * applied to post-call transcriptions and <code>REAL_TIME</code> categories can only be applied to real-time
     * transcriptions. If you do not include <code>InputType</code>, your category is created as a
     * <code>POST_CALL</code> category by default.
     * </p>
     * <p>
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules
     * can include these parameters: , , , and .
     * </p>
     * <p>
     * To update an existing category, see .
     * </p>
     * <p>
     * To learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the CreateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCallAnalyticsCategoryResponse> createCallAnalyticsCategory(
            CreateCallAnalyticsCategoryRequest createCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Call Analytics category.
     * </p>
     * <p>
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply
     * categories to your transcriptions, you must create them before submitting your transcription request, as
     * categories cannot be applied retroactively.
     * </p>
     * <p>
     * When creating a new category, you can use the <code>InputType</code> parameter to label the category as a
     * <code>POST_CALL</code> or a <code>REAL_TIME</code> category. <code>POST_CALL</code> categories can only be
     * applied to post-call transcriptions and <code>REAL_TIME</code> categories can only be applied to real-time
     * transcriptions. If you do not include <code>InputType</code>, your category is created as a
     * <code>POST_CALL</code> category by default.
     * </p>
     * <p>
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules
     * can include these parameters: , , , and .
     * </p>
     * <p>
     * To update an existing category, see .
     * </p>
     * <p>
     * To learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCallAnalyticsCategoryResponse> createCallAnalyticsCategory(
            Consumer<CreateCallAnalyticsCategoryRequest.Builder> createCallAnalyticsCategoryRequest) {
        return createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest.builder()
                .applyMutation(createCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Creates a new custom language model.
     * </p>
     * <p>
     * When creating a new custom language model, you must specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz)
     * base model
     * </p>
     * </li>
     * <li>
     * <p>
     * The location of your training and tuning files (this must be an Amazon S3 URI)
     * </p>
     * </li>
     * <li>
     * <p>
     * The language of your model
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique name for your model
     * </p>
     * </li>
     * </ul>
     *
     * @param createLanguageModelRequest
     * @return A Java Future containing the result of the CreateLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLanguageModelResponse> createLanguageModel(
            CreateLanguageModelRequest createLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom language model.
     * </p>
     * <p>
     * When creating a new custom language model, you must specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz)
     * base model
     * </p>
     * </li>
     * <li>
     * <p>
     * The location of your training and tuning files (this must be an Amazon S3 URI)
     * </p>
     * </li>
     * <li>
     * <p>
     * The language of your model
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique name for your model
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLanguageModelRequest#builder()}
     * </p>
     *
     * @param createLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLanguageModelResponse> createLanguageModel(
            Consumer<CreateLanguageModelRequest.Builder> createLanguageModelRequest) {
        return createLanguageModel(CreateLanguageModelRequest.builder().applyMutation(createLanguageModelRequest).build());
    }

    /**
     * <p>
     * Creates a new custom medical vocabulary.
     * </p>
     * <p>
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary
     * table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your
     * request using the <code>Phrases</code> flag; <code>CreateMedicalVocabulary</code> does not support the
     * <code>Phrases</code> flag and only accepts vocabularies in table format.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     *
     * @param createMedicalVocabularyRequest
     * @return A Java Future containing the result of the CreateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMedicalVocabularyResponse> createMedicalVocabulary(
            CreateMedicalVocabularyRequest createMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom medical vocabulary.
     * </p>
     * <p>
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary
     * table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your
     * request using the <code>Phrases</code> flag; <code>CreateMedicalVocabulary</code> does not support the
     * <code>Phrases</code> flag and only accepts vocabularies in table format.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param createMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMedicalVocabularyResponse> createMedicalVocabulary(
            Consumer<CreateMedicalVocabularyRequest.Builder> createMedicalVocabularyRequest) {
        return createMedicalVocabulary(CreateMedicalVocabularyRequest.builder().applyMutation(createMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary.
     * </p>
     * <p>
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases,
     * and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms
     * directly in your request using the <code>Phrases</code> flag.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     *
     * @param createVocabularyRequest
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(CreateVocabularyRequest createVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary.
     * </p>
     * <p>
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases,
     * and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms
     * directly in your request using the <code>Phrases</code> flag.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyResponse> createVocabulary(
            Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest) {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary filter.
     * </p>
     * <p>
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom
     * vocabulary filters are commonly used to mask profanity in transcripts.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary filter request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Vocabulary filtering</a>.
     * </p>
     *
     * @param createVocabularyFilterRequest
     * @return A Java Future containing the result of the CreateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyFilterResponse> createVocabularyFilter(
            CreateVocabularyFilterRequest createVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary filter.
     * </p>
     * <p>
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom
     * vocabulary filters are commonly used to mask profanity in transcripts.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary filter request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Vocabulary filtering</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param createVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVocabularyFilterResponse> createVocabularyFilter(
            Consumer<CreateVocabularyFilterRequest.Builder> createVocabularyFilterRequest) {
        return createVocabularyFilter(CreateVocabularyFilterRequest.builder().applyMutation(createVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete
     * using <code>CategoryName</code>. Category names are case sensitive.
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the DeleteCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsCategoryResponse> deleteCallAnalyticsCategory(
            DeleteCallAnalyticsCategoryRequest deleteCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete
     * using <code>CategoryName</code>. Category names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsCategoryResponse> deleteCallAnalyticsCategory(
            Consumer<DeleteCallAnalyticsCategoryRequest.Builder> deleteCallAnalyticsCategoryRequest) {
        return deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest.builder()
                .applyMutation(deleteCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using
     * <code>CallAnalyticsJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     * @return A Java Future containing the result of the DeleteCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsJobResponse> deleteCallAnalyticsJob(
            DeleteCallAnalyticsJobRequest deleteCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using
     * <code>CallAnalyticsJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCallAnalyticsJobResponse> deleteCallAnalyticsJob(
            Consumer<DeleteCallAnalyticsJobRequest.Builder> deleteCallAnalyticsJobRequest) {
        return deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest.builder().applyMutation(deleteCallAnalyticsJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete
     * using <code>ModelName</code>. custom language model names are case sensitive.
     * </p>
     *
     * @param deleteLanguageModelRequest
     * @return A Java Future containing the result of the DeleteLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLanguageModelResponse> deleteLanguageModel(
            DeleteLanguageModelRequest deleteLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete
     * using <code>ModelName</code>. custom language model names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLanguageModelRequest#builder()}
     * </p>
     *
     * @param deleteLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLanguageModelResponse> deleteLanguageModel(
            Consumer<DeleteLanguageModelRequest.Builder> deleteLanguageModelRequest) {
        return deleteLanguageModel(DeleteLanguageModelRequest.builder().applyMutation(deleteLanguageModelRequest).build());
    }

    /**
     * <p>
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>MedicalTranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the DeleteMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalTranscriptionJobResponse> deleteMedicalTranscriptionJob(
            DeleteMedicalTranscriptionJobRequest deleteMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>MedicalTranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalTranscriptionJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalTranscriptionJobResponse> deleteMedicalTranscriptionJob(
            Consumer<DeleteMedicalTranscriptionJobRequest.Builder> deleteMedicalTranscriptionJobRequest) {
        return deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest.builder()
                .applyMutation(deleteMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to
     * delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     * @return A Java Future containing the result of the DeleteMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalVocabularyResponse> deleteMedicalVocabulary(
            DeleteMedicalVocabularyRequest deleteMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to
     * delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMedicalVocabularyResponse> deleteMedicalVocabulary(
            Consumer<DeleteMedicalVocabularyRequest.Builder> deleteMedicalVocabularyRequest) {
        return deleteMedicalVocabulary(DeleteMedicalVocabularyRequest.builder().applyMutation(deleteMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>TranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     * @return A Java Future containing the result of the DeleteTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTranscriptionJobResponse> deleteTranscriptionJob(
            DeleteTranscriptionJobRequest deleteTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>TranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTranscriptionJobResponse> deleteTranscriptionJob(
            Consumer<DeleteTranscriptionJobRequest.Builder> deleteTranscriptionJobRequest) {
        return deleteTranscriptionJob(DeleteTranscriptionJobRequest.builder().applyMutation(deleteTranscriptionJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete
     * using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete
     * using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyResponse> deleteVocabulary(
            Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest) {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you
     * want to delete using <code>VocabularyFilterName</code>. Custom vocabulary filter names are case sensitive.
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     * @return A Java Future containing the result of the DeleteVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyFilterResponse> deleteVocabularyFilter(
            DeleteVocabularyFilterRequest deleteVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you
     * want to delete using <code>VocabularyFilterName</code>. Custom vocabulary filter names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVocabularyFilterResponse> deleteVocabularyFilter(
            Consumer<DeleteVocabularyFilterRequest.Builder> deleteVocabularyFilterRequest) {
        return deleteVocabularyFilter(DeleteVocabularyFilterRequest.builder().applyMutation(deleteVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the specified custom language model.
     * </p>
     * <p>
     * This operation also shows if the base language model that you used to create your custom language model has been
     * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the
     * updated base model.
     * </p>
     * <p>
     * If you tried to create a new custom language model and the request wasn't successful, you can use
     * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     * </p>
     *
     * @param describeLanguageModelRequest
     * @return A Java Future containing the result of the DescribeLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLanguageModelResponse> describeLanguageModel(
            DescribeLanguageModelRequest describeLanguageModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom language model.
     * </p>
     * <p>
     * This operation also shows if the base language model that you used to create your custom language model has been
     * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the
     * updated base model.
     * </p>
     * <p>
     * If you tried to create a new custom language model and the request wasn't successful, you can use
     * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLanguageModelRequest#builder()}
     * </p>
     *
     * @param describeLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLanguageModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLanguageModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLanguageModelResponse> describeLanguageModel(
            Consumer<DescribeLanguageModelRequest.Builder> describeLanguageModelRequest) {
        return describeLanguageModel(DescribeLanguageModelRequest.builder().applyMutation(describeLanguageModelRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics category.
     * </p>
     * <p>
     * To get a list of your Call Analytics categories, use the operation.
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the GetCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsCategoryResponse> getCallAnalyticsCategory(
            GetCallAnalyticsCategoryRequest getCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics category.
     * </p>
     * <p>
     * To get a list of your Call Analytics categories, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsCategoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsCategoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsCategoryResponse> getCallAnalyticsCategory(
            Consumer<GetCallAnalyticsCategoryRequest.Builder> getCallAnalyticsCategoryRequest) {
        return getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest.builder().applyMutation(getCallAnalyticsCategoryRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics job.
     * </p>
     * <p>
     * To view the job's status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>,
     * the job is finished. You can find your completed transcript at the URI specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the
     * location specified in <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location
     * specified in <code>RedactedMediaFileUri</code>.
     * </p>
     * <p>
     * To get a list of your Call Analytics jobs, use the operation.
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     * @return A Java Future containing the result of the GetCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsJobResponse> getCallAnalyticsJob(
            GetCallAnalyticsJobRequest getCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics job.
     * </p>
     * <p>
     * To view the job's status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>,
     * the job is finished. You can find your completed transcript at the URI specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the
     * location specified in <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location
     * specified in <code>RedactedMediaFileUri</code>.
     * </p>
     * <p>
     * To get a list of your Call Analytics jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCallAnalyticsJobResponse> getCallAnalyticsJob(
            Consumer<GetCallAnalyticsJobRequest.Builder> getCallAnalyticsJobRequest) {
        return getCallAnalyticsJob(GetCallAnalyticsJobRequest.builder().applyMutation(getCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified medical transcription job.
     * </p>
     * <p>
     * To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code>
     * field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * To get a list of your medical transcription jobs, use the operation.
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the GetMedicalTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalTranscriptionJobResponse> getMedicalTranscriptionJob(
            GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified medical transcription job.
     * </p>
     * <p>
     * To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code>
     * field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * To get a list of your medical transcription jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalTranscriptionJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMedicalTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalTranscriptionJobResponse> getMedicalTranscriptionJob(
            Consumer<GetMedicalTranscriptionJobRequest.Builder> getMedicalTranscriptionJobRequest) {
        return getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest.builder()
                .applyMutation(getMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom medical vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom medical vocabulary, check the <code>VocabularyState</code> field. If
     * the status is <code>READY</code>, your custom vocabulary is available to use. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details on why your vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom medical vocabularies, use the operation.
     * </p>
     *
     * @param getMedicalVocabularyRequest
     * @return A Java Future containing the result of the GetMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalVocabularyResponse> getMedicalVocabulary(
            GetMedicalVocabularyRequest getMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom medical vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom medical vocabulary, check the <code>VocabularyState</code> field. If
     * the status is <code>READY</code>, your custom vocabulary is available to use. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details on why your vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom medical vocabularies, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link GetMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param getMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMedicalVocabularyResponse> getMedicalVocabulary(
            Consumer<GetMedicalVocabularyRequest.Builder> getMedicalVocabularyRequest) {
        return getMedicalVocabulary(GetMedicalVocabularyRequest.builder().applyMutation(getMedicalVocabularyRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified transcription job.
     * </p>
     * <p>
     * To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If
     * the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled content redaction, the redacted transcript can be found at the location specified in
     * <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * To get a list of your transcription jobs, use the operation.
     * </p>
     *
     * @param getTranscriptionJobRequest
     * @return A Java Future containing the result of the GetTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTranscriptionJobResponse> getTranscriptionJob(
            GetTranscriptionJobRequest getTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified transcription job.
     * </p>
     * <p>
     * To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If
     * the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled content redaction, the redacted transcript can be found at the location specified in
     * <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * To get a list of your transcription jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTranscriptionJobResponse> getTranscriptionJob(
            Consumer<GetTranscriptionJobRequest.Builder> getTranscriptionJobRequest) {
        return getTranscriptionJob(GetTranscriptionJobRequest.builder().applyMutation(getTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom vocabulary, check the <code>VocabularyState</code> field. If the
     * status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>,
     * <code>FailureReason</code> provides details on why your custom vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom vocabularies, use the operation.
     * </p>
     *
     * @param getVocabularyRequest
     * @return A Java Future containing the result of the GetVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVocabularyResponse> getVocabulary(GetVocabularyRequest getVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom vocabulary, check the <code>VocabularyState</code> field. If the
     * status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>,
     * <code>FailureReason</code> provides details on why your custom vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom vocabularies, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyRequest.Builder} avoiding the need to
     * create one manually via {@link GetVocabularyRequest#builder()}
     * </p>
     *
     * @param getVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVocabularyResponse> getVocabulary(Consumer<GetVocabularyRequest.Builder> getVocabularyRequest) {
        return getVocabulary(GetVocabularyRequest.builder().applyMutation(getVocabularyRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary filter.
     * </p>
     * <p>
     * To get a list of your custom vocabulary filters, use the operation.
     * </p>
     *
     * @param getVocabularyFilterRequest
     * @return A Java Future containing the result of the GetVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVocabularyFilterResponse> getVocabularyFilter(
            GetVocabularyFilterRequest getVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary filter.
     * </p>
     * <p>
     * To get a list of your custom vocabulary filters, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link GetVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param getVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVocabularyFilterResponse> getVocabularyFilter(
            Consumer<GetVocabularyFilterRequest.Builder> getVocabularyFilterRequest) {
        return getVocabularyFilter(GetVocabularyFilterRequest.builder().applyMutation(getVocabularyFilterRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return A Java Future containing the result of the ListCallAnalyticsCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsCategoriesResponse> listCallAnalyticsCategories(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListCallAnalyticsCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsCategoriesResponse> listCallAnalyticsCategories(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) {
        return listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesPublisher listCallAnalyticsCategoriesPaginator(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesPublisher publisher = client.listCallAnalyticsCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesPublisher listCallAnalyticsCategoriesPaginator(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) {
        return listCallAnalyticsCategoriesPaginator(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return A Java Future containing the result of the ListCallAnalyticsJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsJobsResponse> listCallAnalyticsJobs(
            ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCallAnalyticsJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCallAnalyticsJobsResponse> listCallAnalyticsJobs(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) {
        return listCallAnalyticsJobs(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsPublisher listCallAnalyticsJobsPaginator(
            ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsPublisher publisher = client.listCallAnalyticsJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsPublisher listCallAnalyticsJobsPaginator(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) {
        return listCallAnalyticsJobsPaginator(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return A Java Future containing the result of the ListLanguageModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLanguageModelsResponse> listLanguageModels(ListLanguageModelsRequest listLanguageModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListLanguageModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListLanguageModelsResponse> listLanguageModels(
            Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest) {
        return listLanguageModels(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsPublisher listLanguageModelsPaginator(ListLanguageModelsRequest listLanguageModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsPublisher publisher = client.listLanguageModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsPublisher listLanguageModelsPaginator(
            Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest) {
        return listLanguageModelsPaginator(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return A Java Future containing the result of the ListMedicalTranscriptionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalTranscriptionJobsResponse> listMedicalTranscriptionJobs(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListMedicalTranscriptionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalTranscriptionJobsResponse> listMedicalTranscriptionJobs(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest) {
        return listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsPublisher listMedicalTranscriptionJobsPaginator(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsPublisher publisher = client.listMedicalTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsPublisher listMedicalTranscriptionJobsPaginator(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest) {
        return listMedicalTranscriptionJobsPaginator(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return A Java Future containing the result of the ListMedicalVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalVocabulariesResponse> listMedicalVocabularies(
            ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMedicalVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMedicalVocabulariesResponse> listMedicalVocabularies(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) {
        return listMedicalVocabularies(ListMedicalVocabulariesRequest.builder().applyMutation(listMedicalVocabulariesRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesPublisher listMedicalVocabulariesPaginator(
            ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesPublisher publisher = client.listMedicalVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesPublisher listMedicalVocabulariesPaginator(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) {
        return listMedicalVocabulariesPaginator(ListMedicalVocabulariesRequest.builder()
                .applyMutation(listMedicalVocabulariesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs(
            ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     *
     * @return A Java Future containing the result of the ListTranscriptionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTranscriptionJobsResponse> listTranscriptionJobs() {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator() {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator(
            ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsPublisher publisher = client.listTranscriptionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsPublisher listTranscriptionJobsPaginator(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     *
     * @param listVocabulariesRequest
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies(ListVocabulariesRequest listVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies(
            Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest) {
        return listVocabularies(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     *
     * @return A Java Future containing the result of the ListVocabularies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVocabulariesResponse> listVocabularies() {
        return listVocabularies(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator() {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabulariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator(ListVocabulariesRequest listVocabulariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesPublisher publisher = client.listVocabulariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesPublisher listVocabulariesPaginator(Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest) {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return A Java Future containing the result of the ListVocabularyFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVocabularyFiltersResponse> listVocabularyFilters(
            ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVocabularyFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVocabularyFiltersResponse> listVocabularyFilters(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) {
        return listVocabularyFilters(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersPublisher listVocabularyFiltersPaginator(
            ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersPublisher publisher = client.listVocabularyFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersPublisher listVocabularyFiltersPaginator(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) {
        return listVocabularyFiltersPaginator(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest)
                .build());
    }

    /**
     * <p>
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to
     * include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call
     * summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can
     * also apply custom categories to flag specified conditions. To learn more about these features and insights, refer
     * to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio
     * with Call Analytics</a>.
     * </p>
     * <p>
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job
     * request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To
     * learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <p>
     * To make a <code>StartCallAnalyticsJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * Note that job queuing is enabled by default for Call Analytics jobs.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartCallAnalyticsJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CallAnalyticsJobName</code>: A custom name that you create for your transcription job that's unique within
     * your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataAccessRoleArn</code>: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the
     * Amazon S3 bucket that contains your input files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code> or <code>RedactedMediaFileUri</code>): The Amazon S3 location of
     * your media file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * With Call Analytics, you can redact the audio contained in your media file by including
     * <code>RedactedMediaFileUri</code>, instead of <code>MediaFileUri</code>, to specify the location of your input
     * audio. If you choose to redact your audio, you can find your redacted media at the location specified in the
     * <code>RedactedMediaFileUri</code> field of your response.
     * </p>
     * </note>
     *
     * @param startCallAnalyticsJobRequest
     * @return A Java Future containing the result of the StartCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCallAnalyticsJobResponse> startCallAnalyticsJob(
            StartCallAnalyticsJobRequest startCallAnalyticsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to
     * include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call
     * summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can
     * also apply custom categories to flag specified conditions. To learn more about these features and insights, refer
     * to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio
     * with Call Analytics</a>.
     * </p>
     * <p>
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job
     * request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To
     * learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <p>
     * To make a <code>StartCallAnalyticsJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * Note that job queuing is enabled by default for Call Analytics jobs.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartCallAnalyticsJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CallAnalyticsJobName</code>: A custom name that you create for your transcription job that's unique within
     * your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataAccessRoleArn</code>: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the
     * Amazon S3 bucket that contains your input files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code> or <code>RedactedMediaFileUri</code>): The Amazon S3 location of
     * your media file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * With Call Analytics, you can redact the audio contained in your media file by including
     * <code>RedactedMediaFileUri</code>, instead of <code>MediaFileUri</code>, to specify the location of your input
     * audio. If you choose to redact your audio, you can find your redacted media at the location specified in the
     * <code>RedactedMediaFileUri</code> field of your response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param startCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link StartCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCallAnalyticsJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCallAnalyticsJobResponse> startCallAnalyticsJob(
            Consumer<StartCallAnalyticsJobRequest.Builder> startCallAnalyticsJobRequest) {
        return startCallAnalyticsJob(StartCallAnalyticsJobRequest.builder().applyMutation(startCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you
     * choose to include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical
     * vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To
     * learn more about these features, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html">How Amazon Transcribe Medical
     * works</a>.
     * </p>
     * <p>
     * To make a <code>StartMedicalTranscriptionJob</code> request, you must first upload your media file into an Amazon
     * S3 bucket; you can then specify the S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MedicalTranscriptionJobName</code>: A custom name you create for your transcription job that is unique
     * within your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LanguageCode</code>: This must be <code>en-US</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputBucketName</code>: The Amazon S3 bucket where you want your transcript stored. If you want your
     * output stored in a sub-folder of this bucket, you must also include <code>OutputKey</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Specialty</code>: This must be <code>PRIMARYCARE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>: Choose whether your audio is a conversation or a dictation.
     * </p>
     * </li>
     * </ul>
     *
     * @param startMedicalTranscriptionJobRequest
     * @return A Java Future containing the result of the StartMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMedicalTranscriptionJobResponse> startMedicalTranscriptionJob(
            StartMedicalTranscriptionJobRequest startMedicalTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you
     * choose to include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical
     * vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To
     * learn more about these features, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html">How Amazon Transcribe Medical
     * works</a>.
     * </p>
     * <p>
     * To make a <code>StartMedicalTranscriptionJob</code> request, you must first upload your media file into an Amazon
     * S3 bucket; you can then specify the S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MedicalTranscriptionJobName</code>: A custom name you create for your transcription job that is unique
     * within your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LanguageCode</code>: This must be <code>en-US</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputBucketName</code>: The Amazon S3 bucket where you want your transcript stored. If you want your
     * output stored in a sub-folder of this bucket, you must also include <code>OutputKey</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Specialty</code>: This must be <code>PRIMARYCARE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>: Choose whether your audio is a conversation or a dictation.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartMedicalTranscriptionJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartMedicalTranscriptionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMedicalTranscriptionJobResponse> startMedicalTranscriptionJob(
            Consumer<StartMedicalTranscriptionJobRequest.Builder> startMedicalTranscriptionJobRequest) {
        return startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest.builder()
                .applyMutation(startMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in
     * your request.
     * </p>
     * <p>
     * To make a <code>StartTranscriptionJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * One of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code>: If
     * you know the language of your media file, specify it using the <code>LanguageCode</code> parameter; you can find
     * all valid language codes in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * If you don't know the languages spoken in your media, use either <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> and let Amazon Transcribe identify the languages for you.
     * </p>
     * </li>
     * </ul>
     *
     * @param startTranscriptionJobRequest
     * @return A Java Future containing the result of the StartTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTranscriptionJobResponse> startTranscriptionJob(
            StartTranscriptionJobRequest startTranscriptionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in
     * your request.
     * </p>
     * <p>
     * To make a <code>StartTranscriptionJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * One of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code>: If
     * you know the language of your media file, specify it using the <code>LanguageCode</code> parameter; you can find
     * all valid language codes in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * If you don't know the languages spoken in your media, use either <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> and let Amazon Transcribe identify the languages for you.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTranscriptionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTranscriptionJobResponse> startTranscriptionJob(
            Consumer<StartTranscriptionJobRequest.Builder> startTranscriptionJobRequest) {
        return startTranscriptionJob(StartTranscriptionJobRequest.builder().applyMutation(startTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Transcribe resource.
     * </p>
     * <p>
     * If you include <code>UntagResource</code> in your request, you must also include <code>ResourceArn</code> and
     * <code>TagKeys</code>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Transcribe resource.
     * </p>
     * <p>
     * If you include <code>UntagResource</code> in your request, you must also include <code>ResourceArn</code> and
     * <code>TagKeys</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified Call Analytics category with new rules. Note that the
     * <code>UpdateCallAnalyticsCategory</code> operation overwrites all existing rules contained in the specified
     * category. You cannot append additional rules onto an existing category.
     * </p>
     * <p>
     * To create a new category, see .
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     * @return A Java Future containing the result of the UpdateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCallAnalyticsCategoryResponse> updateCallAnalyticsCategory(
            UpdateCallAnalyticsCategoryRequest updateCallAnalyticsCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified Call Analytics category with new rules. Note that the
     * <code>UpdateCallAnalyticsCategory</code> operation overwrites all existing rules contained in the specified
     * category. You cannot append additional rules onto an existing category.
     * </p>
     * <p>
     * To create a new category, see .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateCallAnalyticsCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCallAnalyticsCategoryResponse> updateCallAnalyticsCategory(
            Consumer<UpdateCallAnalyticsCategoryRequest.Builder> updateCallAnalyticsCategoryRequest) {
        return updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest.builder()
                .applyMutation(updateCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information
     * with your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     * @return A Java Future containing the result of the UpdateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMedicalVocabularyResponse> updateMedicalVocabulary(
            UpdateMedicalVocabularyRequest updateMedicalVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information
     * with your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMedicalVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMedicalVocabularyResponse> updateMedicalVocabulary(
            Consumer<UpdateMedicalVocabularyRequest.Builder> updateMedicalVocabularyRequest) {
        return updateMedicalVocabulary(UpdateMedicalVocabularyRequest.builder().applyMutation(updateMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with
     * your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     *
     * @param updateVocabularyRequest
     * @return A Java Future containing the result of the UpdateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyResponse> updateVocabulary(UpdateVocabularyRequest updateVocabularyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with
     * your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVocabularyRequest#builder()}
     * </p>
     *
     * @param updateVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateVocabulary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>ConflictException A resource already exists with this name. Resource names must be unique within an
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyResponse> updateVocabulary(
            Consumer<UpdateVocabularyRequest.Builder> updateVocabularyRequest) {
        return updateVocabulary(UpdateVocabularyRequest.builder().applyMutation(updateVocabularyRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all
     * previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     * </p>
     *
     * @param updateVocabularyFilterRequest
     * @return A Java Future containing the result of the UpdateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyFilterResponse> updateVocabularyFilter(
            UpdateVocabularyFilterRequest updateVocabularyFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all
     * previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param updateVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVocabularyFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Your request didn't pass one or more validation tests. This can occur when the
     *         entity you're trying to delete doesn't exist or if it's in a non-terminal state (such as
     *         <code>IN PROGRESS</code>). See the exception message field for more information.</li>
     *         <li>LimitExceededException You've either sent too many requests or your input file is too long. Wait
     *         before retrying your request, or use a smaller file and try your request again.</li>
     *         <li>InternalFailureException There was an internal error. Check the error message, correct the issue, and
     *         try your request again.</li>
     *         <li>NotFoundException We can't find the requested resource. Check that the specified name is correct and
     *         try your request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranscribeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranscribeAsyncClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVocabularyFilterResponse> updateVocabularyFilter(
            Consumer<UpdateVocabularyFilterRequest.Builder> updateVocabularyFilterRequest) {
        return updateVocabularyFilter(UpdateVocabularyFilterRequest.builder().applyMutation(updateVocabularyFilterRequest)
                .build());
    }

    /**
     * Create a {@link TranscribeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranscribeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranscribeAsyncClient}.
     */
    static TranscribeAsyncClientBuilder builder() {
        return new DefaultTranscribeAsyncClientBuilder();
    }
}
