/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.transcribe.model.BadRequestException;
import software.amazon.awssdk.services.transcribe.model.ConflictException;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.CreateLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.InternalFailureException;
import software.amazon.awssdk.services.transcribe.model.LimitExceededException;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest;
import software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transcribe.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;
import software.amazon.awssdk.services.transcribe.model.NotFoundException;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.TagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.TagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.TranscribeException;
import software.amazon.awssdk.services.transcribe.model.UntagResourceRequest;
import software.amazon.awssdk.services.transcribe.model.UntagResourceResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyFilterResponse;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.UpdateVocabularyResponse;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable;
import software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable;

/**
 * Service client for accessing Amazon Transcribe Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Transcribe offers three main types of batch transcription: <b>Standard</b>, <b>Medical</b>, and <b>Call
 * Analytics</b>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Standard transcriptions</b> are the most common option. Refer to for details.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Medical transcriptions</b> are tailored to medical professionals and incorporate medical terms. A common use case
 * for this service is transcribing doctor-patient dialogue into after-visit notes. Refer to for details.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Call Analytics transcriptions</b> are designed for use with call center audio on two different channels; if you're
 * looking for insight into customer service calls, use this option. Refer to for details.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TranscribeClient extends SdkClient {
    String SERVICE_NAME = "transcribe";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "transcribe";

    /**
     * <p>
     * Creates a new Call Analytics category.
     * </p>
     * <p>
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply
     * categories to your transcriptions, you must create them before submitting your transcription request, as
     * categories cannot be applied retroactively.
     * </p>
     * <p>
     * When creating a new category, you can use the <code>InputType</code> parameter to label the category as a
     * <code>POST_CALL</code> or a <code>REAL_TIME</code> category. <code>POST_CALL</code> categories can only be
     * applied to post-call transcriptions and <code>REAL_TIME</code> categories can only be applied to real-time
     * transcriptions. If you do not include <code>InputType</code>, your category is created as a
     * <code>POST_CALL</code> category by default.
     * </p>
     * <p>
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules
     * can include these parameters: , , , and .
     * </p>
     * <p>
     * To update an existing category, see .
     * </p>
     * <p>
     * To learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     * @return Result of the CreateCallAnalyticsCategory operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCallAnalyticsCategoryResponse createCallAnalyticsCategory(
            CreateCallAnalyticsCategoryRequest createCallAnalyticsCategoryRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Call Analytics category.
     * </p>
     * <p>
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply
     * categories to your transcriptions, you must create them before submitting your transcription request, as
     * categories cannot be applied retroactively.
     * </p>
     * <p>
     * When creating a new category, you can use the <code>InputType</code> parameter to label the category as a
     * <code>POST_CALL</code> or a <code>REAL_TIME</code> category. <code>POST_CALL</code> categories can only be
     * applied to post-call transcriptions and <code>REAL_TIME</code> categories can only be applied to real-time
     * transcriptions. If you do not include <code>InputType</code>, your category is created as a
     * <code>POST_CALL</code> category by default.
     * </p>
     * <p>
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules
     * can include these parameters: , , , and .
     * </p>
     * <p>
     * To update an existing category, see .
     * </p>
     * <p>
     * To learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param createCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return Result of the CreateCallAnalyticsCategory operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCallAnalyticsCategoryResponse createCallAnalyticsCategory(
            Consumer<CreateCallAnalyticsCategoryRequest.Builder> createCallAnalyticsCategoryRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest.builder()
                .applyMutation(createCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Creates a new custom language model.
     * </p>
     * <p>
     * When creating a new custom language model, you must specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz)
     * base model
     * </p>
     * </li>
     * <li>
     * <p>
     * The location of your training and tuning files (this must be an Amazon S3 URI)
     * </p>
     * </li>
     * <li>
     * <p>
     * The language of your model
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique name for your model
     * </p>
     * </li>
     * </ul>
     *
     * @param createLanguageModelRequest
     * @return Result of the CreateLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLanguageModelResponse createLanguageModel(CreateLanguageModelRequest createLanguageModelRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom language model.
     * </p>
     * <p>
     * When creating a new custom language model, you must specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz)
     * base model
     * </p>
     * </li>
     * <li>
     * <p>
     * The location of your training and tuning files (this must be an Amazon S3 URI)
     * </p>
     * </li>
     * <li>
     * <p>
     * The language of your model
     * </p>
     * </li>
     * <li>
     * <p>
     * A unique name for your model
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLanguageModelRequest#builder()}
     * </p>
     *
     * @param createLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateLanguageModelRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLanguageModelResponse createLanguageModel(
            Consumer<CreateLanguageModelRequest.Builder> createLanguageModelRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return createLanguageModel(CreateLanguageModelRequest.builder().applyMutation(createLanguageModelRequest).build());
    }

    /**
     * <p>
     * Creates a new custom medical vocabulary.
     * </p>
     * <p>
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary
     * table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your
     * request using the <code>Phrases</code> flag; <code>CreateMedicalVocabulary</code> does not support the
     * <code>Phrases</code> flag and only accepts vocabularies in table format.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     *
     * @param createMedicalVocabularyRequest
     * @return Result of the CreateMedicalVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMedicalVocabularyResponse createMedicalVocabulary(CreateMedicalVocabularyRequest createMedicalVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom medical vocabulary.
     * </p>
     * <p>
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary
     * table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your
     * request using the <code>Phrases</code> flag; <code>CreateMedicalVocabulary</code> does not support the
     * <code>Phrases</code> flag and only accepts vocabularies in table format.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param createMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMedicalVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMedicalVocabularyResponse createMedicalVocabulary(
            Consumer<CreateMedicalVocabularyRequest.Builder> createMedicalVocabularyRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return createMedicalVocabulary(CreateMedicalVocabularyRequest.builder().applyMutation(createMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary.
     * </p>
     * <p>
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases,
     * and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms
     * directly in your request using the <code>Phrases</code> flag.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     *
     * @param createVocabularyRequest
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(CreateVocabularyRequest createVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary.
     * </p>
     * <p>
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases,
     * and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms
     * directly in your request using the <code>Phrases</code> flag.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyRequest.Builder} to create a request.
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Creates a new custom vocabulary filter.
     * </p>
     * <p>
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom
     * vocabulary filters are commonly used to mask profanity in transcripts.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary filter request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Vocabulary filtering</a>.
     * </p>
     *
     * @param createVocabularyFilterRequest
     * @return Result of the CreateVocabularyFilter operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVocabularyFilterResponse createVocabularyFilter(CreateVocabularyFilterRequest createVocabularyFilterRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom vocabulary filter.
     * </p>
     * <p>
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom
     * vocabulary filters are commonly used to mask profanity in transcripts.
     * </p>
     * <p>
     * Each language has a character set that contains all allowed characters for that specific language. If you use
     * unsupported characters, your custom vocabulary filter request fails. Refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a>
     * to get the character set for your language.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Vocabulary filtering</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param createVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVocabularyFilter operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.CreateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVocabularyFilterResponse createVocabularyFilter(
            Consumer<CreateVocabularyFilterRequest.Builder> createVocabularyFilterRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return createVocabularyFilter(CreateVocabularyFilterRequest.builder().applyMutation(createVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete
     * using <code>CategoryName</code>. Category names are case sensitive.
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     * @return Result of the DeleteCallAnalyticsCategory operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCallAnalyticsCategoryResponse deleteCallAnalyticsCategory(
            DeleteCallAnalyticsCategoryRequest deleteCallAnalyticsCategoryRequest) throws NotFoundException,
            LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete
     * using <code>CategoryName</code>. Category names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteCallAnalyticsCategory operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCallAnalyticsCategoryResponse deleteCallAnalyticsCategory(
            Consumer<DeleteCallAnalyticsCategoryRequest.Builder> deleteCallAnalyticsCategoryRequest) throws NotFoundException,
            LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        return deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest.builder()
                .applyMutation(deleteCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using
     * <code>CallAnalyticsJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     * @return Result of the DeleteCallAnalyticsJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCallAnalyticsJobResponse deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest deleteCallAnalyticsJobRequest)
            throws LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using
     * <code>CallAnalyticsJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param deleteCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCallAnalyticsJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCallAnalyticsJobResponse deleteCallAnalyticsJob(
            Consumer<DeleteCallAnalyticsJobRequest.Builder> deleteCallAnalyticsJobRequest) throws LimitExceededException,
            BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest.builder().applyMutation(deleteCallAnalyticsJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete
     * using <code>ModelName</code>. custom language model names are case sensitive.
     * </p>
     *
     * @param deleteLanguageModelRequest
     * @return Result of the DeleteLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLanguageModelResponse deleteLanguageModel(DeleteLanguageModelRequest deleteLanguageModelRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete
     * using <code>ModelName</code>. custom language model names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLanguageModelRequest#builder()}
     * </p>
     *
     * @param deleteLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLanguageModelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLanguageModelResponse deleteLanguageModel(
            Consumer<DeleteLanguageModelRequest.Builder> deleteLanguageModelRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return deleteLanguageModel(DeleteLanguageModelRequest.builder().applyMutation(deleteLanguageModelRequest).build());
    }

    /**
     * <p>
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>MedicalTranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     * @return Result of the DeleteMedicalTranscriptionJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMedicalTranscriptionJobResponse deleteMedicalTranscriptionJob(
            DeleteMedicalTranscriptionJobRequest deleteMedicalTranscriptionJobRequest) throws LimitExceededException,
            BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>MedicalTranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalTranscriptionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMedicalTranscriptionJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMedicalTranscriptionJobResponse deleteMedicalTranscriptionJob(
            Consumer<DeleteMedicalTranscriptionJobRequest.Builder> deleteMedicalTranscriptionJobRequest)
            throws LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest.builder()
                .applyMutation(deleteMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to
     * delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     * @return Result of the DeleteMedicalVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMedicalVocabularyResponse deleteMedicalVocabulary(DeleteMedicalVocabularyRequest deleteMedicalVocabularyRequest)
            throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to
     * delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMedicalVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMedicalVocabularyResponse deleteMedicalVocabulary(
            Consumer<DeleteMedicalVocabularyRequest.Builder> deleteMedicalVocabularyRequest) throws NotFoundException,
            LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        return deleteMedicalVocabulary(DeleteMedicalVocabularyRequest.builder().applyMutation(deleteMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>TranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     * @return Result of the DeleteTranscriptionJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTranscriptionJobResponse deleteTranscriptionJob(DeleteTranscriptionJobRequest deleteTranscriptionJobRequest)
            throws LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using
     * <code>TranscriptionJobName</code>. Job names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param deleteTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTranscriptionJob operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTranscriptionJobResponse deleteTranscriptionJob(
            Consumer<DeleteTranscriptionJobRequest.Builder> deleteTranscriptionJobRequest) throws LimitExceededException,
            BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return deleteTranscriptionJob(DeleteTranscriptionJobRequest.builder().applyMutation(deleteTranscriptionJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete
     * using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) throws NotFoundException,
            LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete
     * using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyRequest.Builder} to create a request.
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest)
            throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you
     * want to delete using <code>VocabularyFilterName</code>. Custom vocabulary filter names are case sensitive.
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     * @return Result of the DeleteVocabularyFilter operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVocabularyFilterResponse deleteVocabularyFilter(DeleteVocabularyFilterRequest deleteVocabularyFilterRequest)
            throws NotFoundException, LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you
     * want to delete using <code>VocabularyFilterName</code>. Custom vocabulary filter names are case sensitive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVocabularyFilter operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DeleteVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVocabularyFilterResponse deleteVocabularyFilter(
            Consumer<DeleteVocabularyFilterRequest.Builder> deleteVocabularyFilterRequest) throws NotFoundException,
            LimitExceededException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        return deleteVocabularyFilter(DeleteVocabularyFilterRequest.builder().applyMutation(deleteVocabularyFilterRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the specified custom language model.
     * </p>
     * <p>
     * This operation also shows if the base language model that you used to create your custom language model has been
     * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the
     * updated base model.
     * </p>
     * <p>
     * If you tried to create a new custom language model and the request wasn't successful, you can use
     * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     * </p>
     *
     * @param describeLanguageModelRequest
     * @return Result of the DescribeLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLanguageModelResponse describeLanguageModel(DescribeLanguageModelRequest describeLanguageModelRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom language model.
     * </p>
     * <p>
     * This operation also shows if the base language model that you used to create your custom language model has been
     * updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the
     * updated base model.
     * </p>
     * <p>
     * If you tried to create a new custom language model and the request wasn't successful, you can use
     * <code>DescribeLanguageModel</code> to help identify the reason for this failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLanguageModelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLanguageModelRequest#builder()}
     * </p>
     *
     * @param describeLanguageModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLanguageModelRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLanguageModel operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.DescribeLanguageModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLanguageModelResponse describeLanguageModel(
            Consumer<DescribeLanguageModelRequest.Builder> describeLanguageModelRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        return describeLanguageModel(DescribeLanguageModelRequest.builder().applyMutation(describeLanguageModelRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics category.
     * </p>
     * <p>
     * To get a list of your Call Analytics categories, use the operation.
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     * @return Result of the GetCallAnalyticsCategory operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCallAnalyticsCategoryResponse getCallAnalyticsCategory(
            GetCallAnalyticsCategoryRequest getCallAnalyticsCategoryRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics category.
     * </p>
     * <p>
     * To get a list of your Call Analytics categories, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsCategoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsCategoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetCallAnalyticsCategory operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCallAnalyticsCategoryResponse getCallAnalyticsCategory(
            Consumer<GetCallAnalyticsCategoryRequest.Builder> getCallAnalyticsCategoryRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest.builder().applyMutation(getCallAnalyticsCategoryRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics job.
     * </p>
     * <p>
     * To view the job's status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>,
     * the job is finished. You can find your completed transcript at the URI specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the
     * location specified in <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location
     * specified in <code>RedactedMediaFileUri</code>.
     * </p>
     * <p>
     * To get a list of your Call Analytics jobs, use the operation.
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     * @return Result of the GetCallAnalyticsJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCallAnalyticsJobResponse getCallAnalyticsJob(GetCallAnalyticsJobRequest getCallAnalyticsJobRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified Call Analytics job.
     * </p>
     * <p>
     * To view the job's status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>,
     * the job is finished. You can find your completed transcript at the URI specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the
     * location specified in <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location
     * specified in <code>RedactedMediaFileUri</code>.
     * </p>
     * <p>
     * To get a list of your Call Analytics jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param getCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link GetCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetCallAnalyticsJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCallAnalyticsJobResponse getCallAnalyticsJob(
            Consumer<GetCallAnalyticsJobRequest.Builder> getCallAnalyticsJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getCallAnalyticsJob(GetCallAnalyticsJobRequest.builder().applyMutation(getCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified medical transcription job.
     * </p>
     * <p>
     * To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code>
     * field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * To get a list of your medical transcription jobs, use the operation.
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     * @return Result of the GetMedicalTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMedicalTranscriptionJobResponse getMedicalTranscriptionJob(
            GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified medical transcription job.
     * </p>
     * <p>
     * To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code>
     * field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * To get a list of your medical transcription jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalTranscriptionJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetMedicalTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMedicalTranscriptionJobResponse getMedicalTranscriptionJob(
            Consumer<GetMedicalTranscriptionJobRequest.Builder> getMedicalTranscriptionJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest.builder()
                .applyMutation(getMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom medical vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom medical vocabulary, check the <code>VocabularyState</code> field. If
     * the status is <code>READY</code>, your custom vocabulary is available to use. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details on why your vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom medical vocabularies, use the operation.
     * </p>
     *
     * @param getMedicalVocabularyRequest
     * @return Result of the GetMedicalVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMedicalVocabularyResponse getMedicalVocabulary(GetMedicalVocabularyRequest getMedicalVocabularyRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom medical vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom medical vocabulary, check the <code>VocabularyState</code> field. If
     * the status is <code>READY</code>, your custom vocabulary is available to use. If the status is
     * <code>FAILED</code>, <code>FailureReason</code> provides details on why your vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom medical vocabularies, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMedicalVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link GetMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param getMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the GetMedicalVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMedicalVocabularyResponse getMedicalVocabulary(
            Consumer<GetMedicalVocabularyRequest.Builder> getMedicalVocabularyRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getMedicalVocabulary(GetMedicalVocabularyRequest.builder().applyMutation(getMedicalVocabularyRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified transcription job.
     * </p>
     * <p>
     * To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If
     * the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled content redaction, the redacted transcript can be found at the location specified in
     * <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * To get a list of your transcription jobs, use the operation.
     * </p>
     *
     * @param getTranscriptionJobRequest
     * @return Result of the GetTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTranscriptionJobResponse getTranscriptionJob(GetTranscriptionJobRequest getTranscriptionJobRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified transcription job.
     * </p>
     * <p>
     * To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If
     * the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in
     * <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     * on why your transcription job failed.
     * </p>
     * <p>
     * If you enabled content redaction, the redacted transcript can be found at the location specified in
     * <code>RedactedTranscriptFileUri</code>.
     * </p>
     * <p>
     * To get a list of your transcription jobs, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param getTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTranscriptionJobResponse getTranscriptionJob(
            Consumer<GetTranscriptionJobRequest.Builder> getTranscriptionJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getTranscriptionJob(GetTranscriptionJobRequest.builder().applyMutation(getTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom vocabulary, check the <code>VocabularyState</code> field. If the
     * status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>,
     * <code>FailureReason</code> provides details on why your custom vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom vocabularies, use the operation.
     * </p>
     *
     * @param getVocabularyRequest
     * @return Result of the GetVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVocabularyResponse getVocabulary(GetVocabularyRequest getVocabularyRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary.
     * </p>
     * <p>
     * To view the status of the specified custom vocabulary, check the <code>VocabularyState</code> field. If the
     * status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>,
     * <code>FailureReason</code> provides details on why your custom vocabulary failed.
     * </p>
     * <p>
     * To get a list of your custom vocabularies, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyRequest.Builder} avoiding the need to
     * create one manually via {@link GetVocabularyRequest#builder()}
     * </p>
     *
     * @param getVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyRequest.Builder} to create a request.
     * @return Result of the GetVocabulary operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVocabularyResponse getVocabulary(Consumer<GetVocabularyRequest.Builder> getVocabularyRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, TranscribeException {
        return getVocabulary(GetVocabularyRequest.builder().applyMutation(getVocabularyRequest).build());
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary filter.
     * </p>
     * <p>
     * To get a list of your custom vocabulary filters, use the operation.
     * </p>
     *
     * @param getVocabularyFilterRequest
     * @return Result of the GetVocabularyFilter operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVocabularyFilterResponse getVocabularyFilter(GetVocabularyFilterRequest getVocabularyFilterRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the specified custom vocabulary filter.
     * </p>
     * <p>
     * To get a list of your custom vocabulary filters, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link GetVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param getVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link GetVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return Result of the GetVocabularyFilter operation returned by the service.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.GetVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVocabularyFilterResponse getVocabularyFilter(
            Consumer<GetVocabularyFilterRequest.Builder> getVocabularyFilterRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            TranscribeException {
        return getVocabularyFilter(GetVocabularyFilterRequest.builder().applyMutation(getVocabularyFilterRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return Result of the ListCallAnalyticsCategories operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesResponse listCallAnalyticsCategories(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return Result of the ListCallAnalyticsCategories operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesResponse listCallAnalyticsCategories(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client.listCallAnalyticsCategoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client
     *             .listCallAnalyticsCategoriesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client.listCallAnalyticsCategoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesIterable listCallAnalyticsCategoriesPaginator(
            ListCallAnalyticsCategoriesRequest listCallAnalyticsCategoriesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics category, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client.listCallAnalyticsCategoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client
     *             .listCallAnalyticsCategoriesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsCategoriesIterable responses = client.listCallAnalyticsCategoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsCategories(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsCategoriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCallAnalyticsCategoriesRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsCategoriesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsCategoriesIterable listCallAnalyticsCategoriesPaginator(
            Consumer<ListCallAnalyticsCategoriesRequest.Builder> listCallAnalyticsCategoriesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listCallAnalyticsCategoriesPaginator(ListCallAnalyticsCategoriesRequest.builder()
                .applyMutation(listCallAnalyticsCategoriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return Result of the ListCallAnalyticsJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsResponse listCallAnalyticsJobs(ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCallAnalyticsJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsResponse listCallAnalyticsJobs(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listCallAnalyticsJobs(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client.listCallAnalyticsJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client
     *             .listCallAnalyticsJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client.listCallAnalyticsJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsIterable listCallAnalyticsJobsPaginator(ListCallAnalyticsJobsRequest listCallAnalyticsJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call
     * Analytics jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific Call Analytics job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client.listCallAnalyticsJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client
     *             .listCallAnalyticsJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListCallAnalyticsJobsIterable responses = client.listCallAnalyticsJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCallAnalyticsJobs(software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCallAnalyticsJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCallAnalyticsJobsRequest#builder()}
     * </p>
     *
     * @param listCallAnalyticsJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCallAnalyticsJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListCallAnalyticsJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCallAnalyticsJobsIterable listCallAnalyticsJobsPaginator(
            Consumer<ListCallAnalyticsJobsRequest.Builder> listCallAnalyticsJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listCallAnalyticsJobsPaginator(ListCallAnalyticsJobsRequest.builder().applyMutation(listCallAnalyticsJobsRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return Result of the ListLanguageModels operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsResponse listLanguageModels(ListLanguageModelsRequest listLanguageModelsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLanguageModels operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsResponse listLanguageModels(Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return listLanguageModels(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client.listLanguageModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client
     *             .listLanguageModelsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client.listLanguageModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLanguageModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsIterable listLanguageModelsPaginator(ListLanguageModelsRequest listLanguageModelsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all
     * custom language models are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom language model, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client.listLanguageModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client
     *             .listLanguageModelsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListLanguageModelsIterable responses = client.listLanguageModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguageModels(software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguageModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLanguageModelsRequest#builder()}
     * </p>
     *
     * @param listLanguageModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListLanguageModelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListLanguageModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLanguageModelsIterable listLanguageModelsPaginator(
            Consumer<ListLanguageModelsRequest.Builder> listLanguageModelsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listLanguageModelsPaginator(ListLanguageModelsRequest.builder().applyMutation(listLanguageModelsRequest).build());
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return Result of the ListMedicalTranscriptionJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsResponse listMedicalTranscriptionJobs(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListMedicalTranscriptionJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsResponse listMedicalTranscriptionJobs(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client.listMedicalTranscriptionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client
     *             .listMedicalTranscriptionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client.listMedicalTranscriptionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsIterable listMedicalTranscriptionJobsPaginator(
            ListMedicalTranscriptionJobsRequest listMedicalTranscriptionJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified,
     * all medical transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific medical transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client.listMedicalTranscriptionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client
     *             .listMedicalTranscriptionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalTranscriptionJobsIterable responses = client.listMedicalTranscriptionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalTranscriptionJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMedicalTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listMedicalTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalTranscriptionJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalTranscriptionJobsIterable listMedicalTranscriptionJobsPaginator(
            Consumer<ListMedicalTranscriptionJobsRequest.Builder> listMedicalTranscriptionJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return listMedicalTranscriptionJobsPaginator(ListMedicalTranscriptionJobsRequest.builder()
                .applyMutation(listMedicalTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return Result of the ListMedicalVocabularies operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesResponse listMedicalVocabularies(ListMedicalVocabulariesRequest listMedicalVocabulariesRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListMedicalVocabularies operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesResponse listMedicalVocabularies(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listMedicalVocabularies(ListMedicalVocabulariesRequest.builder().applyMutation(listMedicalVocabulariesRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client.listMedicalVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client
     *             .listMedicalVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client.listMedicalVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesIterable listMedicalVocabulariesPaginator(
            ListMedicalVocabulariesRequest listMedicalVocabulariesRequest) throws BadRequestException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified,
     * all custom medical vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client.listMedicalVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client
     *             .listMedicalVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListMedicalVocabulariesIterable responses = client.listMedicalVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMedicalVocabularies(software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMedicalVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListMedicalVocabulariesRequest#builder()}
     * </p>
     *
     * @param listMedicalVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListMedicalVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListMedicalVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMedicalVocabulariesIterable listMedicalVocabulariesPaginator(
            Consumer<ListMedicalVocabulariesRequest.Builder> listMedicalVocabulariesRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listMedicalVocabulariesPaginator(ListMedicalVocabulariesRequest.builder()
                .applyMutation(listMedicalVocabulariesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     *
     * @return Result of the ListTranscriptionJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see #listTranscriptionJobs(ListTranscriptionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsResponse listTranscriptionJobs() throws BadRequestException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return Result of the ListTranscriptionJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsResponse listTranscriptionJobs(ListTranscriptionJobsRequest listTranscriptionJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTranscriptionJobs operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsResponse listTranscriptionJobs(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listTranscriptionJobs(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest).build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client
     *             .listTranscriptionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see #listTranscriptionJobsPaginator(ListTranscriptionJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsIterable listTranscriptionJobsPaginator() throws BadRequestException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client
     *             .listTranscriptionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTranscriptionJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsIterable listTranscriptionJobsPaginator(ListTranscriptionJobsRequest listTranscriptionJobsRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all
     * transcription jobs are returned.
     * </p>
     * <p>
     * To get detailed information about a specific transcription job, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client
     *             .listTranscriptionJobsPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListTranscriptionJobsIterable responses = client.listTranscriptionJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTranscriptionJobs(software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTranscriptionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTranscriptionJobsRequest#builder()}
     * </p>
     *
     * @param listTranscriptionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTranscriptionJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListTranscriptionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTranscriptionJobsIterable listTranscriptionJobsPaginator(
            Consumer<ListTranscriptionJobsRequest.Builder> listTranscriptionJobsRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listTranscriptionJobsPaginator(ListTranscriptionJobsRequest.builder().applyMutation(listTranscriptionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     *
     * @return Result of the ListVocabularies operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see #listVocabularies(ListVocabulariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesResponse listVocabularies() throws BadRequestException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listVocabularies(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     *
     * @param listVocabulariesRequest
     * @return Result of the ListVocabularies operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesResponse listVocabularies(ListVocabulariesRequest listVocabulariesRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return Result of the ListVocabularies operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesResponse listVocabularies(Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return listVocabularies(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client
     *             .listVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see #listVocabulariesPaginator(ListVocabulariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesIterable listVocabulariesPaginator() throws BadRequestException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client
     *             .listVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabulariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesIterable listVocabulariesPaginator(ListVocabulariesRequest listVocabulariesRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client
     *             .listVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabulariesIterable responses = client.listVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularies(software.amazon.awssdk.services.transcribe.model.ListVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabulariesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVocabulariesRequest#builder()}
     * </p>
     *
     * @param listVocabulariesRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabulariesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVocabulariesIterable listVocabulariesPaginator(Consumer<ListVocabulariesRequest.Builder> listVocabulariesRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return listVocabulariesPaginator(ListVocabulariesRequest.builder().applyMutation(listVocabulariesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return Result of the ListVocabularyFilters operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersResponse listVocabularyFilters(ListVocabularyFiltersRequest listVocabularyFiltersRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return Result of the ListVocabularyFilters operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersResponse listVocabularyFilters(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listVocabularyFilters(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client.listVocabularyFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client
     *             .listVocabularyFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client.listVocabularyFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVocabularyFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersIterable listVocabularyFiltersPaginator(ListVocabularyFiltersRequest listVocabularyFiltersRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all
     * custom vocabularies are returned.
     * </p>
     * <p>
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client.listVocabularyFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client
     *             .listVocabularyFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transcribe.paginators.ListVocabularyFiltersIterable responses = client.listVocabularyFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVocabularyFilters(software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVocabularyFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListVocabularyFiltersRequest#builder()}
     * </p>
     *
     * @param listVocabularyFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListVocabularyFiltersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.ListVocabularyFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVocabularyFiltersIterable listVocabularyFiltersPaginator(
            Consumer<ListVocabularyFiltersRequest.Builder> listVocabularyFiltersRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, TranscribeException {
        return listVocabularyFiltersPaginator(ListVocabularyFiltersRequest.builder().applyMutation(listVocabularyFiltersRequest)
                .build());
    }

    /**
     * <p>
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to
     * include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call
     * summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can
     * also apply custom categories to flag specified conditions. To learn more about these features and insights, refer
     * to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio
     * with Call Analytics</a>.
     * </p>
     * <p>
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job
     * request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To
     * learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <p>
     * To make a <code>StartCallAnalyticsJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * Note that job queuing is enabled by default for Call Analytics jobs.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartCallAnalyticsJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CallAnalyticsJobName</code>: A custom name that you create for your transcription job that's unique within
     * your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataAccessRoleArn</code>: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the
     * Amazon S3 bucket that contains your input files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code> or <code>RedactedMediaFileUri</code>): The Amazon S3 location of
     * your media file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * With Call Analytics, you can redact the audio contained in your media file by including
     * <code>RedactedMediaFileUri</code>, instead of <code>MediaFileUri</code>, to specify the location of your input
     * audio. If you choose to redact your audio, you can find your redacted media at the location specified in the
     * <code>RedactedMediaFileUri</code> field of your response.
     * </p>
     * </note>
     *
     * @param startCallAnalyticsJobRequest
     * @return Result of the StartCallAnalyticsJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCallAnalyticsJobResponse startCallAnalyticsJob(StartCallAnalyticsJobRequest startCallAnalyticsJobRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to
     * include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call
     * summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can
     * also apply custom categories to flag specified conditions. To learn more about these features and insights, refer
     * to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio
     * with Call Analytics</a>.
     * </p>
     * <p>
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job
     * request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To
     * learn more about Call Analytics categories, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for
     * post-call transcriptions</a> and <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for
     * real-time transcriptions</a>.
     * </p>
     * <p>
     * To make a <code>StartCallAnalyticsJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * Note that job queuing is enabled by default for Call Analytics jobs.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartCallAnalyticsJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CallAnalyticsJobName</code>: A custom name that you create for your transcription job that's unique within
     * your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataAccessRoleArn</code>: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the
     * Amazon S3 bucket that contains your input files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code> or <code>RedactedMediaFileUri</code>): The Amazon S3 location of
     * your media file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * With Call Analytics, you can redact the audio contained in your media file by including
     * <code>RedactedMediaFileUri</code>, instead of <code>MediaFileUri</code>, to specify the location of your input
     * audio. If you choose to redact your audio, you can find your redacted media at the location specified in the
     * <code>RedactedMediaFileUri</code> field of your response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCallAnalyticsJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartCallAnalyticsJobRequest#builder()}
     * </p>
     *
     * @param startCallAnalyticsJobRequest
     *        A {@link Consumer} that will call methods on {@link StartCallAnalyticsJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartCallAnalyticsJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartCallAnalyticsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCallAnalyticsJobResponse startCallAnalyticsJob(
            Consumer<StartCallAnalyticsJobRequest.Builder> startCallAnalyticsJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return startCallAnalyticsJob(StartCallAnalyticsJobRequest.builder().applyMutation(startCallAnalyticsJobRequest).build());
    }

    /**
     * <p>
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you
     * choose to include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical
     * vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To
     * learn more about these features, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html">How Amazon Transcribe Medical
     * works</a>.
     * </p>
     * <p>
     * To make a <code>StartMedicalTranscriptionJob</code> request, you must first upload your media file into an Amazon
     * S3 bucket; you can then specify the S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MedicalTranscriptionJobName</code>: A custom name you create for your transcription job that is unique
     * within your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LanguageCode</code>: This must be <code>en-US</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputBucketName</code>: The Amazon S3 bucket where you want your transcript stored. If you want your
     * output stored in a sub-folder of this bucket, you must also include <code>OutputKey</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Specialty</code>: This must be <code>PRIMARYCARE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>: Choose whether your audio is a conversation or a dictation.
     * </p>
     * </li>
     * </ul>
     *
     * @param startMedicalTranscriptionJobRequest
     * @return Result of the StartMedicalTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMedicalTranscriptionJobResponse startMedicalTranscriptionJob(
            StartMedicalTranscriptionJobRequest startMedicalTranscriptionJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you
     * choose to include in your request.
     * </p>
     * <p>
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical
     * vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To
     * learn more about these features, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html">How Amazon Transcribe Medical
     * works</a>.
     * </p>
     * <p>
     * To make a <code>StartMedicalTranscriptionJob</code> request, you must first upload your media file into an Amazon
     * S3 bucket; you can then specify the S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MedicalTranscriptionJobName</code>: A custom name you create for your transcription job that is unique
     * within your Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LanguageCode</code>: This must be <code>en-US</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputBucketName</code>: The Amazon S3 bucket where you want your transcript stored. If you want your
     * output stored in a sub-folder of this bucket, you must also include <code>OutputKey</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Specialty</code>: This must be <code>PRIMARYCARE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>: Choose whether your audio is a conversation or a dictation.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMedicalTranscriptionJobRequest.Builder}
     * avoiding the need to create one manually via {@link StartMedicalTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startMedicalTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartMedicalTranscriptionJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartMedicalTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartMedicalTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMedicalTranscriptionJobResponse startMedicalTranscriptionJob(
            Consumer<StartMedicalTranscriptionJobRequest.Builder> startMedicalTranscriptionJobRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        return startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest.builder()
                .applyMutation(startMedicalTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in
     * your request.
     * </p>
     * <p>
     * To make a <code>StartTranscriptionJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * One of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code>: If
     * you know the language of your media file, specify it using the <code>LanguageCode</code> parameter; you can find
     * all valid language codes in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * If you don't know the languages spoken in your media, use either <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> and let Amazon Transcribe identify the languages for you.
     * </p>
     * </li>
     * </ul>
     *
     * @param startTranscriptionJobRequest
     * @return Result of the StartTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTranscriptionJobResponse startTranscriptionJob(StartTranscriptionJobRequest startTranscriptionJobRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in
     * your request.
     * </p>
     * <p>
     * To make a <code>StartTranscriptionJob</code> request, you must first upload your media file into an Amazon S3
     * bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.
     * </p>
     * <p>
     * You must include the following parameters in your <code>StartTranscriptionJob</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web
     * Services Regions supported with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your
     * Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.
     * </p>
     * </li>
     * <li>
     * <p>
     * One of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code>: If
     * you know the language of your media file, specify it using the <code>LanguageCode</code> parameter; you can find
     * all valid language codes in the <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.
     * If you don't know the languages spoken in your media, use either <code>IdentifyLanguage</code> or
     * <code>IdentifyMultipleLanguages</code> and let Amazon Transcribe identify the languages for you.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTranscriptionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartTranscriptionJobRequest#builder()}
     * </p>
     *
     * @param startTranscriptionJobRequest
     *        A {@link Consumer} that will call methods on {@link StartTranscriptionJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartTranscriptionJob operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.StartTranscriptionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTranscriptionJobResponse startTranscriptionJob(
            Consumer<StartTranscriptionJobRequest.Builder> startTranscriptionJobRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, ConflictException, AwsServiceException, SdkClientException,
            TranscribeException {
        return startTranscriptionJob(StartTranscriptionJobRequest.builder().applyMutation(startTranscriptionJobRequest).build());
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, ConflictException,
            NotFoundException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException,
            TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            ConflictException, NotFoundException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Transcribe resource.
     * </p>
     * <p>
     * If you include <code>UntagResource</code> in your request, you must also include <code>ResourceArn</code> and
     * <code>TagKeys</code>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws LimitExceededException,
            BadRequestException, ConflictException, NotFoundException, InternalFailureException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified Amazon Transcribe resource.
     * </p>
     * <p>
     * If you include <code>UntagResource</code> in your request, you must also include <code>ResourceArn</code> and
     * <code>TagKeys</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws LimitExceededException, BadRequestException, ConflictException, NotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, TranscribeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified Call Analytics category with new rules. Note that the
     * <code>UpdateCallAnalyticsCategory</code> operation overwrites all existing rules contained in the specified
     * category. You cannot append additional rules onto an existing category.
     * </p>
     * <p>
     * To create a new category, see .
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     * @return Result of the UpdateCallAnalyticsCategory operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCallAnalyticsCategoryResponse updateCallAnalyticsCategory(
            UpdateCallAnalyticsCategoryRequest updateCallAnalyticsCategoryRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified Call Analytics category with new rules. Note that the
     * <code>UpdateCallAnalyticsCategory</code> operation overwrites all existing rules contained in the specified
     * category. You cannot append additional rules onto an existing category.
     * </p>
     * <p>
     * To create a new category, see .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCallAnalyticsCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCallAnalyticsCategoryRequest#builder()}
     * </p>
     *
     * @param updateCallAnalyticsCategoryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCallAnalyticsCategoryRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateCallAnalyticsCategory operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateCallAnalyticsCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCallAnalyticsCategoryResponse updateCallAnalyticsCategory(
            Consumer<UpdateCallAnalyticsCategoryRequest.Builder> updateCallAnalyticsCategoryRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        return updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest.builder()
                .applyMutation(updateCallAnalyticsCategoryRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information
     * with your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     * @return Result of the UpdateMedicalVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMedicalVocabularyResponse updateMedicalVocabulary(UpdateMedicalVocabularyRequest updateMedicalVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, ConflictException,
            AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information
     * with your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMedicalVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateMedicalVocabularyRequest#builder()}
     * </p>
     *
     * @param updateMedicalVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMedicalVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMedicalVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateMedicalVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMedicalVocabularyResponse updateMedicalVocabulary(
            Consumer<UpdateMedicalVocabularyRequest.Builder> updateMedicalVocabularyRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, TranscribeException {
        return updateMedicalVocabulary(UpdateMedicalVocabularyRequest.builder().applyMutation(updateMedicalVocabularyRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with
     * your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     *
     * @param updateVocabularyRequest
     * @return Result of the UpdateVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVocabularyResponse updateVocabulary(UpdateVocabularyRequest updateVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, ConflictException,
            AwsServiceException, SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with
     * your new values; you cannot append new terms onto an existing custom vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVocabularyRequest#builder()}
     * </p>
     *
     * @param updateVocabularyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyRequest.Builder} to create a request.
     * @return Result of the UpdateVocabulary operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws ConflictException
     *         A resource already exists with this name. Resource names must be unique within an Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVocabularyResponse updateVocabulary(Consumer<UpdateVocabularyRequest.Builder> updateVocabularyRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, ConflictException,
            AwsServiceException, SdkClientException, TranscribeException {
        return updateVocabulary(UpdateVocabularyRequest.builder().applyMutation(updateVocabularyRequest).build());
    }

    /**
     * <p>
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all
     * previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     * </p>
     *
     * @param updateVocabularyFilterRequest
     * @return Result of the UpdateVocabularyFilter operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVocabularyFilterResponse updateVocabularyFilter(UpdateVocabularyFilterRequest updateVocabularyFilterRequest)
            throws BadRequestException, LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, TranscribeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all
     * previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVocabularyFilterRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVocabularyFilterRequest#builder()}
     * </p>
     *
     * @param updateVocabularyFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVocabularyFilterRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateVocabularyFilter operation returned by the service.
     * @throws BadRequestException
     *         Your request didn't pass one or more validation tests. This can occur when the entity you're trying to
     *         delete doesn't exist or if it's in a non-terminal state (such as <code>IN PROGRESS</code>). See the
     *         exception message field for more information.
     * @throws LimitExceededException
     *         You've either sent too many requests or your input file is too long. Wait before retrying your request,
     *         or use a smaller file and try your request again.
     * @throws InternalFailureException
     *         There was an internal error. Check the error message, correct the issue, and try your request again.
     * @throws NotFoundException
     *         We can't find the requested resource. Check that the specified name is correct and try your request
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranscribeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranscribeClient.UpdateVocabularyFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVocabularyFilterResponse updateVocabularyFilter(
            Consumer<UpdateVocabularyFilterRequest.Builder> updateVocabularyFilterRequest) throws BadRequestException,
            LimitExceededException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            TranscribeException {
        return updateVocabularyFilter(UpdateVocabularyFilterRequest.builder().applyMutation(updateVocabularyFilterRequest)
                .build());
    }

    /**
     * Create a {@link TranscribeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranscribeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranscribeClient}.
     */
    static TranscribeClientBuilder builder() {
        return new DefaultTranscribeClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
