/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transcribe.DefaultTranscribeBaseClientBuilder;
import software.amazon.awssdk.services.transcribe.DefaultTranscribeClient;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.TranscribeClientBuilder;
import software.amazon.awssdk.services.transcribe.TranscribeServiceClientConfiguration;
import software.amazon.awssdk.services.transcribe.endpoints.TranscribeEndpointProvider;

@SdkInternalApi
final class DefaultTranscribeClientBuilder
extends DefaultTranscribeBaseClientBuilder<TranscribeClientBuilder, TranscribeClient>
implements TranscribeClientBuilder {
    DefaultTranscribeClientBuilder() {
    }

    @Override
    public DefaultTranscribeClientBuilder endpointProvider(TranscribeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TranscribeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTranscribeClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        TranscribeServiceClientConfiguration serviceClientConfiguration = TranscribeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultTranscribeClient(serviceClientConfiguration, clientConfiguration);
    }
}

