/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.transcribe.endpoints.TranscribeEndpointParams;
import software.amazon.awssdk.services.transcribe.endpoints.TranscribeEndpointProvider;
import software.amazon.awssdk.services.transcribe.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Condition;
import software.amazon.awssdk.services.transcribe.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.transcribe.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.transcribe.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Expr;
import software.amazon.awssdk.services.transcribe.endpoints.internal.FnNode;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Identifier;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Parameter;
import software.amazon.awssdk.services.transcribe.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Parameters;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Rule;
import software.amazon.awssdk.services.transcribe.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultTranscribeEndpointProvider
implements TranscribeEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultTranscribeEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(TranscribeEndpointParams endpointParams) {
        Validate.notNull((Object)endpointParams.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)endpointParams.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultTranscribeEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(TranscribeEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_1(), DefaultTranscribeEndpointProvider.endpointRule_2(), DefaultTranscribeEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_8() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://transcribe-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_8()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_7(), DefaultTranscribeEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.of("aws"), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fips.transcribe.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.of("aws-us-gov"), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://fips.transcribe.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_14() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://transcribe-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_12(), DefaultTranscribeEndpointProvider.endpointRule_13(), DefaultTranscribeEndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_11(), DefaultTranscribeEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://transcribe.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_17() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_17(), DefaultTranscribeEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("cn-north-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://cn.transcribe.cn-north-1.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("cn-northwest-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://cn.transcribe.cn-northwest-1.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_22() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://transcribe.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_5() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_6(), DefaultTranscribeEndpointProvider.endpointRule_10(), DefaultTranscribeEndpointProvider.endpointRule_16(), DefaultTranscribeEndpointProvider.endpointRule_20(), DefaultTranscribeEndpointProvider.endpointRule_21(), DefaultTranscribeEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultTranscribeEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultTranscribeEndpointProvider.endpointRule_0()).addRule(DefaultTranscribeEndpointProvider.endpointRule_4()).addRule(DefaultTranscribeEndpointProvider.endpointRule_23()).build();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

