/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the output of your Medical Scribe job. <code>ClinicalDocumentUri</code> holds the Amazon S3 URI for
 * the Clinical Document and <code>TranscriptFileUri</code> holds the Amazon S3 URI for the Transcript.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeOutput.Builder, MedicalScribeOutput> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptFileUri").getter(getter(MedicalScribeOutput::transcriptFileUri))
            .setter(setter(Builder::transcriptFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()).build();

    private static final SdkField<String> CLINICAL_DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClinicalDocumentUri").getter(getter(MedicalScribeOutput::clinicalDocumentUri))
            .setter(setter(Builder::clinicalDocumentUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalDocumentUri").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD,
            CLINICAL_DOCUMENT_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptFileUri;

    private final String clinicalDocumentUri;

    private MedicalScribeOutput(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
        this.clinicalDocumentUri = builder.clinicalDocumentUri;
    }

    /**
     * <p>
     * Holds the Amazon S3 URI for the Transcript.
     * </p>
     * 
     * @return Holds the Amazon S3 URI for the Transcript.
     */
    public final String transcriptFileUri() {
        return transcriptFileUri;
    }

    /**
     * <p>
     * Holds the Amazon S3 URI for the Clinical Document.
     * </p>
     * 
     * @return Holds the Amazon S3 URI for the Clinical Document.
     */
    public final String clinicalDocumentUri() {
        return clinicalDocumentUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(clinicalDocumentUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeOutput)) {
            return false;
        }
        MedicalScribeOutput other = (MedicalScribeOutput) obj;
        return Objects.equals(transcriptFileUri(), other.transcriptFileUri())
                && Objects.equals(clinicalDocumentUri(), other.clinicalDocumentUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeOutput").add("TranscriptFileUri", transcriptFileUri())
                .add("ClinicalDocumentUri", clinicalDocumentUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptFileUri":
            return Optional.ofNullable(clazz.cast(transcriptFileUri()));
        case "ClinicalDocumentUri":
            return Optional.ofNullable(clazz.cast(clinicalDocumentUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeOutput, T> g) {
        return obj -> g.apply((MedicalScribeOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeOutput> {
        /**
         * <p>
         * Holds the Amazon S3 URI for the Transcript.
         * </p>
         * 
         * @param transcriptFileUri
         *        Holds the Amazon S3 URI for the Transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFileUri(String transcriptFileUri);

        /**
         * <p>
         * Holds the Amazon S3 URI for the Clinical Document.
         * </p>
         * 
         * @param clinicalDocumentUri
         *        Holds the Amazon S3 URI for the Clinical Document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clinicalDocumentUri(String clinicalDocumentUri);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptFileUri;

        private String clinicalDocumentUri;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeOutput model) {
            transcriptFileUri(model.transcriptFileUri);
            clinicalDocumentUri(model.clinicalDocumentUri);
        }

        public final String getTranscriptFileUri() {
            return transcriptFileUri;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        public final String getClinicalDocumentUri() {
            return clinicalDocumentUri;
        }

        public final void setClinicalDocumentUri(String clinicalDocumentUri) {
            this.clinicalDocumentUri = clinicalDocumentUri;
        }

        @Override
        public final Builder clinicalDocumentUri(String clinicalDocumentUri) {
            this.clinicalDocumentUri = clinicalDocumentUri;
            return this;
        }

        @Override
        public MedicalScribeOutput build() {
            return new MedicalScribeOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
