/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse;

public class ListTranscriptionJobsIterable
implements SdkIterable<ListTranscriptionJobsResponse> {
    private final TranscribeClient client;
    private final ListTranscriptionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTranscriptionJobsIterable(TranscribeClient client, ListTranscriptionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTranscriptionJobsResponseFetcher();
    }

    public Iterator<ListTranscriptionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTranscriptionJobsResponseFetcher
    implements SyncPageFetcher<ListTranscriptionJobsResponse> {
        private ListTranscriptionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTranscriptionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTranscriptionJobsResponse nextPage(ListTranscriptionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTranscriptionJobsIterable.this.client.listTranscriptionJobs(ListTranscriptionJobsIterable.this.firstRequest);
            }
            return ListTranscriptionJobsIterable.this.client.listTranscriptionJobs((ListTranscriptionJobsRequest)((Object)ListTranscriptionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

