/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMedicalScribeJobsResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListMedicalScribeJobsResponse.Builder, ListMedicalScribeJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListMedicalScribeJobsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMedicalScribeJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MedicalScribeJobSummary>> MEDICAL_SCRIBE_JOB_SUMMARIES_FIELD = SdkField
            .<List<MedicalScribeJobSummary>> builder(MarshallingType.LIST)
            .memberName("MedicalScribeJobSummaries")
            .getter(getter(ListMedicalScribeJobsResponse::medicalScribeJobSummaries))
            .setter(setter(Builder::medicalScribeJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalScribeJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalScribeJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NEXT_TOKEN_FIELD, MEDICAL_SCRIBE_JOB_SUMMARIES_FIELD));

    private final String status;

    private final String nextToken;

    private final List<MedicalScribeJobSummary> medicalScribeJobSummaries;

    private ListMedicalScribeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.medicalScribeJobSummaries = builder.medicalScribeJobSummaries;
    }

    /**
     * <p>
     * Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by creation date,
     * with the newest job first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MedicalScribeJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by
     *         creation date, with the newest job first.
     * @see MedicalScribeJobStatus
     */
    public final MedicalScribeJobStatus status() {
        return MedicalScribeJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by creation date,
     * with the newest job first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MedicalScribeJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by
     *         creation date, with the newest job first.
     * @see MedicalScribeJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view
     * the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results
     * output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat
     * as needed to view all your results.
     * </p>
     * 
     * @return If <code>NextToken</code> is present in your response, it indicates that not all results are displayed.
     *         To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in
     *         your results output, then run your request again including <code>NextToken</code> with the value of the
     *         copied string. Repeat as needed to view all your results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MedicalScribeJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMedicalScribeJobSummaries() {
        return medicalScribeJobSummaries != null && !(medicalScribeJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a summary of information about each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMedicalScribeJobSummaries} method.
     * </p>
     * 
     * @return Provides a summary of information about each result.
     */
    public final List<MedicalScribeJobSummary> medicalScribeJobSummaries() {
        return medicalScribeJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMedicalScribeJobSummaries() ? medicalScribeJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMedicalScribeJobsResponse)) {
            return false;
        }
        ListMedicalScribeJobsResponse other = (ListMedicalScribeJobsResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && hasMedicalScribeJobSummaries() == other.hasMedicalScribeJobSummaries()
                && Objects.equals(medicalScribeJobSummaries(), other.medicalScribeJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMedicalScribeJobsResponse").add("Status", statusAsString()).add("NextToken", nextToken())
                .add("MedicalScribeJobSummaries", hasMedicalScribeJobSummaries() ? medicalScribeJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MedicalScribeJobSummaries":
            return Optional.ofNullable(clazz.cast(medicalScribeJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMedicalScribeJobsResponse, T> g) {
        return obj -> g.apply((ListMedicalScribeJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMedicalScribeJobsResponse> {
        /**
         * <p>
         * Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by creation
         * date, with the newest job first.
         * </p>
         * 
         * @param status
         *        Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by
         *        creation date, with the newest job first.
         * @see MedicalScribeJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by creation
         * date, with the newest job first.
         * </p>
         * 
         * @param status
         *        Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by
         *        creation date, with the newest job first.
         * @see MedicalScribeJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeJobStatus
         */
        Builder status(MedicalScribeJobStatus status);

        /**
         * <p>
         * If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To
         * view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your
         * results output, then run your request again including <code>NextToken</code> with the value of the copied
         * string. Repeat as needed to view all your results.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is present in your response, it indicates that not all results are
         *        displayed. To view the next set of results, copy the string associated with the <code>NextToken</code>
         *        parameter in your results output, then run your request again including <code>NextToken</code> with
         *        the value of the copied string. Repeat as needed to view all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * 
         * @param medicalScribeJobSummaries
         *        Provides a summary of information about each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalScribeJobSummaries(Collection<MedicalScribeJobSummary> medicalScribeJobSummaries);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * 
         * @param medicalScribeJobSummaries
         *        Provides a summary of information about each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalScribeJobSummaries(MedicalScribeJobSummary... medicalScribeJobSummaries);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #medicalScribeJobSummaries(List<MedicalScribeJobSummary>)}.
         * 
         * @param medicalScribeJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #medicalScribeJobSummaries(java.util.Collection<MedicalScribeJobSummary>)
         */
        Builder medicalScribeJobSummaries(Consumer<MedicalScribeJobSummary.Builder>... medicalScribeJobSummaries);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String status;

        private String nextToken;

        private List<MedicalScribeJobSummary> medicalScribeJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMedicalScribeJobsResponse model) {
            super(model);
            status(model.status);
            nextToken(model.nextToken);
            medicalScribeJobSummaries(model.medicalScribeJobSummaries);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MedicalScribeJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MedicalScribeJobSummary.Builder> getMedicalScribeJobSummaries() {
            List<MedicalScribeJobSummary.Builder> result = MedicalScribeJobSummariesCopier
                    .copyToBuilder(this.medicalScribeJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedicalScribeJobSummaries(Collection<MedicalScribeJobSummary.BuilderImpl> medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries = MedicalScribeJobSummariesCopier.copyFromBuilder(medicalScribeJobSummaries);
        }

        @Override
        public final Builder medicalScribeJobSummaries(Collection<MedicalScribeJobSummary> medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries = MedicalScribeJobSummariesCopier.copy(medicalScribeJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalScribeJobSummaries(MedicalScribeJobSummary... medicalScribeJobSummaries) {
            medicalScribeJobSummaries(Arrays.asList(medicalScribeJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalScribeJobSummaries(Consumer<MedicalScribeJobSummary.Builder>... medicalScribeJobSummaries) {
            medicalScribeJobSummaries(Stream.of(medicalScribeJobSummaries)
                    .map(c -> MedicalScribeJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMedicalScribeJobsResponse build() {
            return new ListMedicalScribeJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
