/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates which speaker is on which channel. The options are <code>CLINICIAN</code> and <code>PATIENT</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeChannelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeChannelDefinition.Builder, MedicalScribeChannelDefinition> {
    private static final SdkField<Integer> CHANNEL_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChannelId").getter(getter(MedicalScribeChannelDefinition::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(MedicalScribeChannelDefinition::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            PARTICIPANT_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer channelId;

    private final String participantRole;

    private MedicalScribeChannelDefinition(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.participantRole = builder.participantRole;
    }

    /**
     * <p>
     * Specify the audio channel you want to define.
     * </p>
     * 
     * @return Specify the audio channel you want to define.
     */
    public final Integer channelId() {
        return channelId;
    }

    /**
     * <p>
     * Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and <code>PATIENT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link MedicalScribeParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
     *         <code>PATIENT</code>
     * @see MedicalScribeParticipantRole
     */
    public final MedicalScribeParticipantRole participantRole() {
        return MedicalScribeParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and <code>PATIENT</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link MedicalScribeParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
     *         <code>PATIENT</code>
     * @see MedicalScribeParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeChannelDefinition)) {
            return false;
        }
        MedicalScribeChannelDefinition other = (MedicalScribeChannelDefinition) obj;
        return Objects.equals(channelId(), other.channelId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeChannelDefinition").add("ChannelId", channelId())
                .add("ParticipantRole", participantRoleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeChannelDefinition, T> g) {
        return obj -> g.apply((MedicalScribeChannelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeChannelDefinition> {
        /**
         * <p>
         * Specify the audio channel you want to define.
         * </p>
         * 
         * @param channelId
         *        Specify the audio channel you want to define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(Integer channelId);

        /**
         * <p>
         * Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
         * <code>PATIENT</code>
         * </p>
         * 
         * @param participantRole
         *        Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
         *        <code>PATIENT</code>
         * @see MedicalScribeParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
         * <code>PATIENT</code>
         * </p>
         * 
         * @param participantRole
         *        Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and
         *        <code>PATIENT</code>
         * @see MedicalScribeParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeParticipantRole
         */
        Builder participantRole(MedicalScribeParticipantRole participantRole);
    }

    static final class BuilderImpl implements Builder {
        private Integer channelId;

        private String participantRole;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeChannelDefinition model) {
            channelId(model.channelId);
            participantRole(model.participantRole);
        }

        public final Integer getChannelId() {
            return channelId;
        }

        public final void setChannelId(Integer channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(Integer channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(MedicalScribeParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        @Override
        public MedicalScribeChannelDefinition build() {
            return new MedicalScribeChannelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
