/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeJobStatus;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeLanguageCode;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeOutput;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeSettings;
import software.amazon.awssdk.services.transcribe.model.Tag;
import software.amazon.awssdk.services.transcribe.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeJob> {
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalScribeJobName").getter(MedicalScribeJob.getter(MedicalScribeJob::medicalScribeJobName)).setter(MedicalScribeJob.setter(Builder::medicalScribeJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobName").build()}).build();
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalScribeJobStatus").getter(MedicalScribeJob.getter(MedicalScribeJob::medicalScribeJobStatusAsString)).setter(MedicalScribeJob.setter(Builder::medicalScribeJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobStatus").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(MedicalScribeJob.getter(MedicalScribeJob::languageCodeAsString)).setter(MedicalScribeJob.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(MedicalScribeJob.getter(MedicalScribeJob::media)).setter(MedicalScribeJob.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<MedicalScribeOutput> MEDICAL_SCRIBE_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MedicalScribeOutput").getter(MedicalScribeJob.getter(MedicalScribeJob::medicalScribeOutput)).setter(MedicalScribeJob.setter(Builder::medicalScribeOutput)).constructor(MedicalScribeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeOutput").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MedicalScribeJob.getter(MedicalScribeJob::startTime)).setter(MedicalScribeJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MedicalScribeJob.getter(MedicalScribeJob::creationTime)).setter(MedicalScribeJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(MedicalScribeJob.getter(MedicalScribeJob::completionTime)).setter(MedicalScribeJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MedicalScribeJob.getter(MedicalScribeJob::failureReason)).setter(MedicalScribeJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<MedicalScribeSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(MedicalScribeJob.getter(MedicalScribeJob::settings)).setter(MedicalScribeJob.setter(Builder::settings)).constructor(MedicalScribeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(MedicalScribeJob.getter(MedicalScribeJob::dataAccessRoleArn)).setter(MedicalScribeJob.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(MedicalScribeJob.getter(MedicalScribeJob::channelDefinitions)).setter(MedicalScribeJob.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(MedicalScribeJob.getter(MedicalScribeJob::tags)).setter(MedicalScribeJob.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_NAME_FIELD, MEDICAL_SCRIBE_JOB_STATUS_FIELD, LANGUAGE_CODE_FIELD, MEDIA_FIELD, MEDICAL_SCRIBE_OUTPUT_FIELD, START_TIME_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, FAILURE_REASON_FIELD, SETTINGS_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, CHANNEL_DEFINITIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MedicalScribeJobName", MEDICAL_SCRIBE_JOB_NAME_FIELD);
            this.put("MedicalScribeJobStatus", MEDICAL_SCRIBE_JOB_STATUS_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("Media", MEDIA_FIELD);
            this.put("MedicalScribeOutput", MEDICAL_SCRIBE_OUTPUT_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("CompletionTime", COMPLETION_TIME_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("Settings", SETTINGS_FIELD);
            this.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
            this.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String medicalScribeJobName;
    private final String medicalScribeJobStatus;
    private final String languageCode;
    private final Media media;
    private final MedicalScribeOutput medicalScribeOutput;
    private final Instant startTime;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String failureReason;
    private final MedicalScribeSettings settings;
    private final String dataAccessRoleArn;
    private final List<MedicalScribeChannelDefinition> channelDefinitions;
    private final List<Tag> tags;

    private MedicalScribeJob(BuilderImpl builder) {
        this.medicalScribeJobName = builder.medicalScribeJobName;
        this.medicalScribeJobStatus = builder.medicalScribeJobStatus;
        this.languageCode = builder.languageCode;
        this.media = builder.media;
        this.medicalScribeOutput = builder.medicalScribeOutput;
        this.startTime = builder.startTime;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.failureReason = builder.failureReason;
        this.settings = builder.settings;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.channelDefinitions = builder.channelDefinitions;
        this.tags = builder.tags;
    }

    public final String medicalScribeJobName() {
        return this.medicalScribeJobName;
    }

    public final MedicalScribeJobStatus medicalScribeJobStatus() {
        return MedicalScribeJobStatus.fromValue(this.medicalScribeJobStatus);
    }

    public final String medicalScribeJobStatusAsString() {
        return this.medicalScribeJobStatus;
    }

    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Media media() {
        return this.media;
    }

    public final MedicalScribeOutput medicalScribeOutput() {
        return this.medicalScribeOutput;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final MedicalScribeSettings settings() {
        return this.settings;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeJob)) {
            return false;
        }
        MedicalScribeJob other = (MedicalScribeJob)obj;
        return Objects.equals(this.medicalScribeJobName(), other.medicalScribeJobName()) && Objects.equals(this.medicalScribeJobStatusAsString(), other.medicalScribeJobStatusAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.medicalScribeOutput(), other.medicalScribeOutput()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeJob").add("MedicalScribeJobName", (Object)this.medicalScribeJobName()).add("MedicalScribeJobStatus", (Object)this.medicalScribeJobStatusAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Media", (Object)this.media()).add("MedicalScribeOutput", (Object)this.medicalScribeOutput()).add("StartTime", (Object)this.startTime()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("FailureReason", (Object)this.failureReason()).add("Settings", (Object)this.settings()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalScribeJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobName()));
            }
            case "MedicalScribeJobStatus": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobStatusAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "MedicalScribeOutput": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeOutput()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeJob, T> g) {
        return obj -> g.apply((MedicalScribeJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String medicalScribeJobName;
        private String medicalScribeJobStatus;
        private String languageCode;
        private Media media;
        private MedicalScribeOutput medicalScribeOutput;
        private Instant startTime;
        private Instant creationTime;
        private Instant completionTime;
        private String failureReason;
        private MedicalScribeSettings settings;
        private String dataAccessRoleArn;
        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeJob model) {
            this.medicalScribeJobName(model.medicalScribeJobName);
            this.medicalScribeJobStatus(model.medicalScribeJobStatus);
            this.languageCode(model.languageCode);
            this.media(model.media);
            this.medicalScribeOutput(model.medicalScribeOutput);
            this.startTime(model.startTime);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.failureReason(model.failureReason);
            this.settings(model.settings);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.channelDefinitions(model.channelDefinitions);
            this.tags(model.tags);
        }

        public final String getMedicalScribeJobName() {
            return this.medicalScribeJobName;
        }

        public final void setMedicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
        }

        @Override
        public final Builder medicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
            return this;
        }

        public final String getMedicalScribeJobStatus() {
            return this.medicalScribeJobStatus;
        }

        public final void setMedicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
        }

        @Override
        public final Builder medicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
            return this;
        }

        @Override
        public final Builder medicalScribeJobStatus(MedicalScribeJobStatus medicalScribeJobStatus) {
            this.medicalScribeJobStatus(medicalScribeJobStatus == null ? null : medicalScribeJobStatus.toString());
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final MedicalScribeOutput.Builder getMedicalScribeOutput() {
            return this.medicalScribeOutput != null ? this.medicalScribeOutput.toBuilder() : null;
        }

        public final void setMedicalScribeOutput(MedicalScribeOutput.BuilderImpl medicalScribeOutput) {
            this.medicalScribeOutput = medicalScribeOutput != null ? medicalScribeOutput.build() : null;
        }

        @Override
        public final Builder medicalScribeOutput(MedicalScribeOutput medicalScribeOutput) {
            this.medicalScribeOutput = medicalScribeOutput;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final MedicalScribeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(MedicalScribeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(MedicalScribeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (MedicalScribeChannelDefinition)((MedicalScribeChannelDefinition.Builder)MedicalScribeChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MedicalScribeJob build() {
            return new MedicalScribeJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeJob> {
        public Builder medicalScribeJobName(String var1);

        public Builder medicalScribeJobStatus(String var1);

        public Builder medicalScribeJobStatus(MedicalScribeJobStatus var1);

        public Builder languageCode(String var1);

        public Builder languageCode(MedicalScribeLanguageCode var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder medicalScribeOutput(MedicalScribeOutput var1);

        default public Builder medicalScribeOutput(Consumer<MedicalScribeOutput.Builder> medicalScribeOutput) {
            return this.medicalScribeOutput((MedicalScribeOutput)((MedicalScribeOutput.Builder)MedicalScribeOutput.builder().applyMutation(medicalScribeOutput)).build());
        }

        public Builder startTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder settings(MedicalScribeSettings var1);

        default public Builder settings(Consumer<MedicalScribeSettings.Builder> settings) {
            return this.settings((MedicalScribeSettings)((MedicalScribeSettings.Builder)MedicalScribeSettings.builder().applyMutation(settings)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> var1);

        public Builder channelDefinitions(MedicalScribeChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

