/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings;
import software.amazon.awssdk.services.transcribe.model.ChannelDefinition;
import software.amazon.awssdk.services.transcribe.model.ChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCallAnalyticsJobRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, StartCallAnalyticsJobRequest> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAnalyticsJobName").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::callAnalyticsJobName)).setter(StartCallAnalyticsJobRequest.setter(Builder::callAnalyticsJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::media)).setter(StartCallAnalyticsJobRequest.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocation").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::outputLocation)).setter(StartCallAnalyticsJobRequest.setter(Builder::outputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputEncryptionKMSKeyId").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::outputEncryptionKMSKeyId)).setter(StartCallAnalyticsJobRequest.setter(Builder::outputEncryptionKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::dataAccessRoleArn)).setter(StartCallAnalyticsJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<CallAnalyticsJobSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::settings)).setter(StartCallAnalyticsJobRequest.setter(Builder::settings)).constructor(CallAnalyticsJobSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(StartCallAnalyticsJobRequest.getter(StartCallAnalyticsJobRequest::channelDefinitions)).setter(StartCallAnalyticsJobRequest.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD, MEDIA_FIELD, OUTPUT_LOCATION_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SETTINGS_FIELD, CHANNEL_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CallAnalyticsJobName", CALL_ANALYTICS_JOB_NAME_FIELD);
            this.put("Media", MEDIA_FIELD);
            this.put("OutputLocation", OUTPUT_LOCATION_FIELD);
            this.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
            this.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
            this.put("Settings", SETTINGS_FIELD);
            this.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        }
    });
    private final String callAnalyticsJobName;
    private final Media media;
    private final String outputLocation;
    private final String outputEncryptionKMSKeyId;
    private final String dataAccessRoleArn;
    private final CallAnalyticsJobSettings settings;
    private final List<ChannelDefinition> channelDefinitions;

    private StartCallAnalyticsJobRequest(BuilderImpl builder) {
        super(builder);
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.media = builder.media;
        this.outputLocation = builder.outputLocation;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
    }

    public final String callAnalyticsJobName() {
        return this.callAnalyticsJobName;
    }

    public final Media media() {
        return this.media;
    }

    public final String outputLocation() {
        return this.outputLocation;
    }

    public final String outputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final CallAnalyticsJobSettings settings() {
        return this.settings;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCallAnalyticsJobRequest)) {
            return false;
        }
        StartCallAnalyticsJobRequest other = (StartCallAnalyticsJobRequest)((Object)obj);
        return Objects.equals(this.callAnalyticsJobName(), other.callAnalyticsJobName()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.settings(), other.settings()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"StartCallAnalyticsJobRequest").add("CallAnalyticsJobName", (Object)this.callAnalyticsJobName()).add("Media", (Object)this.media()).add("OutputLocation", (Object)this.outputLocation()).add("OutputEncryptionKMSKeyId", (Object)this.outputEncryptionKMSKeyId()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("Settings", (Object)this.settings()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallAnalyticsJobName": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobName()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "OutputEncryptionKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.outputEncryptionKMSKeyId()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartCallAnalyticsJobRequest, T> g) {
        return obj -> g.apply((StartCallAnalyticsJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String callAnalyticsJobName;
        private Media media;
        private String outputLocation;
        private String outputEncryptionKMSKeyId;
        private String dataAccessRoleArn;
        private CallAnalyticsJobSettings settings;
        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCallAnalyticsJobRequest model) {
            super(model);
            this.callAnalyticsJobName(model.callAnalyticsJobName);
            this.media(model.media);
            this.outputLocation(model.outputLocation);
            this.outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.settings(model.settings);
            this.channelDefinitions(model.channelDefinitions);
        }

        public final String getCallAnalyticsJobName() {
            return this.callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputLocation() {
            return this.outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return this.outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final CallAnalyticsJobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(CallAnalyticsJobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(CallAnalyticsJobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (ChannelDefinition)((ChannelDefinition.Builder)ChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCallAnalyticsJobRequest build() {
            return new StartCallAnalyticsJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCallAnalyticsJobRequest> {
        public Builder callAnalyticsJobName(String var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder outputLocation(String var1);

        public Builder outputEncryptionKMSKeyId(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder settings(CallAnalyticsJobSettings var1);

        default public Builder settings(Consumer<CallAnalyticsJobSettings.Builder> settings) {
            return this.settings((CallAnalyticsJobSettings)((CallAnalyticsJobSettings.Builder)CallAnalyticsJobSettings.builder().applyMutation(settings)).build());
        }

        public Builder channelDefinitions(Collection<ChannelDefinition> var1);

        public Builder channelDefinitions(ChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

