/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time range, in milliseconds, between two points in your media file.
 * </p>
 * <p>
 * You can use <code>StartTime</code> and <code>EndTime</code> to search a custom segment. For example, setting
 * <code>StartTime</code> to 10000 and <code>EndTime</code> to 50000 only searches for your specified criteria in the
 * audio contained between the 10,000 millisecond mark and the 50,000 millisecond mark of your media file. You must use
 * <code>StartTime</code> and <code>EndTime</code> as a set; that is, if you include one, you must include both.
 * </p>
 * <p>
 * You can use also <code>First</code> to search from the start of the audio until the time that you specify, or
 * <code>Last</code> to search from the time that you specify until the end of the audio. For example, setting
 * <code>First</code> to 50000 only searches for your specified criteria in the audio contained between the start of the
 * media file to the 50,000 millisecond mark. You can use <code>First</code> and <code>Last</code> independently of each
 * other.
 * </p>
 * <p>
 * If you prefer to use percentage instead of milliseconds, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbsoluteTimeRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AbsoluteTimeRange.Builder, AbsoluteTimeRange> {
    private static final SdkField<Long> START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("StartTime")
            .getter(getter(AbsoluteTimeRange::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Long> END_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("EndTime")
            .getter(getter(AbsoluteTimeRange::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Long> FIRST_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("First")
            .getter(getter(AbsoluteTimeRange::first)).setter(setter(Builder::first))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("First").build()).build();

    private static final SdkField<Long> LAST_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Last")
            .getter(getter(AbsoluteTimeRange::last)).setter(setter(Builder::last))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Last").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, FIRST_FIELD, LAST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StartTime", START_TIME_FIELD);
                    put("EndTime", END_TIME_FIELD);
                    put("First", FIRST_FIELD);
                    put("Last", LAST_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long startTime;

    private final Long endTime;

    private final Long first;

    private final Long last;

    private AbsoluteTimeRange(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.first = builder.first;
        this.last = builder.last;
    }

    /**
     * <p>
     * The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your audio. If
     * you include <code>StartTime</code> in your request, you must also include <code>EndTime</code>.
     * </p>
     * 
     * @return The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your
     *         audio. If you include <code>StartTime</code> in your request, you must also include <code>EndTime</code>.
     */
    public final Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your audio. If
     * you include <code>EndTime</code> in your request, you must also include <code>StartTime</code>.
     * </p>
     * 
     * @return The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your
     *         audio. If you include <code>EndTime</code> in your request, you must also include <code>StartTime</code>.
     */
    public final Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time, in milliseconds, from the start of your media file until the specified value. Amazon Transcribe
     * searches for your specified criteria in this time segment.
     * </p>
     * 
     * @return The time, in milliseconds, from the start of your media file until the specified value. Amazon Transcribe
     *         searches for your specified criteria in this time segment.
     */
    public final Long first() {
        return first;
    }

    /**
     * <p>
     * The time, in milliseconds, from the specified value until the end of your media file. Amazon Transcribe searches
     * for your specified criteria in this time segment.
     * </p>
     * 
     * @return The time, in milliseconds, from the specified value until the end of your media file. Amazon Transcribe
     *         searches for your specified criteria in this time segment.
     */
    public final Long last() {
        return last;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(first());
        hashCode = 31 * hashCode + Objects.hashCode(last());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbsoluteTimeRange)) {
            return false;
        }
        AbsoluteTimeRange other = (AbsoluteTimeRange) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(first(), other.first()) && Objects.equals(last(), other.last());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbsoluteTimeRange").add("StartTime", startTime()).add("EndTime", endTime())
                .add("First", first()).add("Last", last()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "First":
            return Optional.ofNullable(clazz.cast(first()));
        case "Last":
            return Optional.ofNullable(clazz.cast(last()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AbsoluteTimeRange, T> g) {
        return obj -> g.apply((AbsoluteTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbsoluteTimeRange> {
        /**
         * <p>
         * The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your audio.
         * If you include <code>StartTime</code> in your request, you must also include <code>EndTime</code>.
         * </p>
         * 
         * @param startTime
         *        The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your
         *        audio. If you include <code>StartTime</code> in your request, you must also include
         *        <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your audio.
         * If you include <code>EndTime</code> in your request, you must also include <code>StartTime</code>.
         * </p>
         * 
         * @param endTime
         *        The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your
         *        audio. If you include <code>EndTime</code> in your request, you must also include
         *        <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The time, in milliseconds, from the start of your media file until the specified value. Amazon Transcribe
         * searches for your specified criteria in this time segment.
         * </p>
         * 
         * @param first
         *        The time, in milliseconds, from the start of your media file until the specified value. Amazon
         *        Transcribe searches for your specified criteria in this time segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder first(Long first);

        /**
         * <p>
         * The time, in milliseconds, from the specified value until the end of your media file. Amazon Transcribe
         * searches for your specified criteria in this time segment.
         * </p>
         * 
         * @param last
         *        The time, in milliseconds, from the specified value until the end of your media file. Amazon
         *        Transcribe searches for your specified criteria in this time segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder last(Long last);
    }

    static final class BuilderImpl implements Builder {
        private Long startTime;

        private Long endTime;

        private Long first;

        private Long last;

        private BuilderImpl() {
        }

        private BuilderImpl(AbsoluteTimeRange model) {
            startTime(model.startTime);
            endTime(model.endTime);
            first(model.first);
            last(model.last);
        }

        public final Long getStartTime() {
            return startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getFirst() {
            return first;
        }

        public final void setFirst(Long first) {
            this.first = first;
        }

        @Override
        public final Builder first(Long first) {
            this.first = first;
            return this;
        }

        public final Long getLast() {
            return last;
        }

        public final void setLast(Long last) {
            this.last = last;
        }

        @Override
        public final Builder last(Long last) {
            this.last = last;
            return this;
        }

        @Override
        public AbsoluteTimeRange build() {
            return new AbsoluteTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
