/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first participant
 * to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel) and
 * <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it's the agent speaking).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelDefinition.Builder, ChannelDefinition> {
    private static final SdkField<Integer> CHANNEL_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChannelId").getter(getter(ChannelDefinition::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(ChannelDefinition::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            PARTICIPANT_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ChannelId", CHANNEL_ID_FIELD);
                    put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer channelId;

    private final String participantRole;

    private ChannelDefinition(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.participantRole = builder.participantRole;
    }

    /**
     * <p>
     * Specify the audio channel you want to define.
     * </p>
     * 
     * @return Specify the audio channel you want to define.
     */
    public final Integer channelId() {
        return channelId;
    }

    /**
     * <p>
     * Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
     *         participants.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
     *         participants.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelDefinition)) {
            return false;
        }
        ChannelDefinition other = (ChannelDefinition) obj;
        return Objects.equals(channelId(), other.channelId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelDefinition").add("ChannelId", channelId())
                .add("ParticipantRole", participantRoleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChannelDefinition, T> g) {
        return obj -> g.apply((ChannelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelDefinition> {
        /**
         * <p>
         * Specify the audio channel you want to define.
         * </p>
         * 
         * @param channelId
         *        Specify the audio channel you want to define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(Integer channelId);

        /**
         * <p>
         * Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
         * participants.
         * </p>
         * 
         * @param participantRole
         *        Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
         *        participants.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
         * participants.
         * </p>
         * 
         * @param participantRole
         *        Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both
         *        participants.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);
    }

    static final class BuilderImpl implements Builder {
        private Integer channelId;

        private String participantRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelDefinition model) {
            channelId(model.channelId);
            participantRole(model.participantRole);
        }

        public final Integer getChannelId() {
            return channelId;
        }

        public final void setChannelId(Integer channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(Integer channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        @Override
        public ChannelDefinition build() {
            return new ChannelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
