/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLanguageModelResponse extends TranscribeResponse implements
        ToCopyableBuilder<CreateLanguageModelResponse.Builder, CreateLanguageModelResponse> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateLanguageModelResponse::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseModelName").getter(getter(CreateLanguageModelResponse::baseModelNameAsString))
            .setter(setter(Builder::baseModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateLanguageModelResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(CreateLanguageModelResponse::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<String> MODEL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelStatus").getter(getter(CreateLanguageModelResponse::modelStatusAsString))
            .setter(setter(Builder::modelStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            BASE_MODEL_NAME_FIELD, MODEL_NAME_FIELD, INPUT_DATA_CONFIG_FIELD, MODEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LanguageCode", LANGUAGE_CODE_FIELD);
                    put("BaseModelName", BASE_MODEL_NAME_FIELD);
                    put("ModelName", MODEL_NAME_FIELD);
                    put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
                    put("ModelStatus", MODEL_STATUS_FIELD);
                }
            });

    private final String languageCode;

    private final String baseModelName;

    private final String modelName;

    private final InputDataConfig inputDataConfig;

    private final String modelStatus;

    private CreateLanguageModelResponse(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.baseModelName = builder.baseModelName;
        this.modelName = builder.modelName;
        this.inputDataConfig = builder.inputDataConfig;
        this.modelStatus = builder.modelStatus;
    }

    /**
     * <p>
     * The language code you selected for your custom language model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CLMLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code you selected for your custom language model.
     * @see CLMLanguageCode
     */
    public final CLMLanguageCode languageCode() {
        return CLMLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code you selected for your custom language model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link CLMLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code you selected for your custom language model.
     * @see CLMLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Transcribe standard language model, or base model, you specified when creating your custom language
     * model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseModelName}
     * will return {@link BaseModelName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseModelNameAsString}.
     * </p>
     * 
     * @return The Amazon Transcribe standard language model, or base model, you specified when creating your custom
     *         language model.
     * @see BaseModelName
     */
    public final BaseModelName baseModelName() {
        return BaseModelName.fromValue(baseModelName);
    }

    /**
     * <p>
     * The Amazon Transcribe standard language model, or base model, you specified when creating your custom language
     * model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseModelName}
     * will return {@link BaseModelName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseModelNameAsString}.
     * </p>
     * 
     * @return The Amazon Transcribe standard language model, or base model, you specified when creating your custom
     *         language model.
     * @see BaseModelName
     */
    public final String baseModelNameAsString() {
        return baseModelName;
    }

    /**
     * <p>
     * The name of your custom language model.
     * </p>
     * 
     * @return The name of your custom language model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for your training
     * (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.
     * </p>
     * 
     * @return Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for your
     *         training (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model is ready
     * to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelStatus} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelStatusAsString}.
     * </p>
     * 
     * @return The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model
     *         is ready to use.
     * @see ModelStatus
     */
    public final ModelStatus modelStatus() {
        return ModelStatus.fromValue(modelStatus);
    }

    /**
     * <p>
     * The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model is ready
     * to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelStatus} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelStatusAsString}.
     * </p>
     * 
     * @return The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model
     *         is ready to use.
     * @see ModelStatus
     */
    public final String modelStatusAsString() {
        return modelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLanguageModelResponse)) {
            return false;
        }
        CreateLanguageModelResponse other = (CreateLanguageModelResponse) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(baseModelNameAsString(), other.baseModelNameAsString())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(modelStatusAsString(), other.modelStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLanguageModelResponse").add("LanguageCode", languageCodeAsString())
                .add("BaseModelName", baseModelNameAsString()).add("ModelName", modelName())
                .add("InputDataConfig", inputDataConfig()).add("ModelStatus", modelStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "BaseModelName":
            return Optional.ofNullable(clazz.cast(baseModelNameAsString()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "ModelStatus":
            return Optional.ofNullable(clazz.cast(modelStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLanguageModelResponse, T> g) {
        return obj -> g.apply((CreateLanguageModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateLanguageModelResponse> {
        /**
         * <p>
         * The language code you selected for your custom language model.
         * </p>
         * 
         * @param languageCode
         *        The language code you selected for your custom language model.
         * @see CLMLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CLMLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code you selected for your custom language model.
         * </p>
         * 
         * @param languageCode
         *        The language code you selected for your custom language model.
         * @see CLMLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CLMLanguageCode
         */
        Builder languageCode(CLMLanguageCode languageCode);

        /**
         * <p>
         * The Amazon Transcribe standard language model, or base model, you specified when creating your custom
         * language model.
         * </p>
         * 
         * @param baseModelName
         *        The Amazon Transcribe standard language model, or base model, you specified when creating your custom
         *        language model.
         * @see BaseModelName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseModelName
         */
        Builder baseModelName(String baseModelName);

        /**
         * <p>
         * The Amazon Transcribe standard language model, or base model, you specified when creating your custom
         * language model.
         * </p>
         * 
         * @param baseModelName
         *        The Amazon Transcribe standard language model, or base model, you specified when creating your custom
         *        language model.
         * @see BaseModelName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseModelName
         */
        Builder baseModelName(BaseModelName baseModelName);

        /**
         * <p>
         * The name of your custom language model.
         * </p>
         * 
         * @param modelName
         *        The name of your custom language model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for your
         * training (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.
         * </p>
         * 
         * @param inputDataConfig
         *        Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for
         *        your training (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for your
         * training (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model is
         * ready to use.
         * </p>
         * 
         * @param modelStatus
         *        The status of your custom language model. When the status displays as <code>COMPLETED</code>, your
         *        model is ready to use.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder modelStatus(String modelStatus);

        /**
         * <p>
         * The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model is
         * ready to use.
         * </p>
         * 
         * @param modelStatus
         *        The status of your custom language model. When the status displays as <code>COMPLETED</code>, your
         *        model is ready to use.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder modelStatus(ModelStatus modelStatus);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String languageCode;

        private String baseModelName;

        private String modelName;

        private InputDataConfig inputDataConfig;

        private String modelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLanguageModelResponse model) {
            super(model);
            languageCode(model.languageCode);
            baseModelName(model.baseModelName);
            modelName(model.modelName);
            inputDataConfig(model.inputDataConfig);
            modelStatus(model.modelStatus);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(CLMLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getBaseModelName() {
            return baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        @Override
        public final Builder baseModelName(BaseModelName baseModelName) {
            this.baseModelName(baseModelName == null ? null : baseModelName.toString());
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getModelStatus() {
            return modelStatus;
        }

        public final void setModelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
        }

        @Override
        public final Builder modelStatus(String modelStatus) {
            this.modelStatus = modelStatus;
            return this;
        }

        @Override
        public final Builder modelStatus(ModelStatus modelStatus) {
            this.modelStatus(modelStatus == null ? null : modelStatus.toString());
            return this;
        }

        @Override
        public CreateLanguageModelResponse build() {
            return new CreateLanguageModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
