/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and
 * permissions to access this location.
 * </p>
 * <p>
 * When using <code>InputDataConfig</code>, you must include these sub-parameters: <code>S3Uri</code> and
 * <code>DataAccessRoleArn</code>. You can optionally include <code>TuningDataS3Uri</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDataConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputDataConfig.Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(InputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> TUNING_DATA_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TuningDataS3Uri").getter(getter(InputDataConfig::tuningDataS3Uri))
            .setter(setter(Builder::tuningDataS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningDataS3Uri").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(InputDataConfig::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            TUNING_DATA_S3_URI_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("S3Uri", S3_URI_FIELD);
                    put("TuningDataS3Uri", TUNING_DATA_S3_URI_FIELD);
                    put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String tuningDataS3Uri;

    private final String dataAccessRoleArn;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.tuningDataS3Uri = builder.tuningDataS3Uri;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon S3 location (URI) of the text files you want to use to train your custom language model.
     * </p>
     * <p>
     * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-training-data/</code>
     * </p>
     * 
     * @return The Amazon S3 location (URI) of the text files you want to use to train your custom language model.</p>
     *         <p>
     *         Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-training-data/</code>
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.
     * </p>
     * <p>
     * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/</code>
     * </p>
     * 
     * @return The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.</p>
     *         <p>
     *         Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/</code>
     */
    public final String tuningDataS3Uri() {
        return tuningDataS3Uri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified
     * Amazon S3 location, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files. If the role that you specify doesn’t have the appropriate permissions to
     *         access the specified Amazon S3 location, your request fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(tuningDataS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(tuningDataS3Uri(), other.tuningDataS3Uri())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDataConfig").add("S3Uri", s3Uri()).add("TuningDataS3Uri", tuningDataS3Uri())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "TuningDataS3Uri":
            return Optional.ofNullable(clazz.cast(tuningDataS3Uri()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDataConfig> {
        /**
         * <p>
         * The Amazon S3 location (URI) of the text files you want to use to train your custom language model.
         * </p>
         * <p>
         * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-training-data/</code>
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 location (URI) of the text files you want to use to train your custom language
         *        model.</p>
         *        <p>
         *        Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-training-data/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.
         * </p>
         * <p>
         * Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/</code>
         * </p>
         * 
         * @param tuningDataS3Uri
         *        The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.</p>
         *        <p>
         *        Here's an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningDataS3Uri(String tuningDataS3Uri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files. If the role that you specify doesn’t have the appropriate permissions to access
         * the specified Amazon S3 location, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files. If the role that you specify doesn’t have the appropriate permissions to
         *        access the specified Amazon S3 location, your request fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String tuningDataS3Uri;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            s3Uri(model.s3Uri);
            tuningDataS3Uri(model.tuningDataS3Uri);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getTuningDataS3Uri() {
            return tuningDataS3Uri;
        }

        public final void setTuningDataS3Uri(String tuningDataS3Uri) {
            this.tuningDataS3Uri = tuningDataS3Uri;
        }

        @Override
        public final Builder tuningDataS3Uri(String tuningDataS3Uri) {
            this.tuningDataS3Uri = tuningDataS3Uri;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
