/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Flag the presence or absence of interruptions in your Call Analytics transcription output.
 * </p>
 * <p>
 * Rules using <code>InterruptionFilter</code> are designed to match:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Instances where an agent interrupts a customer
 * </p>
 * </li>
 * <li>
 * <p>
 * Instances where a customer interrupts an agent
 * </p>
 * </li>
 * <li>
 * <p>
 * Either participant interrupting the other
 * </p>
 * </li>
 * <li>
 * <p>
 * A lack of interruptions
 * </p>
 * </li>
 * </ul>
 * <p>
 * See <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch">Rule
 * criteria for post-call categories</a> for usage examples.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterruptionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<InterruptionFilter.Builder, InterruptionFilter> {
    private static final SdkField<Long> THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Threshold")
            .getter(getter(InterruptionFilter::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(InterruptionFilter::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<AbsoluteTimeRange> ABSOLUTE_TIME_RANGE_FIELD = SdkField
            .<AbsoluteTimeRange> builder(MarshallingType.SDK_POJO).memberName("AbsoluteTimeRange")
            .getter(getter(InterruptionFilter::absoluteTimeRange)).setter(setter(Builder::absoluteTimeRange))
            .constructor(AbsoluteTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTimeRange").build()).build();

    private static final SdkField<RelativeTimeRange> RELATIVE_TIME_RANGE_FIELD = SdkField
            .<RelativeTimeRange> builder(MarshallingType.SDK_POJO).memberName("RelativeTimeRange")
            .getter(getter(InterruptionFilter::relativeTimeRange)).setter(setter(Builder::relativeTimeRange))
            .constructor(RelativeTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeTimeRange").build()).build();

    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negate").getter(getter(InterruptionFilter::negate)).setter(setter(Builder::negate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THRESHOLD_FIELD,
            PARTICIPANT_ROLE_FIELD, ABSOLUTE_TIME_RANGE_FIELD, RELATIVE_TIME_RANGE_FIELD, NEGATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Threshold", THRESHOLD_FIELD);
                    put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
                    put("AbsoluteTimeRange", ABSOLUTE_TIME_RANGE_FIELD);
                    put("RelativeTimeRange", RELATIVE_TIME_RANGE_FIELD);
                    put("Negate", NEGATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long threshold;

    private final String participantRole;

    private final AbsoluteTimeRange absoluteTimeRange;

    private final RelativeTimeRange relativeTimeRange;

    private final Boolean negate;

    private InterruptionFilter(BuilderImpl builder) {
        this.threshold = builder.threshold;
        this.participantRole = builder.participantRole;
        this.absoluteTimeRange = builder.absoluteTimeRange;
        this.relativeTimeRange = builder.relativeTimeRange;
        this.negate = builder.negate;
    }

    /**
     * <p>
     * Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains more
     * than 10,000 milliseconds of interruptions.
     * </p>
     * 
     * @return Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains
     *         more than 10,000 milliseconds of interruptions.
     */
    public final Long threshold() {
        return threshold;
    }

    /**
     * <p>
     * Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
     * participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
     *         participants.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
     * participants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
     *         participants.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search for an
     * interruption. See for more detail.
     * </p>
     * 
     * @return Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to
     *         search for an interruption. See for more detail.
     */
    public final AbsoluteTimeRange absoluteTimeRange() {
        return absoluteTimeRange;
    }

    /**
     * <p>
     * Makes it possible to specify a time range (in percentage) in your media file, during which you want to search for
     * an interruption. See for more detail.
     * </p>
     * 
     * @return Makes it possible to specify a time range (in percentage) in your media file, during which you want to
     *         search for an interruption. See for more detail.
     */
    public final RelativeTimeRange relativeTimeRange() {
        return relativeTimeRange;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> to flag speech that does not contain interruptions. Set to <code>FALSE</code> to flag
     * speech that contains interruptions.
     * </p>
     * 
     * @return Set to <code>TRUE</code> to flag speech that does not contain interruptions. Set to <code>FALSE</code> to
     *         flag speech that contains interruptions.
     */
    public final Boolean negate() {
        return negate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(absoluteTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(relativeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(negate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterruptionFilter)) {
            return false;
        }
        InterruptionFilter other = (InterruptionFilter) obj;
        return Objects.equals(threshold(), other.threshold())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(absoluteTimeRange(), other.absoluteTimeRange())
                && Objects.equals(relativeTimeRange(), other.relativeTimeRange()) && Objects.equals(negate(), other.negate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterruptionFilter").add("Threshold", threshold())
                .add("ParticipantRole", participantRoleAsString()).add("AbsoluteTimeRange", absoluteTimeRange())
                .add("RelativeTimeRange", relativeTimeRange()).add("Negate", negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "AbsoluteTimeRange":
            return Optional.ofNullable(clazz.cast(absoluteTimeRange()));
        case "RelativeTimeRange":
            return Optional.ofNullable(clazz.cast(relativeTimeRange()));
        case "Negate":
            return Optional.ofNullable(clazz.cast(negate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InterruptionFilter, T> g) {
        return obj -> g.apply((InterruptionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterruptionFilter> {
        /**
         * <p>
         * Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains
         * more than 10,000 milliseconds of interruptions.
         * </p>
         * 
         * @param threshold
         *        Specify the duration of the interruptions in milliseconds. For example, you can flag speech that
         *        contains more than 10,000 milliseconds of interruptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Long threshold);

        /**
         * <p>
         * Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
         * participants.
         * </p>
         * 
         * @param participantRole
         *        Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying
         *        both participants.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both
         * participants.
         * </p>
         * 
         * @param participantRole
         *        Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying
         *        both participants.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search
         * for an interruption. See for more detail.
         * </p>
         * 
         * @param absoluteTimeRange
         *        Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to
         *        search for an interruption. See for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange);

        /**
         * <p>
         * Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search
         * for an interruption. See for more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AbsoluteTimeRange.Builder} avoiding the
         * need to create one manually via {@link AbsoluteTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbsoluteTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #absoluteTimeRange(AbsoluteTimeRange)}.
         * 
         * @param absoluteTimeRange
         *        a consumer that will call methods on {@link AbsoluteTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #absoluteTimeRange(AbsoluteTimeRange)
         */
        default Builder absoluteTimeRange(Consumer<AbsoluteTimeRange.Builder> absoluteTimeRange) {
            return absoluteTimeRange(AbsoluteTimeRange.builder().applyMutation(absoluteTimeRange).build());
        }

        /**
         * <p>
         * Makes it possible to specify a time range (in percentage) in your media file, during which you want to search
         * for an interruption. See for more detail.
         * </p>
         * 
         * @param relativeTimeRange
         *        Makes it possible to specify a time range (in percentage) in your media file, during which you want to
         *        search for an interruption. See for more detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeTimeRange(RelativeTimeRange relativeTimeRange);

        /**
         * <p>
         * Makes it possible to specify a time range (in percentage) in your media file, during which you want to search
         * for an interruption. See for more detail.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelativeTimeRange.Builder} avoiding the
         * need to create one manually via {@link RelativeTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelativeTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #relativeTimeRange(RelativeTimeRange)}.
         * 
         * @param relativeTimeRange
         *        a consumer that will call methods on {@link RelativeTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeTimeRange(RelativeTimeRange)
         */
        default Builder relativeTimeRange(Consumer<RelativeTimeRange.Builder> relativeTimeRange) {
            return relativeTimeRange(RelativeTimeRange.builder().applyMutation(relativeTimeRange).build());
        }

        /**
         * <p>
         * Set to <code>TRUE</code> to flag speech that does not contain interruptions. Set to <code>FALSE</code> to
         * flag speech that contains interruptions.
         * </p>
         * 
         * @param negate
         *        Set to <code>TRUE</code> to flag speech that does not contain interruptions. Set to <code>FALSE</code>
         *        to flag speech that contains interruptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negate(Boolean negate);
    }

    static final class BuilderImpl implements Builder {
        private Long threshold;

        private String participantRole;

        private AbsoluteTimeRange absoluteTimeRange;

        private RelativeTimeRange relativeTimeRange;

        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(InterruptionFilter model) {
            threshold(model.threshold);
            participantRole(model.participantRole);
            absoluteTimeRange(model.absoluteTimeRange);
            relativeTimeRange(model.relativeTimeRange);
            negate(model.negate);
        }

        public final Long getThreshold() {
            return threshold;
        }

        public final void setThreshold(Long threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Long threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final AbsoluteTimeRange.Builder getAbsoluteTimeRange() {
            return absoluteTimeRange != null ? absoluteTimeRange.toBuilder() : null;
        }

        public final void setAbsoluteTimeRange(AbsoluteTimeRange.BuilderImpl absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange != null ? absoluteTimeRange.build() : null;
        }

        @Override
        public final Builder absoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
            this.absoluteTimeRange = absoluteTimeRange;
            return this;
        }

        public final RelativeTimeRange.Builder getRelativeTimeRange() {
            return relativeTimeRange != null ? relativeTimeRange.toBuilder() : null;
        }

        public final void setRelativeTimeRange(RelativeTimeRange.BuilderImpl relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange != null ? relativeTimeRange.build() : null;
        }

        @Override
        public final Builder relativeTimeRange(RelativeTimeRange relativeTimeRange) {
            this.relativeTimeRange = relativeTimeRange;
            return this;
        }

        public final Boolean getNegate() {
            return negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        @Override
        public InterruptionFilter build() {
            return new InterruptionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
