/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows additional optional settings in your request, including channel identification, alternative transcriptions,
 * and speaker partitioning. You can use that to apply custom vocabularies to your medical transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalTranscriptionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalTranscriptionSetting.Builder, MedicalTranscriptionSetting> {
    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabels").getter(getter(MedicalTranscriptionSetting::showSpeakerLabels))
            .setter(setter(Builder::showSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()).build();

    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSpeakerLabels").getter(getter(MedicalTranscriptionSetting::maxSpeakerLabels))
            .setter(setter(Builder::maxSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()).build();

    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChannelIdentification").getter(getter(MedicalTranscriptionSetting::channelIdentification))
            .setter(setter(Builder::channelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build())
            .build();

    private static final SdkField<Boolean> SHOW_ALTERNATIVES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowAlternatives").getter(getter(MedicalTranscriptionSetting::showAlternatives))
            .setter(setter(Builder::showAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAlternatives").build()).build();

    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAlternatives").getter(getter(MedicalTranscriptionSetting::maxAlternatives))
            .setter(setter(Builder::maxAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()).build();

    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(MedicalTranscriptionSetting::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHOW_SPEAKER_LABELS_FIELD,
            MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, SHOW_ALTERNATIVES_FIELD, MAX_ALTERNATIVES_FIELD,
            VOCABULARY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ShowSpeakerLabels", SHOW_SPEAKER_LABELS_FIELD);
                    put("MaxSpeakerLabels", MAX_SPEAKER_LABELS_FIELD);
                    put("ChannelIdentification", CHANNEL_IDENTIFICATION_FIELD);
                    put("ShowAlternatives", SHOW_ALTERNATIVES_FIELD);
                    put("MaxAlternatives", MAX_ALTERNATIVES_FIELD);
                    put("VocabularyName", VOCABULARY_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean showSpeakerLabels;

    private final Integer maxSpeakerLabels;

    private final Boolean channelIdentification;

    private final Boolean showAlternatives;

    private final Integer maxAlternatives;

    private final String vocabularyName;

    private MedicalTranscriptionSetting(BuilderImpl builder) {
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.showAlternatives = builder.showAlternatives;
        this.maxAlternatives = builder.maxAlternatives;
        this.vocabularyName = builder.vocabularyName;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *         <code>MaxSpeakerLabels</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */
    public final Boolean showSpeakerLabels() {
        return showSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @return Specify the maximum number of speakers you want to partition in your media.</p>
     *         <p>
     *         Note that if your media contains more speakers than the specified number, multiple speakers are treated
     *         as a single speaker.
     *         </p>
     *         <p>
     *         If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *         field to true.
     */
    public final Integer maxSpeakerLabels() {
        return maxSpeakerLabels;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *         continuous manner and your transcript does not separate the speech by channel.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */
    public final Boolean channelIdentification() {
        return channelIdentification;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return To include alternative transcriptions within your transcription output, include
     *         <code>ShowAlternatives</code> in your transcription request.</p>
     *         <p>
     *         If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which
     *         is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */
    public final Boolean showAlternatives() {
        return showAlternatives;
    }

    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
     * Medical, only the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include
     *         in your transcript.</p>
     *         <p>
     *         If you select a number greater than the number of alternative transcriptions generated by Amazon
     *         Transcribe Medical, only the actual number of alternative transcriptions are included.
     *         </p>
     *         <p>
     *         If you include <code>MaxAlternatives</code> in your request, you must also include
     *         <code>ShowAlternatives</code> with a value of <code>true</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */
    public final Integer maxAlternatives() {
        return maxAlternatives;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * The language of the specified custom vocabulary must match the language code that you specify in your
     * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or
     * warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for
     * Amazon Transcribe Medical.
     * </p>
     * 
     * @return The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     *         vocabulary names are case sensitive.</p>
     *         <p>
     *         The language of the specified custom vocabulary must match the language code that you specify in your
     *         transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no
     *         errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid
     *         language for Amazon Transcribe Medical.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(showAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscriptionSetting)) {
            return false;
        }
        MedicalTranscriptionSetting other = (MedicalTranscriptionSetting) obj;
        return Objects.equals(showSpeakerLabels(), other.showSpeakerLabels())
                && Objects.equals(maxSpeakerLabels(), other.maxSpeakerLabels())
                && Objects.equals(channelIdentification(), other.channelIdentification())
                && Objects.equals(showAlternatives(), other.showAlternatives())
                && Objects.equals(maxAlternatives(), other.maxAlternatives())
                && Objects.equals(vocabularyName(), other.vocabularyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalTranscriptionSetting").add("ShowSpeakerLabels", showSpeakerLabels())
                .add("MaxSpeakerLabels", maxSpeakerLabels()).add("ChannelIdentification", channelIdentification())
                .add("ShowAlternatives", showAlternatives()).add("MaxAlternatives", maxAlternatives())
                .add("VocabularyName", vocabularyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShowSpeakerLabels":
            return Optional.ofNullable(clazz.cast(showSpeakerLabels()));
        case "MaxSpeakerLabels":
            return Optional.ofNullable(clazz.cast(maxSpeakerLabels()));
        case "ChannelIdentification":
            return Optional.ofNullable(clazz.cast(channelIdentification()));
        case "ShowAlternatives":
            return Optional.ofNullable(clazz.cast(showAlternatives()));
        case "MaxAlternatives":
            return Optional.ofNullable(clazz.cast(maxAlternatives()));
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscriptionSetting, T> g) {
        return obj -> g.apply((MedicalTranscriptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalTranscriptionSetting> {
        /**
         * <p>
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
         * speech from individual speakers in your media file.
         * </p>
         * <p>
         * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         * <code>MaxSpeakerLabels</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         * (diarization)</a>.
         * </p>
         * 
         * @param showSpeakerLabels
         *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels
         *        the speech from individual speakers in your media file.</p>
         *        <p>
         *        If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         *        <code>MaxSpeakerLabels</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         *        (diarization)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabels(Boolean showSpeakerLabels);

        /**
         * <p>
         * Specify the maximum number of speakers you want to partition in your media.
         * </p>
         * <p>
         * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
         * single speaker.
         * </p>
         * <p>
         * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field
         * to true.
         * </p>
         * 
         * @param maxSpeakerLabels
         *        Specify the maximum number of speakers you want to partition in your media.</p>
         *        <p>
         *        Note that if your media contains more speakers than the specified number, multiple speakers are
         *        treated as a single speaker.
         *        </p>
         *        <p>
         *        If you specify the <code>MaxSpeakerLabels</code> field, you must set the
         *        <code>ShowSpeakerLabels</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeakerLabels(Integer maxSpeakerLabels);

        /**
         * <p>
         * Enables channel identification in multi-channel audio.
         * </p>
         * <p>
         * Channel identification transcribes the audio on each channel independently, then appends the output for each
         * channel into one transcript.
         * </p>
         * <p>
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
         * continuous manner and your transcript does not separate the speech by channel.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.
         * </p>
         * 
         * @param channelIdentification
         *        Enables channel identification in multi-channel audio.</p>
         *        <p>
         *        Channel identification transcribes the audio on each channel independently, then appends the output
         *        for each channel into one transcript.
         *        </p>
         *        <p>
         *        If you have multi-channel audio and do not enable channel identification, your audio is transcribed in
         *        a continuous manner and your transcript does not separate the speech by channel.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
         *        audio</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentification(Boolean channelIdentification);

        /**
         * <p>
         * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code>
         * in your transcription request.
         * </p>
         * <p>
         * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is
         * the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
         * </p>
         * 
         * @param showAlternatives
         *        To include alternative transcriptions within your transcription output, include
         *        <code>ShowAlternatives</code> in your transcription request.</p>
         *        <p>
         *        If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>,
         *        which is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to
         *        generate.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
         *        transcriptions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showAlternatives(Boolean showAlternatives);

        /**
         * <p>
         * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in
         * your transcript.
         * </p>
         * <p>
         * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
         * Medical, only the actual number of alternative transcriptions are included.
         * </p>
         * <p>
         * If you include <code>MaxAlternatives</code> in your request, you must also include
         * <code>ShowAlternatives</code> with a value of <code>true</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
         * </p>
         * 
         * @param maxAlternatives
         *        Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to
         *        include in your transcript.</p>
         *        <p>
         *        If you select a number greater than the number of alternative transcriptions generated by Amazon
         *        Transcribe Medical, only the actual number of alternative transcriptions are included.
         *        </p>
         *        <p>
         *        If you include <code>MaxAlternatives</code> in your request, you must also include
         *        <code>ShowAlternatives</code> with a value of <code>true</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
         *        transcriptions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAlternatives(Integer maxAlternatives);

        /**
         * <p>
         * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
         * vocabulary names are case sensitive.
         * </p>
         * <p>
         * The language of the specified custom vocabulary must match the language code that you specify in your
         * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no
         * errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid
         * language for Amazon Transcribe Medical.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom vocabulary you want to use when processing your medical transcription job.
         *        Custom vocabulary names are case sensitive.</p>
         *        <p>
         *        The language of the specified custom vocabulary must match the language code that you specify in your
         *        transcription request. If the languages do not match, the custom vocabulary isn't applied. There are
         *        no errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only
         *        valid language for Amazon Transcribe Medical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean showSpeakerLabels;

        private Integer maxSpeakerLabels;

        private Boolean channelIdentification;

        private Boolean showAlternatives;

        private Integer maxAlternatives;

        private String vocabularyName;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscriptionSetting model) {
            showSpeakerLabels(model.showSpeakerLabels);
            maxSpeakerLabels(model.maxSpeakerLabels);
            channelIdentification(model.channelIdentification);
            showAlternatives(model.showAlternatives);
            maxAlternatives(model.maxAlternatives);
            vocabularyName(model.vocabularyName);
        }

        public final Boolean getShowSpeakerLabels() {
            return showSpeakerLabels;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final Integer getMaxSpeakerLabels() {
            return maxSpeakerLabels;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final Boolean getChannelIdentification() {
            return channelIdentification;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final Boolean getShowAlternatives() {
            return showAlternatives;
        }

        public final void setShowAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
        }

        @Override
        public final Builder showAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
            return this;
        }

        public final Integer getMaxAlternatives() {
            return maxAlternatives;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        @Override
        public MedicalTranscriptionSetting build() {
            return new MedicalTranscriptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
