/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows additional optional settings in your request, including channel identification, alternative transcriptions,
 * and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Settings implements SdkPojo, Serializable, ToCopyableBuilder<Settings.Builder, Settings> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(Settings::vocabularyName)).setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowSpeakerLabels").getter(getter(Settings::showSpeakerLabels))
            .setter(setter(Builder::showSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()).build();

    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSpeakerLabels").getter(getter(Settings::maxSpeakerLabels)).setter(setter(Builder::maxSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()).build();

    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ChannelIdentification").getter(getter(Settings::channelIdentification))
            .setter(setter(Builder::channelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build())
            .build();

    private static final SdkField<Boolean> SHOW_ALTERNATIVES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowAlternatives").getter(getter(Settings::showAlternatives)).setter(setter(Builder::showAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAlternatives").build()).build();

    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAlternatives").getter(getter(Settings::maxAlternatives)).setter(setter(Builder::maxAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(Settings::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod").getter(getter(Settings::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            SHOW_SPEAKER_LABELS_FIELD, MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, SHOW_ALTERNATIVES_FIELD,
            MAX_ALTERNATIVES_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VocabularyName", VOCABULARY_NAME_FIELD);
                    put("ShowSpeakerLabels", SHOW_SPEAKER_LABELS_FIELD);
                    put("MaxSpeakerLabels", MAX_SPEAKER_LABELS_FIELD);
                    put("ChannelIdentification", CHANNEL_IDENTIFICATION_FIELD);
                    put("ShowAlternatives", SHOW_ALTERNATIVES_FIELD);
                    put("MaxAlternatives", MAX_ALTERNATIVES_FIELD);
                    put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
                    put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String vocabularyName;

    private final Boolean showSpeakerLabels;

    private final Integer maxSpeakerLabels;

    private final Boolean channelIdentification;

    private final Boolean showAlternatives;

    private final Integer maxAlternatives;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private Settings(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.showAlternatives = builder.showAlternatives;
        this.maxAlternatives = builder.maxAlternatives;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to use in your transcription job request. This name is case sensitive,
     * cannot contain spaces, and must be unique within an Amazon Web Services account.
     * </p>
     * 
     * @return The name of the custom vocabulary you want to use in your transcription job request. This name is case
     *         sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *         <code>MaxSpeakerLabels</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */
    public final Boolean showSpeakerLabels() {
        return showSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @return Specify the maximum number of speakers you want to partition in your media.</p>
     *         <p>
     *         Note that if your media contains more speakers than the specified number, multiple speakers are treated
     *         as a single speaker.
     *         </p>
     *         <p>
     *         If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *         field to true.
     */
    public final Integer maxSpeakerLabels() {
        return maxSpeakerLabels;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */
    public final Boolean channelIdentification() {
        return channelIdentification;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return To include alternative transcriptions within your transcription output, include
     *         <code>ShowAlternatives</code> in your transcription request.</p>
     *         <p>
     *         If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *         continuous manner and your transcript does not separate the speech by channel.
     *         </p>
     *         <p>
     *         If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which
     *         is the maximum number of alternative transcriptions you want Amazon Transcribe to generate.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */
    public final Boolean showAlternatives() {
        return showAlternatives;
    }

    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe, only
     * the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your
     *         transcript.</p>
     *         <p>
     *         If you select a number greater than the number of alternative transcriptions generated by Amazon
     *         Transcribe, only the actual number of alternative transcriptions are included.
     *         </p>
     *         <p>
     *         If you include <code>MaxAlternatives</code> in your request, you must also include
     *         <code>ShowAlternatives</code> with a value of <code>true</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */
    public final Integer maxAlternatives() {
        return maxAlternatives;
    }

    /**
     * <p>
     * The name of the custom vocabulary filter you want to use in your transcription job request. This name is case
     * sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     * </p>
     * <p>
     * Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
     * <code>VocabularyFilterMethod</code>.
     * </p>
     * 
     * @return The name of the custom vocabulary filter you want to use in your transcription job request. This name is
     *         case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p>
     *         <p>
     *         Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
     *         <code>VocabularyFilterMethod</code>.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see VocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(showAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(showSpeakerLabels(), other.showSpeakerLabels())
                && Objects.equals(maxSpeakerLabels(), other.maxSpeakerLabels())
                && Objects.equals(channelIdentification(), other.channelIdentification())
                && Objects.equals(showAlternatives(), other.showAlternatives())
                && Objects.equals(maxAlternatives(), other.maxAlternatives())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Settings").add("VocabularyName", vocabularyName()).add("ShowSpeakerLabels", showSpeakerLabels())
                .add("MaxSpeakerLabels", maxSpeakerLabels()).add("ChannelIdentification", channelIdentification())
                .add("ShowAlternatives", showAlternatives()).add("MaxAlternatives", maxAlternatives())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "ShowSpeakerLabels":
            return Optional.ofNullable(clazz.cast(showSpeakerLabels()));
        case "MaxSpeakerLabels":
            return Optional.ofNullable(clazz.cast(maxSpeakerLabels()));
        case "ChannelIdentification":
            return Optional.ofNullable(clazz.cast(channelIdentification()));
        case "ShowAlternatives":
            return Optional.ofNullable(clazz.cast(showAlternatives()));
        case "MaxAlternatives":
            return Optional.ofNullable(clazz.cast(maxAlternatives()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Settings> {
        /**
         * <p>
         * The name of the custom vocabulary you want to use in your transcription job request. This name is case
         * sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * </p>
         * 
         * @param vocabularyName
         *        The name of the custom vocabulary you want to use in your transcription job request. This name is case
         *        sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
         * speech from individual speakers in your media file.
         * </p>
         * <p>
         * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         * <code>MaxSpeakerLabels</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         * (diarization)</a>.
         * </p>
         * 
         * @param showSpeakerLabels
         *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels
         *        the speech from individual speakers in your media file.</p>
         *        <p>
         *        If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
         *        <code>MaxSpeakerLabels</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
         *        (diarization)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabels(Boolean showSpeakerLabels);

        /**
         * <p>
         * Specify the maximum number of speakers you want to partition in your media.
         * </p>
         * <p>
         * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
         * single speaker.
         * </p>
         * <p>
         * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field
         * to true.
         * </p>
         * 
         * @param maxSpeakerLabels
         *        Specify the maximum number of speakers you want to partition in your media.</p>
         *        <p>
         *        Note that if your media contains more speakers than the specified number, multiple speakers are
         *        treated as a single speaker.
         *        </p>
         *        <p>
         *        If you specify the <code>MaxSpeakerLabels</code> field, you must set the
         *        <code>ShowSpeakerLabels</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeakerLabels(Integer maxSpeakerLabels);

        /**
         * <p>
         * Enables channel identification in multi-channel audio.
         * </p>
         * <p>
         * Channel identification transcribes the audio on each channel independently, then appends the output for each
         * channel into one transcript.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.
         * </p>
         * 
         * @param channelIdentification
         *        Enables channel identification in multi-channel audio.</p>
         *        <p>
         *        Channel identification transcribes the audio on each channel independently, then appends the output
         *        for each channel into one transcript.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
         *        audio</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentification(Boolean channelIdentification);

        /**
         * <p>
         * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code>
         * in your transcription request.
         * </p>
         * <p>
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
         * continuous manner and your transcript does not separate the speech by channel.
         * </p>
         * <p>
         * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is
         * the maximum number of alternative transcriptions you want Amazon Transcribe to generate.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
         * </p>
         * 
         * @param showAlternatives
         *        To include alternative transcriptions within your transcription output, include
         *        <code>ShowAlternatives</code> in your transcription request.</p>
         *        <p>
         *        If you have multi-channel audio and do not enable channel identification, your audio is transcribed in
         *        a continuous manner and your transcript does not separate the speech by channel.
         *        </p>
         *        <p>
         *        If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>,
         *        which is the maximum number of alternative transcriptions you want Amazon Transcribe to generate.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
         *        transcriptions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showAlternatives(Boolean showAlternatives);

        /**
         * <p>
         * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your
         * transcript.
         * </p>
         * <p>
         * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe,
         * only the actual number of alternative transcriptions are included.
         * </p>
         * <p>
         * If you include <code>MaxAlternatives</code> in your request, you must also include
         * <code>ShowAlternatives</code> with a value of <code>true</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
         * </p>
         * 
         * @param maxAlternatives
         *        Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in
         *        your transcript.</p>
         *        <p>
         *        If you select a number greater than the number of alternative transcriptions generated by Amazon
         *        Transcribe, only the actual number of alternative transcriptions are included.
         *        </p>
         *        <p>
         *        If you include <code>MaxAlternatives</code> in your request, you must also include
         *        <code>ShowAlternatives</code> with a value of <code>true</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
         *        transcriptions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAlternatives(Integer maxAlternatives);

        /**
         * <p>
         * The name of the custom vocabulary filter you want to use in your transcription job request. This name is case
         * sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * </p>
         * <p>
         * Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
         * <code>VocabularyFilterMethod</code>.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the custom vocabulary filter you want to use in your transcription job request. This name
         *        is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account.</p>
         *        <p>
         *        Note that if you include <code>VocabularyFilterName</code> in your request, you must also include
         *        <code>VocabularyFilterMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to your transcript.
         * </p>
         * <p>
         * To replace words with <code>***</code>, choose <code>mask</code>.
         * </p>
         * <p>
         * To delete words, choose <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, choose <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to your transcript.</p>
         *        <p>
         *        To replace words with <code>***</code>, choose <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, choose <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, choose <code>tag</code>.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);
    }

    static final class BuilderImpl implements Builder {
        private String vocabularyName;

        private Boolean showSpeakerLabels;

        private Integer maxSpeakerLabels;

        private Boolean channelIdentification;

        private Boolean showAlternatives;

        private Integer maxAlternatives;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            vocabularyName(model.vocabularyName);
            showSpeakerLabels(model.showSpeakerLabels);
            maxSpeakerLabels(model.maxSpeakerLabels);
            channelIdentification(model.channelIdentification);
            showAlternatives(model.showAlternatives);
            maxAlternatives(model.maxAlternatives);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final Boolean getShowSpeakerLabels() {
            return showSpeakerLabels;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final Integer getMaxSpeakerLabels() {
            return maxSpeakerLabels;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final Boolean getChannelIdentification() {
            return channelIdentification;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final Boolean getShowAlternatives() {
            return showAlternatives;
        }

        public final void setShowAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
        }

        @Override
        public final Builder showAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
            return this;
        }

        public final Integer getMaxAlternatives() {
            return maxAlternatives;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        @Override
        public Settings build() {
            return new Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
