/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobDetails;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSettings;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus;
import software.amazon.awssdk.services.transcribe.model.ChannelDefinition;
import software.amazon.awssdk.services.transcribe.model.ChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Media;
import software.amazon.awssdk.services.transcribe.model.MediaFormat;
import software.amazon.awssdk.services.transcribe.model.Transcript;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsJob> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAnalyticsJobName").getter(CallAnalyticsJob.getter(CallAnalyticsJob::callAnalyticsJobName)).setter(CallAnalyticsJob.setter(Builder::callAnalyticsJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build()}).build();
    private static final SdkField<String> CALL_ANALYTICS_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAnalyticsJobStatus").getter(CallAnalyticsJob.getter(CallAnalyticsJob::callAnalyticsJobStatusAsString)).setter(CallAnalyticsJob.setter(Builder::callAnalyticsJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobStatus").build()}).build();
    private static final SdkField<CallAnalyticsJobDetails> CALL_ANALYTICS_JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallAnalyticsJobDetails").getter(CallAnalyticsJob.getter(CallAnalyticsJob::callAnalyticsJobDetails)).setter(CallAnalyticsJob.setter(Builder::callAnalyticsJobDetails)).constructor(CallAnalyticsJobDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobDetails").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CallAnalyticsJob.getter(CallAnalyticsJob::languageCodeAsString)).setter(CallAnalyticsJob.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(CallAnalyticsJob.getter(CallAnalyticsJob::mediaSampleRateHertz)).setter(CallAnalyticsJob.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build()}).build();
    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFormat").getter(CallAnalyticsJob.getter(CallAnalyticsJob::mediaFormatAsString)).setter(CallAnalyticsJob.setter(Builder::mediaFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()}).build();
    private static final SdkField<Media> MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Media").getter(CallAnalyticsJob.getter(CallAnalyticsJob::media)).setter(CallAnalyticsJob.setter(Builder::media)).constructor(Media::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()}).build();
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transcript").getter(CallAnalyticsJob.getter(CallAnalyticsJob::transcript)).setter(CallAnalyticsJob.setter(Builder::transcript)).constructor(Transcript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CallAnalyticsJob.getter(CallAnalyticsJob::startTime)).setter(CallAnalyticsJob.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CallAnalyticsJob.getter(CallAnalyticsJob::creationTime)).setter(CallAnalyticsJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(CallAnalyticsJob.getter(CallAnalyticsJob::completionTime)).setter(CallAnalyticsJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(CallAnalyticsJob.getter(CallAnalyticsJob::failureReason)).setter(CallAnalyticsJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(CallAnalyticsJob.getter(CallAnalyticsJob::dataAccessRoleArn)).setter(CallAnalyticsJob.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<Float> IDENTIFIED_LANGUAGE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("IdentifiedLanguageScore").getter(CallAnalyticsJob.getter(CallAnalyticsJob::identifiedLanguageScore)).setter(CallAnalyticsJob.setter(Builder::identifiedLanguageScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedLanguageScore").build()}).build();
    private static final SdkField<CallAnalyticsJobSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(CallAnalyticsJob.getter(CallAnalyticsJob::settings)).setter(CallAnalyticsJob.setter(Builder::settings)).constructor(CallAnalyticsJobSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(CallAnalyticsJob.getter(CallAnalyticsJob::channelDefinitions)).setter(CallAnalyticsJob.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD, CALL_ANALYTICS_JOB_STATUS_FIELD, CALL_ANALYTICS_JOB_DETAILS_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD, MEDIA_FIELD, TRANSCRIPT_FIELD, START_TIME_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, FAILURE_REASON_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, IDENTIFIED_LANGUAGE_SCORE_FIELD, SETTINGS_FIELD, CHANNEL_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CallAnalyticsJobName", CALL_ANALYTICS_JOB_NAME_FIELD);
            this.put("CallAnalyticsJobStatus", CALL_ANALYTICS_JOB_STATUS_FIELD);
            this.put("CallAnalyticsJobDetails", CALL_ANALYTICS_JOB_DETAILS_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("MediaSampleRateHertz", MEDIA_SAMPLE_RATE_HERTZ_FIELD);
            this.put("MediaFormat", MEDIA_FORMAT_FIELD);
            this.put("Media", MEDIA_FIELD);
            this.put("Transcript", TRANSCRIPT_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("CompletionTime", COMPLETION_TIME_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
            this.put("IdentifiedLanguageScore", IDENTIFIED_LANGUAGE_SCORE_FIELD);
            this.put("Settings", SETTINGS_FIELD);
            this.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String callAnalyticsJobName;
    private final String callAnalyticsJobStatus;
    private final CallAnalyticsJobDetails callAnalyticsJobDetails;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaFormat;
    private final Media media;
    private final Transcript transcript;
    private final Instant startTime;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String failureReason;
    private final String dataAccessRoleArn;
    private final Float identifiedLanguageScore;
    private final CallAnalyticsJobSettings settings;
    private final List<ChannelDefinition> channelDefinitions;

    private CallAnalyticsJob(BuilderImpl builder) {
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.callAnalyticsJobStatus = builder.callAnalyticsJobStatus;
        this.callAnalyticsJobDetails = builder.callAnalyticsJobDetails;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.transcript = builder.transcript;
        this.startTime = builder.startTime;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.failureReason = builder.failureReason;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.identifiedLanguageScore = builder.identifiedLanguageScore;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
    }

    public final String callAnalyticsJobName() {
        return this.callAnalyticsJobName;
    }

    public final CallAnalyticsJobStatus callAnalyticsJobStatus() {
        return CallAnalyticsJobStatus.fromValue(this.callAnalyticsJobStatus);
    }

    public final String callAnalyticsJobStatusAsString() {
        return this.callAnalyticsJobStatus;
    }

    public final CallAnalyticsJobDetails callAnalyticsJobDetails() {
        return this.callAnalyticsJobDetails;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(this.mediaFormat);
    }

    public final String mediaFormatAsString() {
        return this.mediaFormat;
    }

    public final Media media() {
        return this.media;
    }

    public final Transcript transcript() {
        return this.transcript;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final Float identifiedLanguageScore() {
        return this.identifiedLanguageScore;
    }

    public final CallAnalyticsJobSettings settings() {
        return this.settings;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.media());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedLanguageScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJob)) {
            return false;
        }
        CallAnalyticsJob other = (CallAnalyticsJob)obj;
        return Objects.equals(this.callAnalyticsJobName(), other.callAnalyticsJobName()) && Objects.equals(this.callAnalyticsJobStatusAsString(), other.callAnalyticsJobStatusAsString()) && Objects.equals(this.callAnalyticsJobDetails(), other.callAnalyticsJobDetails()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(this.media(), other.media()) && Objects.equals(this.transcript(), other.transcript()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.identifiedLanguageScore(), other.identifiedLanguageScore()) && Objects.equals(this.settings(), other.settings()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsJob").add("CallAnalyticsJobName", (Object)this.callAnalyticsJobName()).add("CallAnalyticsJobStatus", (Object)this.callAnalyticsJobStatusAsString()).add("CallAnalyticsJobDetails", (Object)this.callAnalyticsJobDetails()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaFormat", (Object)this.mediaFormatAsString()).add("Media", (Object)this.media()).add("Transcript", (Object)this.transcript()).add("StartTime", (Object)this.startTime()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("FailureReason", (Object)this.failureReason()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("IdentifiedLanguageScore", (Object)this.identifiedLanguageScore()).add("Settings", (Object)this.settings()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallAnalyticsJobName": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobName()));
            }
            case "CallAnalyticsJobStatus": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobStatusAsString()));
            }
            case "CallAnalyticsJobDetails": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobDetails()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaFormat": {
                return Optional.ofNullable(clazz.cast(this.mediaFormatAsString()));
            }
            case "Media": {
                return Optional.ofNullable(clazz.cast(this.media()));
            }
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "IdentifiedLanguageScore": {
                return Optional.ofNullable(clazz.cast(this.identifiedLanguageScore()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsJob, T> g) {
        return obj -> g.apply((CallAnalyticsJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callAnalyticsJobName;
        private String callAnalyticsJobStatus;
        private CallAnalyticsJobDetails callAnalyticsJobDetails;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaFormat;
        private Media media;
        private Transcript transcript;
        private Instant startTime;
        private Instant creationTime;
        private Instant completionTime;
        private String failureReason;
        private String dataAccessRoleArn;
        private Float identifiedLanguageScore;
        private CallAnalyticsJobSettings settings;
        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsJob model) {
            this.callAnalyticsJobName(model.callAnalyticsJobName);
            this.callAnalyticsJobStatus(model.callAnalyticsJobStatus);
            this.callAnalyticsJobDetails(model.callAnalyticsJobDetails);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaFormat(model.mediaFormat);
            this.media(model.media);
            this.transcript(model.transcript);
            this.startTime(model.startTime);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.failureReason(model.failureReason);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.identifiedLanguageScore(model.identifiedLanguageScore);
            this.settings(model.settings);
            this.channelDefinitions(model.channelDefinitions);
        }

        public final String getCallAnalyticsJobName() {
            return this.callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final String getCallAnalyticsJobStatus() {
            return this.callAnalyticsJobStatus;
        }

        public final void setCallAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
        }

        @Override
        public final Builder callAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
            return this;
        }

        @Override
        public final Builder callAnalyticsJobStatus(CallAnalyticsJobStatus callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus(callAnalyticsJobStatus == null ? null : callAnalyticsJobStatus.toString());
            return this;
        }

        public final CallAnalyticsJobDetails.Builder getCallAnalyticsJobDetails() {
            return this.callAnalyticsJobDetails != null ? this.callAnalyticsJobDetails.toBuilder() : null;
        }

        public final void setCallAnalyticsJobDetails(CallAnalyticsJobDetails.BuilderImpl callAnalyticsJobDetails) {
            this.callAnalyticsJobDetails = callAnalyticsJobDetails != null ? callAnalyticsJobDetails.build() : null;
        }

        @Override
        public final Builder callAnalyticsJobDetails(CallAnalyticsJobDetails callAnalyticsJobDetails) {
            this.callAnalyticsJobDetails = callAnalyticsJobDetails;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaFormat() {
            return this.mediaFormat;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final Media.Builder getMedia() {
            return this.media != null ? this.media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final Transcript.Builder getTranscript() {
            return this.transcript != null ? this.transcript.toBuilder() : null;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final Float getIdentifiedLanguageScore() {
            return this.identifiedLanguageScore;
        }

        public final void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
        }

        @Override
        public final Builder identifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
            return this;
        }

        public final CallAnalyticsJobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(CallAnalyticsJobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(CallAnalyticsJobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (ChannelDefinition)((ChannelDefinition.Builder)ChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CallAnalyticsJob build() {
            return new CallAnalyticsJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsJob> {
        public Builder callAnalyticsJobName(String var1);

        public Builder callAnalyticsJobStatus(String var1);

        public Builder callAnalyticsJobStatus(CallAnalyticsJobStatus var1);

        public Builder callAnalyticsJobDetails(CallAnalyticsJobDetails var1);

        default public Builder callAnalyticsJobDetails(Consumer<CallAnalyticsJobDetails.Builder> callAnalyticsJobDetails) {
            return this.callAnalyticsJobDetails((CallAnalyticsJobDetails)((CallAnalyticsJobDetails.Builder)CallAnalyticsJobDetails.builder().applyMutation(callAnalyticsJobDetails)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaFormat(String var1);

        public Builder mediaFormat(MediaFormat var1);

        public Builder media(Media var1);

        default public Builder media(Consumer<Media.Builder> media) {
            return this.media((Media)((Media.Builder)Media.builder().applyMutation(media)).build());
        }

        public Builder transcript(Transcript var1);

        default public Builder transcript(Consumer<Transcript.Builder> transcript) {
            return this.transcript((Transcript)((Transcript.Builder)Transcript.builder().applyMutation(transcript)).build());
        }

        public Builder startTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder identifiedLanguageScore(Float var1);

        public Builder settings(CallAnalyticsJobSettings var1);

        default public Builder settings(Consumer<CallAnalyticsJobSettings.Builder> settings) {
            return this.settings((CallAnalyticsJobSettings)((CallAnalyticsJobSettings.Builder)CallAnalyticsJobSettings.builder().applyMutation(settings)).build());
        }

        public Builder channelDefinitions(Collection<ChannelDefinition> var1);

        public Builder channelDefinitions(ChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<ChannelDefinition.Builder> ... var1);
    }
}

