/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides you with the Amazon S3 URI you can use to access your transcript.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalTranscript implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalTranscript.Builder, MedicalTranscript> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptFileUri").getter(getter(MedicalTranscript::transcriptFileUri))
            .setter(setter(Builder::transcriptFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transcriptFileUri;

    private MedicalTranscript(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
    }

    /**
     * <p>
     * The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.
     * </p>
     * <p>
     * Note that this is the Amazon S3 location you specified in your request using the <code>OutputBucketName</code>
     * parameter.
     * </p>
     * 
     * @return The Amazon S3 location of your transcript. You can use this URI to access or download your
     *         transcript.</p>
     *         <p>
     *         Note that this is the Amazon S3 location you specified in your request using the
     *         <code>OutputBucketName</code> parameter.
     */
    public final String transcriptFileUri() {
        return transcriptFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFileUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscript)) {
            return false;
        }
        MedicalTranscript other = (MedicalTranscript) obj;
        return Objects.equals(transcriptFileUri(), other.transcriptFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalTranscript").add("TranscriptFileUri", transcriptFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptFileUri":
            return Optional.ofNullable(clazz.cast(transcriptFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TranscriptFileUri", TRANSCRIPT_FILE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscript, T> g) {
        return obj -> g.apply((MedicalTranscript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalTranscript> {
        /**
         * <p>
         * The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.
         * </p>
         * <p>
         * Note that this is the Amazon S3 location you specified in your request using the
         * <code>OutputBucketName</code> parameter.
         * </p>
         * 
         * @param transcriptFileUri
         *        The Amazon S3 location of your transcript. You can use this URI to access or download your
         *        transcript.</p>
         *        <p>
         *        Note that this is the Amazon S3 location you specified in your request using the
         *        <code>OutputBucketName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFileUri(String transcriptFileUri);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscript model) {
            transcriptFileUri(model.transcriptFileUri);
        }

        public final String getTranscriptFileUri() {
            return transcriptFileUri;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        @Override
        public MedicalTranscript build() {
            return new MedicalTranscript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
