/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides detailed information about a specific medical transcription job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalTranscriptionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalTranscriptionJobSummary.Builder, MedicalTranscriptionJobSummary> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MedicalTranscriptionJobName")
            .getter(getter(MedicalTranscriptionJobSummary::medicalTranscriptionJobName))
            .setter(setter(Builder::medicalTranscriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MedicalTranscriptionJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(MedicalTranscriptionJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(MedicalTranscriptionJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(MedicalTranscriptionJobSummary::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptionJobStatus").getter(getter(MedicalTranscriptionJobSummary::transcriptionJobStatusAsString))
            .setter(setter(Builder::transcriptionJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(MedicalTranscriptionJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputLocationType").getter(getter(MedicalTranscriptionJobSummary::outputLocationTypeAsString))
            .setter(setter(Builder::outputLocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build())
            .build();

    private static final SdkField<String> SPECIALTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specialty").getter(getter(MedicalTranscriptionJobSummary::specialtyAsString))
            .setter(setter(Builder::specialty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(MedicalTranscriptionJobSummary::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MedicalTranscriptionJobSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD,
            LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD,
            SPECIALTY_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String medicalTranscriptionJobName;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant completionTime;

    private final String languageCode;

    private final String transcriptionJobStatus;

    private final String failureReason;

    private final String outputLocationType;

    private final String specialty;

    private final String contentIdentificationType;

    private final String type;

    private MedicalTranscriptionJobSummary(BuilderImpl builder) {
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
        this.specialty = builder.specialty;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the medical transcription job. Job names are case sensitive and must be unique within an
     *         Amazon Web Services account.
     */
    public final String medicalTranscriptionJobName() {
        return medicalTranscriptionJobName;
    }

    /**
     * <p>
     * The date and time the specified medical transcription job request was made.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified medical transcription job request was made.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time your medical transcription job began processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time your medical transcription job began processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time the specified medical transcription job finished processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified medical transcription job finished processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at
     *         12:33 PM UTC-7 on May 4, 2022.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
     * supported language for medical transcriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
     *         supported language for medical transcriptions.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
     * supported language for medical transcriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
     *         supported language for medical transcriptions.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Provides the status of your medical transcription job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of your medical transcription job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>,
     *         <code>FailureReason</code> provides details on why your transcription job failed.
     * @see TranscriptionJobStatus
     */
    public final TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(transcriptionJobStatus);
    }

    /**
     * <p>
     * Provides the status of your medical transcription job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
     * provides details on why your transcription job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transcriptionJobStatus} will return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transcriptionJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of your medical transcription job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>,
     *         <code>FailureReason</code> provides details on why your transcription job failed.
     * @see TranscriptionJobStatus
     */
    public final String transcriptionJobStatusAsString() {
        return transcriptionJobStatus;
    }

    /**
     * <p>
     * If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information
     * about why the transcription job failed. See also: <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     * </p>
     * 
     * @return If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
     *         information about why the transcription job failed. See also: <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Indicates where the specified medical transcription output is stored.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the
     * <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your
     * request, your output is located in the path you specified in your request.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a
     * transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates where the specified medical transcription output is stored.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using
     *         the <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code>
     *         in your request, your output is located in the path you specified in your request.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To
     *         access a transcript stored in a service-managed bucket, use the URI shown in the
     *         <code>TranscriptFileUri</code> field.
     * @see OutputLocationType
     */
    public final OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(outputLocationType);
    }

    /**
     * <p>
     * Indicates where the specified medical transcription output is stored.
     * </p>
     * <p>
     * If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the
     * <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your
     * request, your output is located in the path you specified in your request.
     * </p>
     * <p>
     * If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a
     * transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputLocationType} will return {@link OutputLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputLocationTypeAsString}.
     * </p>
     * 
     * @return Indicates where the specified medical transcription output is stored.</p>
     *         <p>
     *         If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using
     *         the <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code>
     *         in your request, your output is located in the path you specified in your request.
     *         </p>
     *         <p>
     *         If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To
     *         access a transcript stored in a service-managed bucket, use the URI shown in the
     *         <code>TranscriptFileUri</code> field.
     * @see OutputLocationType
     */
    public final String outputLocationTypeAsString() {
        return outputLocationType;
    }

    /**
     * <p>
     * Provides the medical specialty represented in your media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return Provides the medical specialty represented in your media.
     * @see Specialty
     */
    public final Specialty specialty() {
        return Specialty.fromValue(specialty);
    }

    /**
     * <p>
     * Provides the medical specialty represented in your media.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return Provides the medical specialty represented in your media.
     * @see Specialty
     */
    public final String specialtyAsString() {
        return specialty;
    }

    /**
     * <p>
     * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI)
     * in a transcription</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
     *         information (PHI) in a transcription</a>.
     * @see MedicalContentIdentificationType
     */
    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI)
     * in a transcription</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
     *         information (PHI) in a transcription</a>.
     * @see MedicalContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Indicates whether the input media is a dictation or a conversation, as specified in the
     * <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the input media is a dictation or a conversation, as specified in the
     *         <code>StartMedicalTranscriptionJob</code> request.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether the input media is a dictation or a conversation, as specified in the
     * <code>StartMedicalTranscriptionJob</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether the input media is a dictation or a conversation, as specified in the
     *         <code>StartMedicalTranscriptionJob</code> request.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalTranscriptionJobSummary)) {
            return false;
        }
        MedicalTranscriptionJobSummary other = (MedicalTranscriptionJobSummary) obj;
        return Objects.equals(medicalTranscriptionJobName(), other.medicalTranscriptionJobName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(outputLocationTypeAsString(), other.outputLocationTypeAsString())
                && Objects.equals(specialtyAsString(), other.specialtyAsString())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalTranscriptionJobSummary")
                .add("MedicalTranscriptionJobName", medicalTranscriptionJobName()).add("CreationTime", creationTime())
                .add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("LanguageCode", languageCodeAsString()).add("TranscriptionJobStatus", transcriptionJobStatusAsString())
                .add("FailureReason", failureReason()).add("OutputLocationType", outputLocationTypeAsString())
                .add("Specialty", specialtyAsString()).add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalTranscriptionJobName":
            return Optional.ofNullable(clazz.cast(medicalTranscriptionJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "TranscriptionJobStatus":
            return Optional.ofNullable(clazz.cast(transcriptionJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "OutputLocationType":
            return Optional.ofNullable(clazz.cast(outputLocationTypeAsString()));
        case "Specialty":
            return Optional.ofNullable(clazz.cast(specialtyAsString()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MedicalTranscriptionJobName", MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("TranscriptionJobStatus", TRANSCRIPTION_JOB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("OutputLocationType", OUTPUT_LOCATION_TYPE_FIELD);
        map.put("Specialty", SPECIALTY_FIELD);
        map.put("ContentIdentificationType", CONTENT_IDENTIFICATION_TYPE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalTranscriptionJobSummary, T> g) {
        return obj -> g.apply((MedicalTranscriptionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalTranscriptionJobSummary> {
        /**
         * <p>
         * The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon
         * Web Services account.
         * </p>
         * 
         * @param medicalTranscriptionJobName
         *        The name of the medical transcription job. Job names are case sensitive and must be unique within an
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJobName(String medicalTranscriptionJobName);

        /**
         * <p>
         * The date and time the specified medical transcription job request was made.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param creationTime
         *        The date and time the specified medical transcription job request was made.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time your medical transcription job began processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param startTime
         *        The date and time your medical transcription job began processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time the specified medical transcription job finished processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param completionTime
         *        The date and time the specified medical transcription job finished processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing
         *        at 12:33 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
         * supported language for medical transcriptions.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your medical transcription. US English (<code>en-US</code>) is the
         *        only supported language for medical transcriptions.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code used to create your medical transcription. US English (<code>en-US</code>) is the only
         * supported language for medical transcriptions.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your medical transcription. US English (<code>en-US</code>) is the
         *        only supported language for medical transcriptions.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Provides the status of your medical transcription job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
         * provides details on why your transcription job failed.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        Provides the status of your medical transcription job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details on why your transcription job failed.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(String transcriptionJobStatus);

        /**
         * <p>
         * Provides the status of your medical transcription job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code>
         * provides details on why your transcription job failed.
         * </p>
         * 
         * @param transcriptionJobStatus
         *        Provides the status of your medical transcription job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>,
         *        <code>FailureReason</code> provides details on why your transcription job failed.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus);

        /**
         * <p>
         * If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         * information about why the transcription job failed. See also: <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param failureReason
         *        If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         *        information about why the transcription job failed. See also: <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Indicates where the specified medical transcription output is stored.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the
         * <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your
         * request, your output is located in the path you specified in your request.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a
         * transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates where the specified medical transcription output is stored.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using
         *        the <code>OutputBucketName</code> parameter in your request. If you also included
         *        <code>OutputKey</code> in your request, your output is located in the path you specified in your
         *        request.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To
         *        access a transcript stored in a service-managed bucket, use the URI shown in the
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(String outputLocationType);

        /**
         * <p>
         * Indicates where the specified medical transcription output is stored.
         * </p>
         * <p>
         * If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the
         * <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your
         * request, your output is located in the path you specified in your request.
         * </p>
         * <p>
         * If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a
         * transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> field.
         * </p>
         * 
         * @param outputLocationType
         *        Indicates where the specified medical transcription output is stored.</p>
         *        <p>
         *        If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using
         *        the <code>OutputBucketName</code> parameter in your request. If you also included
         *        <code>OutputKey</code> in your request, your output is located in the path you specified in your
         *        request.
         *        </p>
         *        <p>
         *        If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To
         *        access a transcript stored in a service-managed bucket, use the URI shown in the
         *        <code>TranscriptFileUri</code> field.
         * @see OutputLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputLocationType
         */
        Builder outputLocationType(OutputLocationType outputLocationType);

        /**
         * <p>
         * Provides the medical specialty represented in your media.
         * </p>
         * 
         * @param specialty
         *        Provides the medical specialty represented in your media.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(String specialty);

        /**
         * <p>
         * Provides the medical specialty represented in your media.
         * </p>
         * 
         * @param specialty
         *        Provides the medical specialty represented in your media.
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(Specialty specialty);

        /**
         * <p>
         * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information
         * (PHI) in a transcription</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personal health information (PHI) identified in your transcript. For more information, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
         *        information (PHI) in a transcription</a>.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information
         * (PHI) in a transcription</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personal health information (PHI) identified in your transcript. For more information, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
         *        information (PHI) in a transcription</a>.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * Indicates whether the input media is a dictation or a conversation, as specified in the
         * <code>StartMedicalTranscriptionJob</code> request.
         * </p>
         * 
         * @param type
         *        Indicates whether the input media is a dictation or a conversation, as specified in the
         *        <code>StartMedicalTranscriptionJob</code> request.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether the input media is a dictation or a conversation, as specified in the
         * <code>StartMedicalTranscriptionJob</code> request.
         * </p>
         * 
         * @param type
         *        Indicates whether the input media is a dictation or a conversation, as specified in the
         *        <code>StartMedicalTranscriptionJob</code> request.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String medicalTranscriptionJobName;

        private Instant creationTime;

        private Instant startTime;

        private Instant completionTime;

        private String languageCode;

        private String transcriptionJobStatus;

        private String failureReason;

        private String outputLocationType;

        private String specialty;

        private String contentIdentificationType;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalTranscriptionJobSummary model) {
            medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            creationTime(model.creationTime);
            startTime(model.startTime);
            completionTime(model.completionTime);
            languageCode(model.languageCode);
            transcriptionJobStatus(model.transcriptionJobStatus);
            failureReason(model.failureReason);
            outputLocationType(model.outputLocationType);
            specialty(model.specialty);
            contentIdentificationType(model.contentIdentificationType);
            type(model.type);
        }

        public final String getMedicalTranscriptionJobName() {
            return medicalTranscriptionJobName;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        @Override
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getTranscriptionJobStatus() {
            return transcriptionJobStatus;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOutputLocationType() {
            return outputLocationType;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType == null ? null : outputLocationType.toString());
            return this;
        }

        public final String getSpecialty() {
            return specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public MedicalTranscriptionJobSummary build() {
            return new MedicalTranscriptionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
