/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalScribeJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartMedicalScribeJobRequest.Builder, StartMedicalScribeJobRequest> {
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MedicalScribeJobName").getter(getter(StartMedicalScribeJobRequest::medicalScribeJobName))
            .setter(setter(Builder::medicalScribeJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobName").build())
            .build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartMedicalScribeJobRequest::media)).setter(setter(Builder::media)).constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputBucketName").getter(getter(StartMedicalScribeJobRequest::outputBucketName))
            .setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartMedicalScribeJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KMSEncryptionContext")
            .getter(getter(StartMedicalScribeJobRequest::kmsEncryptionContext))
            .setter(setter(Builder::kmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartMedicalScribeJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<MedicalScribeSettings> SETTINGS_FIELD = SdkField
            .<MedicalScribeSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartMedicalScribeJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(MedicalScribeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<MedicalScribeChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(StartMedicalScribeJobRequest::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalScribeChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalScribeChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartMedicalScribeJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_NAME_FIELD,
            MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, SETTINGS_FIELD, CHANNEL_DEFINITIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String medicalScribeJobName;

    private final Media media;

    private final String outputBucketName;

    private final String outputEncryptionKMSKeyId;

    private final Map<String, String> kmsEncryptionContext;

    private final String dataAccessRoleArn;

    private final MedicalScribeSettings settings;

    private final List<MedicalScribeChannelDefinition> channelDefinitions;

    private final List<Tag> tags;

    private StartMedicalScribeJobRequest(BuilderImpl builder) {
        super(builder);
        this.medicalScribeJobName = builder.medicalScribeJobName;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.settings = builder.settings;
        this.channelDefinitions = builder.channelDefinitions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name, chosen by you, for your Medical Scribe job.
     * </p>
     * <p>
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If
     * you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code>
     * error.
     * </p>
     * 
     * @return A unique name, chosen by you, for your Medical Scribe job.</p>
     *         <p>
     *         This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
     *         account. If you try to create a new job with the same name as an existing job, you get a
     *         <code>ConflictException</code> error.
     */
    public final String medicalScribeJobName() {
        return medicalScribeJobName;
    }

    /**
     * Returns the value of the Media property for this object.
     * 
     * @return The value of the Media property for this object.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the
     * <code>S3://</code> prefix of the specified bucket.
     * </p>
     * <p>
     * Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to use
     * the specified location. You can change Amazon S3 permissions using the <a
     * href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles</a>.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the
     *         <code>S3://</code> prefix of the specified bucket.</p>
     *         <p>
     *         Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission
     *         to use the specified location. You can change Amazon S3 permissions using the <a
     *         href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles</a>.
     */
    public final String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * The KMS key you want to use to encrypt your Medical Scribe output.
     * </p>
     * <p>
     * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of
     * four ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
     * account, you can specify your KMS key in one of two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the ARN for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to use
     * the specified KMS key.
     * </p>
     * 
     * @return The KMS key you want to use to encrypt your Medical Scribe output.</p>
     *         <p>
     *         If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in
     *         one of four ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
     *         Services account, you can specify your KMS key in one of two ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
     *         (SSE-S3).
     *         </p>
     *         <p>
     *         Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission
     *         to use the specified KMS key.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KMSEncryptionContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsEncryptionContext() {
        return kmsEncryptionContext != null && !(kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer
     * of security for your data. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     * context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric
     * keys in KMS</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsEncryptionContext} method.
     * </p>
     * 
     * @return A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
     *         layer of security for your data. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     *         context</a> and <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
     *         KMS</a>.
     */
    public final Map<String, String> kmsEncryptionContext() {
        return kmsEncryptionContext;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains
     * your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify
     * doesn’t have the appropriate permissions your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
     *         contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that
     *         you specify doesn’t have the appropriate permissions your request fails.</p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         ARNs</a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Makes it possible to control how your Medical Scribe job is processed using a <code>MedicalScribeSettings</code>
     * object. Specify <code>ChannelIdentification</code> if <code>ChannelDefinitions</code> are set. Enabled
     * <code>ShowSpeakerLabels</code> if <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not
     * set. One and only one of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
     * <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use <code>Settings</code>
     * to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>,
     * <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if
     * <code>VocabularyFilterName</code> is set.
     * </p>
     * 
     * @return Makes it possible to control how your Medical Scribe job is processed using a
     *         <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if
     *         <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if
     *         <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of
     *         <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
     *         <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use
     *         <code>Settings</code> to specify a vocabulary or vocabulary filter or both using
     *         <code>VocabularyName</code>, <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must
     *         be specified if <code>VocabularyFilterName</code> is set.
     */
    public final MedicalScribeSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first
     * participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the
     * list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>CLINICIAN</code>
     * (to indicate that it's the clinician speaking). Then you would set the <code>ChannelId</code> of the second
     * <code>ChannelDefinition</code> in the list to <code>1</code> (to indicate the second channel) and
     * <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it's the patient speaking).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return Makes it possible to specify which speaker is on which channel. For example, if the clinician is the
     *         first participant to speak, you would set <code>ChannelId</code> of the first
     *         <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and
     *         <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it's the clinician speaking).
     *         Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to
     *         <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code>
     *         (to indicate that it's the patient speaking).
     */
    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.</p>
     *         <p>
     *         To learn more about using tags with Amazon Transcribe, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(medicalScribeJobName());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsEncryptionContext() ? kmsEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalScribeJobRequest)) {
            return false;
        }
        StartMedicalScribeJobRequest other = (StartMedicalScribeJobRequest) obj;
        return Objects.equals(medicalScribeJobName(), other.medicalScribeJobName()) && Objects.equals(media(), other.media())
                && Objects.equals(outputBucketName(), other.outputBucketName())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && hasKmsEncryptionContext() == other.hasKmsEncryptionContext()
                && Objects.equals(kmsEncryptionContext(), other.kmsEncryptionContext())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(settings(), other.settings())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalScribeJobRequest").add("MedicalScribeJobName", medicalScribeJobName())
                .add("Media", media()).add("OutputBucketName", outputBucketName())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId())
                .add("KMSEncryptionContext", hasKmsEncryptionContext() ? kmsEncryptionContext() : null)
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("Settings", settings())
                .add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalScribeJobName":
            return Optional.ofNullable(clazz.cast(medicalScribeJobName()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "KMSEncryptionContext":
            return Optional.ofNullable(clazz.cast(kmsEncryptionContext()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MedicalScribeJobName", MEDICAL_SCRIBE_JOB_NAME_FIELD);
        map.put("Media", MEDIA_FIELD);
        map.put("OutputBucketName", OUTPUT_BUCKET_NAME_FIELD);
        map.put("OutputEncryptionKMSKeyId", OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD);
        map.put("KMSEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalScribeJobRequest, T> g) {
        return obj -> g.apply((StartMedicalScribeJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMedicalScribeJobRequest> {
        /**
         * <p>
         * A unique name, chosen by you, for your Medical Scribe job.
         * </p>
         * <p>
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * If you try to create a new job with the same name as an existing job, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param medicalScribeJobName
         *        A unique name, chosen by you, for your Medical Scribe job.</p>
         *        <p>
         *        This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account. If you try to create a new job with the same name as an existing job, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalScribeJobName(String medicalScribeJobName);

        /**
         * Sets the value of the Media property for this object.
         *
         * @param media
         *        The new value for the Media property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * Sets the value of the Media property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Media.Builder} avoiding the need to
         * create one manually via {@link Media#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the
         * <code>S3://</code> prefix of the specified bucket.
         * </p>
         * <p>
         * Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to
         * use the specified location. You can change Amazon S3 permissions using the <a
         * href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles</a>.
         * </p>
         * 
         * @param outputBucketName
         *        The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the
         *        <code>S3://</code> prefix of the specified bucket.</p>
         *        <p>
         *        Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have
         *        permission to use the specified location. You can change Amazon S3 permissions using the <a
         *        href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * The KMS key you want to use to encrypt your Medical Scribe output.
         * </p>
         * <p>
         * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one
         * of four ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
         * account, you can specify your KMS key in one of two ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the ARN for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to
         * use the specified KMS key.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The KMS key you want to use to encrypt your Medical Scribe output.</p>
         *        <p>
         *        If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key
         *        in one of four ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
         *        Services account, you can specify your KMS key in one of two ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
         *        (SSE-S3).
         *        </p>
         *        <p>
         *        Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have
         *        permission to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
         * layer of security for your data. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         * context</a> and <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.
         * </p>
         * 
         * @param kmsEncryptionContext
         *        A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an
         *        added layer of security for your data. For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         *        context</a> and <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
         *        KMS</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         * contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you
         * specify doesn’t have the appropriate permissions your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * ARNs</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that
         *        contains your input files, write to the output bucket, and use your KMS key if supplied. If the role
         *        that you specify doesn’t have the appropriate permissions your request fails.</p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM ARNs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Makes it possible to control how your Medical Scribe job is processed using a
         * <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if
         * <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if
         * <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of
         * <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
         * <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use
         * <code>Settings</code> to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>,
         * <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if
         * <code>VocabularyFilterName</code> is set.
         * </p>
         * 
         * @param settings
         *        Makes it possible to control how your Medical Scribe job is processed using a
         *        <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if
         *        <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if
         *        <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one
         *        of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
         *        <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use
         *        <code>Settings</code> to specify a vocabulary or vocabulary filter or both using
         *        <code>VocabularyName</code>, <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code>
         *        must be specified if <code>VocabularyFilterName</code> is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(MedicalScribeSettings settings);

        /**
         * <p>
         * Makes it possible to control how your Medical Scribe job is processed using a
         * <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if
         * <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if
         * <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of
         * <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If
         * <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use
         * <code>Settings</code> to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>,
         * <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if
         * <code>VocabularyFilterName</code> is set.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribeSettings.Builder} avoiding
         * the need to create one manually via {@link MedicalScribeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribeSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(MedicalScribeSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link MedicalScribeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(MedicalScribeSettings)
         */
        default Builder settings(Consumer<MedicalScribeSettings.Builder> settings) {
            return settings(MedicalScribeSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first
         * participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the
         * list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to
         * <code>CLINICIAN</code> (to indicate that it's the clinician speaking). Then you would set the
         * <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to
         * indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it's
         * the patient speaking).
         * </p>
         * 
         * @param channelDefinitions
         *        Makes it possible to specify which speaker is on which channel. For example, if the clinician is the
         *        first participant to speak, you would set <code>ChannelId</code> of the first
         *        <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and
         *        <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it's the clinician speaking).
         *        Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list
         *        to <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to
         *        <code>PATIENT</code> (to indicate that it's the patient speaking).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions);

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first
         * participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the
         * list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to
         * <code>CLINICIAN</code> (to indicate that it's the clinician speaking). Then you would set the
         * <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to
         * indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it's
         * the patient speaking).
         * </p>
         * 
         * @param channelDefinitions
         *        Makes it possible to specify which speaker is on which channel. For example, if the clinician is the
         *        first participant to speak, you would set <code>ChannelId</code> of the first
         *        <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and
         *        <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it's the clinician speaking).
         *        Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list
         *        to <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to
         *        <code>PATIENT</code> (to indicate that it's the patient speaking).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions);

        /**
         * <p>
         * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first
         * participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the
         * list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to
         * <code>CLINICIAN</code> (to indicate that it's the clinician speaking). Then you would set the
         * <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to
         * indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it's
         * the patient speaking).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #channelDefinitions(List<MedicalScribeChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.MedicalScribeChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<MedicalScribeChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transcribe.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String medicalScribeJobName;

        private Media media;

        private String outputBucketName;

        private String outputEncryptionKMSKeyId;

        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private String dataAccessRoleArn;

        private MedicalScribeSettings settings;

        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalScribeJobRequest model) {
            super(model);
            medicalScribeJobName(model.medicalScribeJobName);
            media(model.media);
            outputBucketName(model.outputBucketName);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            kmsEncryptionContext(model.kmsEncryptionContext);
            dataAccessRoleArn(model.dataAccessRoleArn);
            settings(model.settings);
            channelDefinitions(model.channelDefinitions);
            tags(model.tags);
        }

        public final String getMedicalScribeJobName() {
            return medicalScribeJobName;
        }

        public final void setMedicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
        }

        @Override
        public final Builder medicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
            return this;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final MedicalScribeSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(MedicalScribeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(MedicalScribeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier
                    .copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions)
                    .map(c -> MedicalScribeChannelDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalScribeJobRequest build() {
            return new StartMedicalScribeJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
