/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.ClinicalNoteGenerationSettings;
import software.amazon.awssdk.services.transcribe.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeSettings> {
    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabels").getter(MedicalScribeSettings.getter(MedicalScribeSettings::showSpeakerLabels)).setter(MedicalScribeSettings.setter(Builder::showSpeakerLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()}).build();
    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSpeakerLabels").getter(MedicalScribeSettings.getter(MedicalScribeSettings::maxSpeakerLabels)).setter(MedicalScribeSettings.setter(Builder::maxSpeakerLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()}).build();
    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ChannelIdentification").getter(MedicalScribeSettings.getter(MedicalScribeSettings::channelIdentification)).setter(MedicalScribeSettings.setter(Builder::channelIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(MedicalScribeSettings.getter(MedicalScribeSettings::vocabularyName)).setter(MedicalScribeSettings.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(MedicalScribeSettings.getter(MedicalScribeSettings::vocabularyFilterName)).setter(MedicalScribeSettings.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(MedicalScribeSettings.getter(MedicalScribeSettings::vocabularyFilterMethodAsString)).setter(MedicalScribeSettings.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<ClinicalNoteGenerationSettings> CLINICAL_NOTE_GENERATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClinicalNoteGenerationSettings").getter(MedicalScribeSettings.getter(MedicalScribeSettings::clinicalNoteGenerationSettings)).setter(MedicalScribeSettings.setter(Builder::clinicalNoteGenerationSettings)).constructor(ClinicalNoteGenerationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalNoteGenerationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHOW_SPEAKER_LABELS_FIELD, MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, CLINICAL_NOTE_GENERATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean showSpeakerLabels;
    private final Integer maxSpeakerLabels;
    private final Boolean channelIdentification;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final ClinicalNoteGenerationSettings clinicalNoteGenerationSettings;

    private MedicalScribeSettings(BuilderImpl builder) {
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.clinicalNoteGenerationSettings = builder.clinicalNoteGenerationSettings;
    }

    public final Boolean showSpeakerLabels() {
        return this.showSpeakerLabels;
    }

    public final Integer maxSpeakerLabels() {
        return this.maxSpeakerLabels;
    }

    public final Boolean channelIdentification() {
        return this.channelIdentification;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final ClinicalNoteGenerationSettings clinicalNoteGenerationSettings() {
        return this.clinicalNoteGenerationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clinicalNoteGenerationSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeSettings)) {
            return false;
        }
        MedicalScribeSettings other = (MedicalScribeSettings)obj;
        return Objects.equals(this.showSpeakerLabels(), other.showSpeakerLabels()) && Objects.equals(this.maxSpeakerLabels(), other.maxSpeakerLabels()) && Objects.equals(this.channelIdentification(), other.channelIdentification()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.clinicalNoteGenerationSettings(), other.clinicalNoteGenerationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeSettings").add("ShowSpeakerLabels", (Object)this.showSpeakerLabels()).add("MaxSpeakerLabels", (Object)this.maxSpeakerLabels()).add("ChannelIdentification", (Object)this.channelIdentification()).add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ClinicalNoteGenerationSettings", (Object)this.clinicalNoteGenerationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShowSpeakerLabels": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabels()));
            }
            case "MaxSpeakerLabels": {
                return Optional.ofNullable(clazz.cast(this.maxSpeakerLabels()));
            }
            case "ChannelIdentification": {
                return Optional.ofNullable(clazz.cast(this.channelIdentification()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ClinicalNoteGenerationSettings": {
                return Optional.ofNullable(clazz.cast(this.clinicalNoteGenerationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ShowSpeakerLabels", SHOW_SPEAKER_LABELS_FIELD);
        map.put("MaxSpeakerLabels", MAX_SPEAKER_LABELS_FIELD);
        map.put("ChannelIdentification", CHANNEL_IDENTIFICATION_FIELD);
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ClinicalNoteGenerationSettings", CLINICAL_NOTE_GENERATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeSettings, T> g) {
        return obj -> g.apply((MedicalScribeSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean showSpeakerLabels;
        private Integer maxSpeakerLabels;
        private Boolean channelIdentification;
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private ClinicalNoteGenerationSettings clinicalNoteGenerationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeSettings model) {
            this.showSpeakerLabels(model.showSpeakerLabels);
            this.maxSpeakerLabels(model.maxSpeakerLabels);
            this.channelIdentification(model.channelIdentification);
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.clinicalNoteGenerationSettings(model.clinicalNoteGenerationSettings);
        }

        public final Boolean getShowSpeakerLabels() {
            return this.showSpeakerLabels;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final Integer getMaxSpeakerLabels() {
            return this.maxSpeakerLabels;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final Boolean getChannelIdentification() {
            return this.channelIdentification;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final ClinicalNoteGenerationSettings.Builder getClinicalNoteGenerationSettings() {
            return this.clinicalNoteGenerationSettings != null ? this.clinicalNoteGenerationSettings.toBuilder() : null;
        }

        public final void setClinicalNoteGenerationSettings(ClinicalNoteGenerationSettings.BuilderImpl clinicalNoteGenerationSettings) {
            this.clinicalNoteGenerationSettings = clinicalNoteGenerationSettings != null ? clinicalNoteGenerationSettings.build() : null;
        }

        @Override
        public final Builder clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings clinicalNoteGenerationSettings) {
            this.clinicalNoteGenerationSettings = clinicalNoteGenerationSettings;
            return this;
        }

        public MedicalScribeSettings build() {
            return new MedicalScribeSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeSettings> {
        public Builder showSpeakerLabels(Boolean var1);

        public Builder maxSpeakerLabels(Integer var1);

        public Builder channelIdentification(Boolean var1);

        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder clinicalNoteGenerationSettings(ClinicalNoteGenerationSettings var1);

        default public Builder clinicalNoteGenerationSettings(Consumer<ClinicalNoteGenerationSettings.Builder> clinicalNoteGenerationSettings) {
            return this.clinicalNoteGenerationSettings((ClinicalNoteGenerationSettings)((ClinicalNoteGenerationSettings.Builder)ClinicalNoteGenerationSettings.builder().applyMutation(clinicalNoteGenerationSettings)).build());
        }
    }
}

