/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCallAnalyticsCategoryRequest extends TranscribeRequest implements
        ToCopyableBuilder<CreateCallAnalyticsCategoryRequest.Builder, CreateCallAnalyticsCategoryRequest> {
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryName").getter(getter(CreateCallAnalyticsCategoryRequest::categoryName))
            .setter(setter(Builder::categoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CreateCallAnalyticsCategoryRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCallAnalyticsCategoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(CreateCallAnalyticsCategoryRequest::inputTypeAsString))
            .setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_NAME_FIELD,
            RULES_FIELD, TAGS_FIELD, INPUT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String categoryName;

    private final List<Rule> rules;

    private final List<Tag> tags;

    private final String inputType;

    private CreateCallAnalyticsCategoryRequest(BuilderImpl builder) {
        super(builder);
        this.categoryName = builder.categoryName;
        this.rules = builder.rules;
        this.tags = builder.tags;
        this.inputType = builder.inputType;
    }

    /**
     * <p>
     * A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming system that
     * will make sense to you in the future. For example, it's better to use
     * <code>sentiment-positive-last30seconds</code> for a category over a generic name like <code>test-category</code>.
     * </p>
     * <p>
     * Category names are case sensitive.
     * </p>
     * 
     * @return A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming
     *         system that will make sense to you in the future. For example, it's better to use
     *         <code>sentiment-positive-last30seconds</code> for a category over a generic name like
     *         <code>test-category</code>.</p>
     *         <p>
     *         Category names are case sensitive.
     */
    public final String categoryName() {
        return categoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules for
     * that category. For each rule, you specify a filter you want applied to the attributes of a call. For example, you
     * can choose a sentiment filter that detects if a customer's sentiment was positive during the last 30 seconds of
     * the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20
     *         rules for that category. For each rule, you specify a filter you want applied to the attributes of a
     *         call. For example, you can choose a sentiment filter that detects if a customer's sentiment was positive
     *         during the last 30 seconds of the call.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the time
     * you start this new job.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at
     *         the time you start this new job.</p>
     *         <p>
     *         To learn more about using tags with Amazon Transcribe, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
     * </p>
     * <p>
     * Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this input
     * type cannot be applied to streaming (real-time) transcriptions.
     * </p>
     * <p>
     * Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this input
     * type cannot be applied to post-call transcriptions.
     * </p>
     * <p>
     * If you do not include <code>InputType</code>, your category is created as a post-call category by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return Choose whether you want to create a real-time or a post-call category for your Call Analytics
     *         transcription.</p>
     *         <p>
     *         Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this
     *         input type cannot be applied to streaming (real-time) transcriptions.
     *         </p>
     *         <p>
     *         Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this
     *         input type cannot be applied to post-call transcriptions.
     *         </p>
     *         <p>
     *         If you do not include <code>InputType</code>, your category is created as a post-call category by
     *         default.
     * @see InputType
     */
    public final InputType inputType() {
        return InputType.fromValue(inputType);
    }

    /**
     * <p>
     * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
     * </p>
     * <p>
     * Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this input
     * type cannot be applied to streaming (real-time) transcriptions.
     * </p>
     * <p>
     * Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this input
     * type cannot be applied to post-call transcriptions.
     * </p>
     * <p>
     * If you do not include <code>InputType</code>, your category is created as a post-call category by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link InputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return Choose whether you want to create a real-time or a post-call category for your Call Analytics
     *         transcription.</p>
     *         <p>
     *         Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this
     *         input type cannot be applied to streaming (real-time) transcriptions.
     *         </p>
     *         <p>
     *         Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this
     *         input type cannot be applied to post-call transcriptions.
     *         </p>
     *         <p>
     *         If you do not include <code>InputType</code>, your category is created as a post-call category by
     *         default.
     * @see InputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCallAnalyticsCategoryRequest)) {
            return false;
        }
        CreateCallAnalyticsCategoryRequest other = (CreateCallAnalyticsCategoryRequest) obj;
        return Objects.equals(categoryName(), other.categoryName()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCallAnalyticsCategoryRequest").add("CategoryName", categoryName())
                .add("Rules", hasRules() ? rules() : null).add("Tags", hasTags() ? tags() : null)
                .add("InputType", inputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryName":
            return Optional.ofNullable(clazz.cast(categoryName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategoryName", CATEGORY_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCallAnalyticsCategoryRequest, T> g) {
        return obj -> g.apply((CreateCallAnalyticsCategoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCallAnalyticsCategoryRequest> {
        /**
         * <p>
         * A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming system
         * that will make sense to you in the future. For example, it's better to use
         * <code>sentiment-positive-last30seconds</code> for a category over a generic name like
         * <code>test-category</code>.
         * </p>
         * <p>
         * Category names are case sensitive.
         * </p>
         * 
         * @param categoryName
         *        A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming
         *        system that will make sense to you in the future. For example, it's better to use
         *        <code>sentiment-positive-last30seconds</code> for a category over a generic name like
         *        <code>test-category</code>.</p>
         *        <p>
         *        Category names are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryName(String categoryName);

        /**
         * <p>
         * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules
         * for that category. For each rule, you specify a filter you want applied to the attributes of a call. For
         * example, you can choose a sentiment filter that detects if a customer's sentiment was positive during the
         * last 30 seconds of the call.
         * </p>
         * 
         * @param rules
         *        Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20
         *        rules for that category. For each rule, you specify a filter you want applied to the attributes of a
         *        call. For example, you can choose a sentiment filter that detects if a customer's sentiment was
         *        positive during the last 30 seconds of the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules
         * for that category. For each rule, you specify a filter you want applied to the attributes of a call. For
         * example, you can choose a sentiment filter that detects if a customer's sentiment was positive during the
         * last 30 seconds of the call.
         * </p>
         * 
         * @param rules
         *        Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20
         *        rules for that category. For each rule, you specify a filter you want applied to the attributes of a
         *        call. For example, you can choose a sentiment filter that detects if a customer's sentiment was
         *        positive during the last 30 seconds of the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules
         * for that category. For each rule, you specify a filter you want applied to the attributes of a call. For
         * example, you can choose a sentiment filter that detects if a customer's sentiment was positive during the
         * last 30 seconds of the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transcribe.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.Rule.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category
         *        at the time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category
         *        at the time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transcribe.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
         * </p>
         * <p>
         * Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this
         * input type cannot be applied to streaming (real-time) transcriptions.
         * </p>
         * <p>
         * Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this
         * input type cannot be applied to post-call transcriptions.
         * </p>
         * <p>
         * If you do not include <code>InputType</code>, your category is created as a post-call category by default.
         * </p>
         * 
         * @param inputType
         *        Choose whether you want to create a real-time or a post-call category for your Call Analytics
         *        transcription.</p>
         *        <p>
         *        Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with
         *        this input type cannot be applied to streaming (real-time) transcriptions.
         *        </p>
         *        <p>
         *        Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with
         *        this input type cannot be applied to post-call transcriptions.
         *        </p>
         *        <p>
         *        If you do not include <code>InputType</code>, your category is created as a post-call category by
         *        default.
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(String inputType);

        /**
         * <p>
         * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
         * </p>
         * <p>
         * Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this
         * input type cannot be applied to streaming (real-time) transcriptions.
         * </p>
         * <p>
         * Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this
         * input type cannot be applied to post-call transcriptions.
         * </p>
         * <p>
         * If you do not include <code>InputType</code>, your category is created as a post-call category by default.
         * </p>
         * 
         * @param inputType
         *        Choose whether you want to create a real-time or a post-call category for your Call Analytics
         *        transcription.</p>
         *        <p>
         *        Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with
         *        this input type cannot be applied to streaming (real-time) transcriptions.
         *        </p>
         *        <p>
         *        Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with
         *        this input type cannot be applied to post-call transcriptions.
         *        </p>
         *        <p>
         *        If you do not include <code>InputType</code>, your category is created as a post-call category by
         *        default.
         * @see InputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputType
         */
        Builder inputType(InputType inputType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String categoryName;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String inputType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCallAnalyticsCategoryRequest model) {
            super(model);
            categoryName(model.categoryName);
            rules(model.rules);
            tags(model.tags);
            inputType(model.inputType);
        }

        public final String getCategoryName() {
            return categoryName;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputType() {
            return inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCallAnalyticsCategoryRequest build() {
            return new CreateCallAnalyticsCategoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
